/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class UnionFunction
extends BaseFEELFunction {
    public UnionFunction() {
        super("union");
    }

    public FEELFnResult<List<Object>> invoke(@ParameterName(value="list") Object[] lists) {
        if (lists == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "lists", "cannot be null"));
        }
        LinkedHashSet<Object> resultSet = new LinkedHashSet<Object>();
        for (Object list : lists) {
            if (list instanceof Collection) {
                resultSet.addAll((Collection)list);
                continue;
            }
            resultSet.add(list);
        }
        return FEELFnResult.ofResult(new ArrayList(resultSet));
    }
}

