/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.ListNode;
import org.kie.dmn.feel.lang.ast.NameDefNode;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.runtime.functions.CustomFEELFunction;
import org.kie.dmn.feel.runtime.functions.JavaFunction;
import org.kie.dmn.feel.util.Msg;

public class FunctionDefNode
extends BaseNode {
    private static final String ANONYMOUS = "<anonymous>";
    private final Pattern METHOD_PARSER = Pattern.compile("(.+)\\((.*)\\)");
    private final Pattern PARAMETER_PARSER = Pattern.compile("([^, ]+)");
    private List<NameDefNode> formalParameters = new ArrayList<NameDefNode>();
    private boolean external;
    private BaseNode body;

    public FunctionDefNode(ParserRuleContext ctx, ListNode formalParameters, boolean external, BaseNode body) {
        super(ctx);
        this.external = external;
        this.body = body;
        if (formalParameters != null) {
            for (BaseNode name : formalParameters.getElements()) {
                this.formalParameters.add((NameDefNode)name);
            }
        }
    }

    public List<NameDefNode> getFormalParameters() {
        return this.formalParameters;
    }

    public void setFormalParameters(List<NameDefNode> formalParameters) {
        this.formalParameters = formalParameters;
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public BaseNode getBody() {
        return this.body;
    }

    public void setBody(BaseNode body) {
        this.body = body;
    }

    @Override
    public Object evaluate(EvaluationContext ctx) {
        List<String> params = this.formalParameters.stream().map(p -> p.evaluate(ctx)).collect(Collectors.toList());
        if (this.external) {
            try {
                Map conf = (Map)this.body.evaluate(ctx);
                Map java = (Map)conf.get("java");
                if (java != null) {
                    String[] mp;
                    Class<?> clazz;
                    String clazzName = (String)java.get("class");
                    String methodSignature = (String)java.get("method signature");
                    if (clazzName != null && methodSignature != null && (clazz = Class.forName(clazzName)) != null && (mp = this.parseMethod(methodSignature)) != null) {
                        String methodName = mp[0];
                        String[] paramTypeNames = this.parseParams(mp[1]);
                        int numberOfParams = paramTypeNames.length;
                        if (numberOfParams == params.size()) {
                            Class[] paramTypes = new Class[numberOfParams];
                            for (int i = 0; i < numberOfParams; ++i) {
                                paramTypes[i] = this.getType(paramTypeNames[i]);
                            }
                            Method method = clazz.getMethod(methodName, paramTypes);
                            return new JavaFunction(ANONYMOUS, params, clazz, method);
                        }
                        ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.PARAMETER_COUNT_MISMATCH_ON_FUNCTION_DEFINITION, this.getText())));
                        return null;
                    }
                }
                ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.UNABLE_TO_FIND_EXTERNAL_FUNCTION_AS_DEFINED_BY, this.getText())));
            }
            catch (Exception e) {
                ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.ERROR_RESOLVING_EXTERNAL_FUNCTION_AS_DEFINED_BY, this.getText()), e));
            }
            return null;
        }
        return new CustomFEELFunction(ANONYMOUS, params, this.body);
    }

    private Class<?> getType(String typeName) throws ClassNotFoundException {
        Class<?> type = FunctionDefNode.convertPrimitiveNameToType(typeName);
        if (type == null) {
            type = Class.forName(typeName);
        }
        return type;
    }

    public String[] parseMethod(String signature) {
        Matcher m = this.METHOD_PARSER.matcher(signature);
        if (m.matches()) {
            String[] result = new String[]{m.group(1), m.group(2)};
            return result;
        }
        return null;
    }

    public String[] parseParams(String params) {
        ArrayList<String> ps = new ArrayList<String>();
        if (params.trim().length() > 0) {
            Matcher m = this.PARAMETER_PARSER.matcher(params.trim());
            while (m.find()) {
                ps.add(m.group().trim());
            }
        }
        return ps.toArray(new String[ps.size()]);
    }

    public static Class<?> convertPrimitiveNameToType(String typeName) {
        if (typeName.equals("int")) {
            return Integer.TYPE;
        }
        if (typeName.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (typeName.equals("char")) {
            return Character.TYPE;
        }
        if (typeName.equals("byte")) {
            return Byte.TYPE;
        }
        if (typeName.equals("short")) {
            return Short.TYPE;
        }
        if (typeName.equals("float")) {
            return Float.TYPE;
        }
        if (typeName.equals("long")) {
            return Long.TYPE;
        }
        if (typeName.equals("double")) {
            return Double.TYPE;
        }
        return null;
    }

    @Override
    public Type getResultType() {
        return BuiltInType.FUNCTION;
    }
}

