/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import org.antlr.v4.runtime.ParserRuleContext;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.types.BuiltInType;

public class IfExpressionNode
extends BaseNode {
    private BaseNode condition;
    private BaseNode thenExpression;
    private BaseNode elseExpression;

    public IfExpressionNode(ParserRuleContext ctx, BaseNode condition, BaseNode thenExpression, BaseNode elseExpression) {
        super(ctx);
        this.condition = condition;
        this.thenExpression = thenExpression;
        this.elseExpression = elseExpression;
    }

    public BaseNode getCondition() {
        return this.condition;
    }

    public void setCondition(BaseNode condition) {
        this.condition = condition;
    }

    public BaseNode getThenExpression() {
        return this.thenExpression;
    }

    public void setThenExpression(BaseNode thenExpression) {
        this.thenExpression = thenExpression;
    }

    public BaseNode getElseExpression() {
        return this.elseExpression;
    }

    public void setElseExpression(BaseNode elseExpression) {
        this.elseExpression = elseExpression;
    }

    @Override
    public Object evaluate(EvaluationContext ctx) {
        Object cond = this.condition.evaluate(ctx);
        if (cond != null && cond instanceof Boolean && cond == Boolean.TRUE) {
            return this.thenExpression.evaluate(ctx);
        }
        return this.elseExpression.evaluate(ctx);
    }

    @Override
    public Type getResultType() {
        if (this.thenExpression.getResultType().equals(this.elseExpression.getResultType())) {
            return this.thenExpression.getResultType();
        }
        return BuiltInType.UNKNOWN;
    }
}

