/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class SortFunction
extends BaseFEELFunction {
    public SortFunction() {
        super("sort");
    }

    public FEELFnResult<List<Object>> invoke(@ParameterName(value="ctx") EvaluationContext ctx, @ParameterName(value="list") List list, @ParameterName(value="precedes") FEELFunction function) {
        if (function == null) {
            return this.invoke(list);
        }
        return this.invoke(list, (a, b) -> {
            Object result = function.invokeReflectively(ctx, new Object[]{a, b});
            if (!(result instanceof Boolean) || ((Boolean)result).booleanValue()) {
                return -1;
            }
            return 1;
        });
    }

    public FEELFnResult<List<Object>> invoke(@ParameterName(value="list") List list) {
        return this.invoke(list, (a, b) -> {
            if (a instanceof Comparable && b instanceof Comparable) {
                return ((Comparable)a).compareTo(b);
            }
            return 0;
        });
    }

    private FEELFnResult<List<Object>> invoke(List list, Comparator<? super Object> comparator) {
        if (list == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "list", "cannot be null"));
        }
        ArrayList<? super Object> newList = new ArrayList<Object>(list);
        try {
            newList.sort(comparator);
        }
        catch (Throwable ex) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "list", "raised an exception while sorting by natural order", ex));
        }
        return FEELFnResult.ofResult(newList);
    }
}

