/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.examples;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.api.feel.runtime.events.FEELEventListener;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.CompiledExpression;
import org.kie.dmn.feel.lang.CompilerContext;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.impl.MapBackedType;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.util.DynamicTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompileEvaluateTest {
    private static final Logger LOG = LoggerFactory.getLogger(CompileEvaluateTest.class);
    private static final FEEL feel = FEEL.newInstance();
    private List<FEELEvent> errors;
    private FEELEventListener errorsCountingListener;

    @Before
    public void before() {
        this.errors = new ArrayList<FEELEvent>();
        this.errorsCountingListener = evt -> {
            if (evt.getSeverity() == FEELEvent.Severity.ERROR) {
                this.errors.add(evt);
            }
        };
        feel.addListener(this.errorsCountingListener);
    }

    @After
    public void after() {
        feel.removeListener(this.errorsCountingListener);
    }

    @Test
    public void test_isDynamicResolution() {
        CompilerContext ctx = feel.newCompilerContext();
        ctx.addInputVariableType("Person List", (Type)BuiltInType.LIST);
        CompiledExpression compiledExpression = feel.compile("Person List[My Variable 1 = \"A\"]", ctx);
        MatcherAssert.assertThat((String)this.errors.toString(), (Object)this.errors.size(), (Matcher)Matchers.is((Object)0));
        HashMap inputs = new HashMap();
        ArrayList pList = new ArrayList();
        inputs.put("Person List", pList);
        pList.add(DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Full Name", "Edson Tirelli"), DynamicTypeUtils.entry("My Variable 1", "A")));
        pList.add(DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Full Name", "Matteo Mortari"), DynamicTypeUtils.entry("My Variable 1", "B")));
        Object result = feel.evaluate(compiledExpression, inputs);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.instanceOf(List.class));
        MatcherAssert.assertThat((Object)((List)result), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(((Map)((List)result).get(0)).get("Full Name"), (Matcher)Matchers.is((Object)"Edson Tirelli"));
    }

    @Test
    public void test2() {
        CompilerContext ctx = feel.newCompilerContext();
        ctx.addInputVariableType("MyPerson", (Type)new MapBackedType().addField("FullName", (Type)BuiltInType.STRING));
        CompiledExpression compiledExpression = feel.compile("MyPerson.fullName", ctx);
        MatcherAssert.assertThat((String)this.errors.toString(), (Object)this.errors.size(), (Matcher)Matchers.is((Object)1));
        HashMap inputs = new HashMap();
        inputs.put("MyPerson", DynamicTypeUtils.prototype(DynamicTypeUtils.entry("FullName", "John Doe")));
        Object result = feel.evaluate(compiledExpression, inputs);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.nullValue());
    }

    @Test
    public void test2OK() {
        CompilerContext ctx = feel.newCompilerContext();
        ctx.addInputVariableType("MyPerson", (Type)new MapBackedType().addField("FullName", (Type)BuiltInType.STRING));
        CompiledExpression compiledExpression = feel.compile("MyPerson.FullName", ctx);
        HashMap inputs = new HashMap();
        inputs.put("MyPerson", DynamicTypeUtils.prototype(DynamicTypeUtils.entry("FullName", "John Doe")));
        Object result = feel.evaluate(compiledExpression, inputs);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)"John Doe"));
    }

    static {
        feel.addListener(evt -> {
            if (evt.getSeverity() == FEELEvent.Severity.ERROR) {
                LOG.error("{}", (Object)evt);
                if (evt.getSourceException().getCause() != null) {
                    for (Throwable c = evt.getSourceException().getCause(); c != null; c = c.getCause()) {
                        LOG.error(" caused by: {} {}", c.getClass(), (Object)(c.getMessage() != null ? c.getMessage() : ""));
                    }
                    LOG.error(" [stacktraces omitted.]");
                }
            } else if (evt.getSeverity() == FEELEvent.Severity.WARN) {
                LOG.warn("{}", (Object)evt);
            }
        });
    }
}

