/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.EndsWithFunction;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;

public class EndsWithFunctionTest {
    private EndsWithFunction endsWithFunction;

    @Before
    public void setUp() {
        this.endsWithFunction = new EndsWithFunction();
    }

    @Test
    public void invokeParamsNull() {
        FunctionTestUtil.assertResultError(this.endsWithFunction.invoke((String)null, null), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.endsWithFunction.invoke(null, "test"), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.endsWithFunction.invoke("test", null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeEndsWith() {
        FunctionTestUtil.assertResult(this.endsWithFunction.invoke("test", "t"), true);
        FunctionTestUtil.assertResult(this.endsWithFunction.invoke("test", "st"), true);
        FunctionTestUtil.assertResult(this.endsWithFunction.invoke("test", "est"), true);
        FunctionTestUtil.assertResult(this.endsWithFunction.invoke("test", "test"), true);
    }

    @Test
    public void invokeNotEndsWith() {
        FunctionTestUtil.assertResult(this.endsWithFunction.invoke("test", "es"), false);
        FunctionTestUtil.assertResult(this.endsWithFunction.invoke("test", "ttttt"), false);
        FunctionTestUtil.assertResult(this.endsWithFunction.invoke("test", "estt"), false);
        FunctionTestUtil.assertResult(this.endsWithFunction.invoke("test", "tt"), false);
    }
}

