/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.Symbol;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.SortFunction;

public class SortFunctionTest {
    private SortFunction sortFunction;

    @Before
    public void setUp() {
        this.sortFunction = new SortFunction();
    }

    @Test
    public void invokeListParamNull() {
        FunctionTestUtil.assertResultError(this.sortFunction.invoke(null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeListEmpty() {
        FunctionTestUtil.assertResultList(this.sortFunction.invoke(Collections.emptyList()), Collections.emptyList());
    }

    @Test
    public void invokeListSingleItem() {
        FunctionTestUtil.assertResultList(this.sortFunction.invoke(Collections.singletonList(10)), Collections.singletonList(10));
    }

    @Test
    public void invokeListTypeHeterogenous() {
        FunctionTestUtil.assertResultError(this.sortFunction.invoke(Arrays.asList(10, "test", BigDecimal.TEN)), InvalidParametersEvent.class);
    }

    @Test
    public void invokeList() {
        FunctionTestUtil.assertResultList(this.sortFunction.invoke(Arrays.asList(10, 4, 5, 12)), Arrays.asList(4, 5, 10, 12));
        FunctionTestUtil.assertResultList(this.sortFunction.invoke(Arrays.asList("a", "c", "b")), Arrays.asList("a", "b", "c"));
    }

    @Test
    public void invokeWithSortFunctionNull() {
        FunctionTestUtil.assertResultList(this.sortFunction.invoke(null, Arrays.asList(10, 4, 5, 12), null), Arrays.asList(4, 5, 10, 12));
    }

    @Test
    public void invokeWithSortFunction() {
        FunctionTestUtil.assertResultList(this.sortFunction.invoke(null, Arrays.asList(10, 4, 5, 12), this.getBooleanFunction(true)), Arrays.asList(12, 5, 4, 10));
        FunctionTestUtil.assertResultList(this.sortFunction.invoke(null, Arrays.asList(10, 4, 5, 12), this.getBooleanFunction(false)), Arrays.asList(10, 4, 5, 12));
    }

    @Test
    public void invokeExceptionInSortFunction() {
        FunctionTestUtil.assertResultError(this.sortFunction.invoke(null, Arrays.asList(10, 4, 5, 12), this.getFunctionThrowingException()), InvalidParametersEvent.class);
    }

    private FEELFunction getBooleanFunction(final boolean functionResult) {
        return new FEELFunction(){

            public String getName() {
                return "alwaysBoolean";
            }

            public Symbol getSymbol() {
                return null;
            }

            public List<List<FEELFunction.Param>> getParameters() {
                return null;
            }

            public Object invokeReflectively(EvaluationContext ctx, Object[] params) {
                return functionResult;
            }
        };
    }

    private FEELFunction getFunctionThrowingException() {
        return new FEELFunction(){

            public String getName() {
                return "throwException";
            }

            public Symbol getSymbol() {
                return null;
            }

            public List<List<FEELFunction.Param>> getParameters() {
                return null;
            }

            public Object invokeReflectively(EvaluationContext ctx, Object[] params) {
                throw new IllegalStateException("test exception");
            }
        };
    }
}

