/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.StringLowerCaseFunction;

public class StringLowerCaseFunctionTest {
    private StringLowerCaseFunction stringLowerCaseFunction;

    @Before
    public void setUp() {
        this.stringLowerCaseFunction = new StringLowerCaseFunction();
    }

    @Test
    public void invokeNull() {
        FunctionTestUtil.assertResultError(this.stringLowerCaseFunction.invoke(null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeLowercaseString() {
        FunctionTestUtil.assertResult(this.stringLowerCaseFunction.invoke("teststring"), "teststring");
    }

    @Test
    public void invokeUppercaseString() {
        FunctionTestUtil.assertResult(this.stringLowerCaseFunction.invoke("TESTSTRING"), "teststring");
    }

    @Test
    public void invokeMixedCaseString() {
        FunctionTestUtil.assertResult(this.stringLowerCaseFunction.invoke("testSTRing"), "teststring");
    }
}

