/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions.twovaluelogic;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.twovaluelogic.NNAllFunction;

public class NNAllFunctionTest {
    private NNAllFunction NNAllFunction;

    @Before
    public void setUp() {
        this.NNAllFunction = new NNAllFunction();
    }

    @Test
    public void invokeBooleanParamNull() {
        FunctionTestUtil.assertResult(this.NNAllFunction.invoke((Boolean)null), true);
    }

    @Test
    public void invokeBooleanParamTrue() {
        FunctionTestUtil.assertResult(this.NNAllFunction.invoke(Boolean.valueOf(true)), true);
    }

    @Test
    public void invokeBooleanParamFalse() {
        FunctionTestUtil.assertResult(this.NNAllFunction.invoke(Boolean.valueOf(false)), false);
    }

    @Test
    public void invokeArrayParamNull() {
        FunctionTestUtil.assertResult(this.NNAllFunction.invoke((Object[])null), true);
    }

    @Test
    public void invokeArrayParamEmptyArray() {
        FunctionTestUtil.assertResult(this.NNAllFunction.invoke(new Object[0]), true);
    }

    @Test
    public void invokeArrayParamReturnTrue() {
        FunctionTestUtil.assertResult(this.NNAllFunction.invoke(new Object[]{Boolean.TRUE, Boolean.TRUE}), true);
    }

    @Test
    public void invokeArrayParamReturnFalse() {
        FunctionTestUtil.assertResult(this.NNAllFunction.invoke(new Object[]{Boolean.TRUE, Boolean.FALSE}), false);
        FunctionTestUtil.assertResult(this.NNAllFunction.invoke(new Object[]{Boolean.TRUE, null, Boolean.FALSE}), false);
    }

    @Test
    public void invokeArrayParamReturnNull() {
        FunctionTestUtil.assertResult(this.NNAllFunction.invoke(new Object[]{Boolean.TRUE, null, Boolean.TRUE}), true);
    }

    @Test
    public void invokeArrayParamTypeHeterogenousArray() {
        FunctionTestUtil.assertResultError(this.NNAllFunction.invoke(new Object[]{Boolean.TRUE, 1}), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.NNAllFunction.invoke(new Object[]{Boolean.FALSE, 1}), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.NNAllFunction.invoke(new Object[]{Boolean.TRUE, null, 1}), InvalidParametersEvent.class);
    }

    @Test
    public void invokeListParamNull() {
        FunctionTestUtil.assertResult(this.NNAllFunction.invoke((List)null), true);
    }

    @Test
    public void invokeListParamEmptyList() {
        FunctionTestUtil.assertResult(this.NNAllFunction.invoke(Collections.emptyList()), true);
    }

    @Test
    public void invokeListParamReturnTrue() {
        FunctionTestUtil.assertResult(this.NNAllFunction.invoke(Arrays.asList(Boolean.TRUE, Boolean.TRUE)), true);
    }

    @Test
    public void invokeListParamReturnFalse() {
        FunctionTestUtil.assertResult(this.NNAllFunction.invoke(Arrays.asList(Boolean.TRUE, Boolean.FALSE)), false);
        FunctionTestUtil.assertResult(this.NNAllFunction.invoke(Arrays.asList(Boolean.TRUE, null, Boolean.FALSE)), false);
    }

    @Test
    public void invokeListParamReturnNull() {
        FunctionTestUtil.assertResult(this.NNAllFunction.invoke(Arrays.asList(Boolean.TRUE, null, Boolean.TRUE)), true);
    }

    @Test
    public void invokeListParamTypeHeterogenousArray() {
        FunctionTestUtil.assertResultError(this.NNAllFunction.invoke(Arrays.asList(Boolean.TRUE, 1)), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.NNAllFunction.invoke(Arrays.asList(Boolean.FALSE, 1)), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.NNAllFunction.invoke(Arrays.asList(Boolean.TRUE, null, 1)), InvalidParametersEvent.class);
    }
}

