/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.antlr.v4.runtime.tree.ParseTree;
import org.kie.dmn.api.feel.runtime.events.FEELEventListener;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.CompiledExpression;
import org.kie.dmn.feel.lang.CompilerContext;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.FEELProfile;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.DashNode;
import org.kie.dmn.feel.lang.ast.ListNode;
import org.kie.dmn.feel.lang.ast.RangeNode;
import org.kie.dmn.feel.lang.ast.UnaryTestNode;
import org.kie.dmn.feel.lang.impl.CompiledExpressionImpl;
import org.kie.dmn.feel.lang.impl.CompilerContextImpl;
import org.kie.dmn.feel.lang.impl.EvaluationContextImpl;
import org.kie.dmn.feel.lang.impl.ExecutionFrameImpl;
import org.kie.dmn.feel.lang.impl.FEELEventListenersManager;
import org.kie.dmn.feel.parser.feel11.ASTBuilderVisitor;
import org.kie.dmn.feel.parser.feel11.FEELParser;
import org.kie.dmn.feel.parser.feel11.FEEL_1_1Parser;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.runtime.UnaryTest;

public class FEELImpl
implements FEEL {
    private static final Map<String, Object> EMPTY_INPUT = Collections.emptyMap();
    private Set<FEELEventListener> instanceEventListeners = new HashSet<FEELEventListener>();
    private final List<FEELProfile> profiles;
    private final Optional<ExecutionFrameImpl> customFrame;
    private final Collection<FEELFunction> customFunctions;

    public FEELImpl() {
        this(Collections.emptyList());
    }

    public FEELImpl(List<FEELProfile> profiles) {
        this.profiles = Collections.unmodifiableList(profiles);
        ExecutionFrameImpl frame = new ExecutionFrameImpl(null);
        HashMap<String, FEELFunction> functions = new HashMap<String, FEELFunction>();
        for (FEELProfile p : profiles) {
            for (FEELFunction f : p.getFEELFunctions()) {
                frame.setValue(f.getName(), f);
                functions.put(f.getName(), f);
            }
        }
        this.customFrame = Optional.of(frame);
        this.customFunctions = Collections.unmodifiableCollection(functions.values());
    }

    @Override
    public CompilerContext newCompilerContext() {
        return this.newCompilerContext(Collections.emptySet());
    }

    public CompilerContext newCompilerContext(Collection<FEELEventListener> contextListeners) {
        return new CompilerContextImpl(this.getEventsManager(contextListeners)).addFEELFunctions((Collection)this.customFunctions);
    }

    @Override
    public CompiledExpression compile(String expression, CompilerContext ctx) {
        FEEL_1_1Parser parser = FEELParser.parse(this.getEventsManager(ctx.getListeners()), expression, ctx.getInputVariableTypes(), ctx.getInputVariables(), ctx.getFEELFunctions(), this.profiles);
        FEEL_1_1Parser.Compilation_unitContext tree = parser.compilation_unit();
        ASTBuilderVisitor v = new ASTBuilderVisitor(ctx.getInputVariableTypes());
        BaseNode expr = (BaseNode)v.visit((ParseTree)tree);
        CompiledExpressionImpl ce = new CompiledExpressionImpl(expr);
        return ce;
    }

    public CompiledExpression compileExpressionList(String expression, CompilerContext ctx) {
        FEEL_1_1Parser parser = FEELParser.parse(this.getEventsManager(ctx.getListeners()), expression, ctx.getInputVariableTypes(), ctx.getInputVariables(), ctx.getFEELFunctions(), this.profiles);
        FEEL_1_1Parser.ExpressionListContext tree = parser.expressionList();
        ASTBuilderVisitor v = new ASTBuilderVisitor(ctx.getInputVariableTypes());
        BaseNode expr = (BaseNode)v.visit((ParseTree)tree);
        CompiledExpressionImpl ce = new CompiledExpressionImpl(expr);
        return ce;
    }

    @Override
    public Object evaluate(String expression) {
        return this.evaluate(expression, EMPTY_INPUT);
    }

    @Override
    public Object evaluate(String expression, EvaluationContext ctx) {
        CompilerContext compilerCtx = this.newCompilerContext(ctx.getListeners());
        Map<String, Object> inputVariables = ctx.getAllValues();
        if (inputVariables != null) {
            inputVariables.entrySet().stream().forEach(e -> compilerCtx.addInputVariable((String)e.getKey(), e.getValue()));
        }
        CompiledExpression expr = this.compile(expression, compilerCtx);
        return this.evaluate(expr, ctx);
    }

    @Override
    public Object evaluate(String expression, Map<String, Object> inputVariables) {
        CompilerContext ctx = this.newCompilerContext();
        if (inputVariables != null) {
            inputVariables.entrySet().stream().forEach(e -> ctx.addInputVariable((String)e.getKey(), e.getValue()));
        }
        CompiledExpression expr = this.compile(expression, ctx);
        if (inputVariables == null) {
            return this.evaluate(expr, EMPTY_INPUT);
        }
        return this.evaluate(expr, inputVariables);
    }

    @Override
    public Object evaluate(CompiledExpression expr, Map<String, Object> inputVariables) {
        return ((CompiledExpressionImpl)expr).evaluate(this.newEvaluationContext(Collections.EMPTY_SET, inputVariables));
    }

    @Override
    public Object evaluate(CompiledExpression expr, EvaluationContext ctx) {
        return ((CompiledExpressionImpl)expr).evaluate(this.newEvaluationContext(ctx.getListeners(), ctx.getAllValues()));
    }

    public EvaluationContextImpl newEvaluationContext(Collection<FEELEventListener> listeners, Map<String, Object> inputVariables) {
        FEELEventListenersManager eventsManager = this.getEventsManager(listeners);
        EvaluationContextImpl ctx = new EvaluationContextImpl(eventsManager);
        if (this.customFrame.isPresent()) {
            ExecutionFrameImpl globalFrame = (ExecutionFrameImpl)ctx.pop();
            ExecutionFrameImpl interveawedFrame = this.customFrame.get();
            interveawedFrame.setParentFrame(ctx.peek());
            globalFrame.setParentFrame(interveawedFrame);
            ctx.push(interveawedFrame);
            ctx.push(globalFrame);
        }
        ctx.setValues(inputVariables);
        return ctx;
    }

    @Override
    public List<UnaryTest> evaluateUnaryTests(String expression) {
        return this.evaluateUnaryTests(expression, Collections.emptyMap());
    }

    @Override
    public List<UnaryTest> evaluateUnaryTests(String expression, Map<String, Type> variableTypes) {
        CompilerContext ctx = this.newCompilerContext();
        for (Map.Entry<String, Type> e : variableTypes.entrySet()) {
            ctx.addInputVariableType(e.getKey(), e.getValue());
        }
        CompiledExpressionImpl compiledExpression = (CompiledExpressionImpl)this.compileExpressionList(expression, ctx);
        if (compiledExpression != null) {
            ListNode listNode = (ListNode)compiledExpression.getExpression();
            ArrayList<BaseNode> tests = new ArrayList<BaseNode>();
            for (BaseNode o : listNode.getElements()) {
                if (o == null) continue;
                if (o instanceof UnaryTestNode || o instanceof DashNode) {
                    tests.add(o);
                    continue;
                }
                if (o instanceof RangeNode || o instanceof ListNode) {
                    tests.add(new UnaryTestNode("in", o));
                    continue;
                }
                tests.add(new UnaryTestNode("=", o));
            }
            listNode.setElements(tests);
            compiledExpression.setExpression(listNode);
            List uts = (List)this.evaluate((CompiledExpression)compiledExpression, EMPTY_INPUT);
            return uts;
        }
        return Collections.emptyList();
    }

    @Override
    public void addListener(FEELEventListener listener) {
        this.instanceEventListeners.add(listener);
    }

    @Override
    public void removeListener(FEELEventListener listener) {
        this.instanceEventListeners.remove(listener);
    }

    @Override
    public Set<FEELEventListener> getListeners() {
        return Collections.unmodifiableSet(this.instanceEventListeners);
    }

    public FEELEventListenersManager getEventsManager(Collection<FEELEventListener> contextListeners) {
        FEELEventListenersManager listenerMgr = new FEELEventListenersManager();
        listenerMgr.addListeners(this.instanceEventListeners);
        listenerMgr.addListeners(contextListeners);
        return listenerMgr;
    }
}

