/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.impl;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.dmn.feel.lang.impl.ExecutionFrame;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.runtime.functions.BuiltInFunctions;
import org.kie.dmn.feel.util.EvalHelper;

public class RootExecutionFrame
implements ExecutionFrame {
    public static final ExecutionFrame INSTANCE = new RootExecutionFrame();
    private final Map<String, Object> functions;

    private RootExecutionFrame() {
        ConcurrentHashMap<String, FEELFunction> builtIn = new ConcurrentHashMap<String, FEELFunction>();
        for (FEELFunction f : BuiltInFunctions.getFunctions()) {
            builtIn.put(EvalHelper.normalizeVariableName(f.getName()), f);
        }
        this.functions = Collections.unmodifiableMap(builtIn);
    }

    @Override
    public Object getValue(String symbol) {
        if (this.functions.containsKey(symbol = EvalHelper.normalizeVariableName(symbol))) {
            return this.functions.get(symbol);
        }
        return null;
    }

    @Override
    public boolean isDefined(String symbol) {
        symbol = EvalHelper.normalizeVariableName(symbol);
        return this.functions.containsKey(symbol);
    }

    @Override
    public void setValue(String symbol, Object value) {
        throw new UnsupportedOperationException("No value or variable can be set on the RootExecutionFrame");
    }

    @Override
    public Map<String, Object> getAllValues() {
        return this.functions;
    }

    @Override
    public void setRootObject(Object v) {
        throw new UnsupportedOperationException("Setting root object is not supported on the Root frame");
    }

    @Override
    public Object getRootObject() {
        return null;
    }
}

