/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.ast.ASTNode;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.impl.SilentWrappingEvaluationContextImpl;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.util.Msg;

public class FilterExpressionNode
extends BaseNode {
    private BaseNode expression;
    private BaseNode filter;

    public FilterExpressionNode(ParserRuleContext ctx, BaseNode expression, BaseNode filter) {
        super(ctx);
        this.expression = expression;
        this.filter = filter;
    }

    public BaseNode getExpression() {
        return this.expression;
    }

    public void setExpression(BaseNode expression) {
        this.expression = expression;
    }

    public BaseNode getFilter() {
        return this.filter;
    }

    public void setFilter(BaseNode filter) {
        this.filter = filter;
    }

    @Override
    public Object evaluate(EvaluationContext ctx) {
        if (this.expression == null) {
            return null;
        }
        Object value = this.expression.evaluate(ctx);
        List<Object> list = value instanceof List ? (List<Object>)value : Arrays.asList(value);
        try {
            if (this.filter.getResultType() != BuiltInType.BOOLEAN) {
                Object f = this.filter.evaluate(new SilentWrappingEvaluationContextImpl(ctx));
                if (f != null && f instanceof Number) {
                    int i = ((Number)f).intValue();
                    if (i > 0 && i <= list.size()) {
                        return list.get(i - 1);
                    }
                    if (i < 0 && Math.abs(i) <= list.size()) {
                        return list.get(list.size() + i);
                    }
                    ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.INDEX_OUT_OF_BOUND)));
                    return null;
                }
                return this.evaluateExpressionsInContext(ctx, list);
            }
            return this.evaluateExpressionsInContext(ctx, list);
        }
        catch (Exception e) {
            ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.ERROR_EXECUTING_LIST_FILTER, this.getText()), e));
            return null;
        }
    }

    private List evaluateExpressionsInContext(EvaluationContext ctx, List expressions) {
        ArrayList results = new ArrayList();
        expressions.forEach(expression -> this.evaluateExpressionInContext(ctx, results, expression));
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateExpressionInContext(EvaluationContext ctx, List results, Object v) {
        try {
            ctx.enterFrame();
            ctx.setValue("item", v);
            ctx.setRootObject(v);
            Object r = this.filter.evaluate(new SilentWrappingEvaluationContextImpl(ctx));
            if (r instanceof Boolean && (Boolean)r == Boolean.TRUE) {
                results.add(v);
            }
        }
        finally {
            ctx.exitFrame();
        }
    }

    @Override
    public ASTNode[] getChildrenNode() {
        return new ASTNode[]{this.expression, this.filter};
    }
}

