/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.decisiontables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.runtime.UnaryTest;

public class DTOutputClause {
    private final String name;
    private final String id;
    private final String defaultValue;
    private final List<UnaryTest> outputValues;
    private final Type type;
    private final boolean collection;

    public DTOutputClause(String name, List<UnaryTest> outputValues) {
        this(name, null, outputValues, null);
    }

    public DTOutputClause(String name, String id, List<UnaryTest> outputValues, String defaultValue) {
        this(name, id, outputValues, defaultValue, BuiltInType.UNKNOWN, false);
    }

    public DTOutputClause(String name, String id, List<UnaryTest> outputValues, String defaultValue, Type feelType, boolean isCollection) {
        this.name = name;
        this.id = id;
        this.defaultValue = defaultValue;
        this.outputValues = outputValues != null ? Collections.unmodifiableList(new ArrayList<UnaryTest>(outputValues)) : Collections.emptyList();
        this.type = feelType;
        this.collection = isCollection;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public List<UnaryTest> getOutputValues() {
        return this.outputValues;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isCollection() {
        return this.collection;
    }
}

