/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.decisiontables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.CompiledExpression;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.impl.CompiledExpressionImpl;
import org.kie.dmn.feel.lang.impl.EvaluationContextImpl;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.feel.runtime.decisiontables.DTDecisionRule;
import org.kie.dmn.feel.runtime.decisiontables.DTInputClause;
import org.kie.dmn.feel.runtime.decisiontables.DTOutputClause;
import org.kie.dmn.feel.runtime.decisiontables.HitPolicy;
import org.kie.dmn.feel.runtime.events.DecisionTableRulesMatchedEvent;
import org.kie.dmn.feel.runtime.events.FEELEventBase;
import org.kie.dmn.feel.runtime.events.HitPolicyViolationEvent;
import org.kie.dmn.feel.runtime.events.InvalidInputEvent;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.util.Either;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecisionTableImpl {
    private static final Logger logger = LoggerFactory.getLogger(DecisionTableImpl.class);
    private String name;
    private List<String> parameterNames;
    private List<DTInputClause> inputs;
    private List<DTOutputClause> outputs;
    private List<DTDecisionRule> decisionRules;
    private HitPolicy hitPolicy;
    private boolean hasDefaultValues;
    private FEEL feel;

    public DecisionTableImpl(String name, List<String> parameterNames, List<DTInputClause> inputs, List<DTOutputClause> outputs, List<DTDecisionRule> decisionRules, HitPolicy hitPolicy, FEEL feel) {
        this.name = name;
        this.parameterNames = parameterNames;
        this.inputs = inputs;
        this.outputs = outputs;
        this.decisionRules = decisionRules;
        this.hitPolicy = hitPolicy;
        this.hasDefaultValues = outputs.stream().allMatch(o -> o.getDefaultValue() != null);
        this.feel = feel;
    }

    public FEELFnResult<Object> evaluate(EvaluationContext ctx, Object[] params) {
        if (this.decisionRules.isEmpty()) {
            return FEELFnResult.ofError(new FEELEventBase(FEELEvent.Severity.WARN, "Decision table is empty", null));
        }
        Object[] actualInputs = this.resolveActualInputs(ctx, this.feel);
        Either<FEELEvent, Object> actualInputMatch = this.actualInputsMatchInputValues(ctx, actualInputs);
        if (actualInputMatch.isLeft()) {
            return actualInputMatch.cata(e -> FEELFnResult.ofError(e), e -> FEELFnResult.ofError(null));
        }
        List<DTDecisionRule> matches = this.findMatches(ctx, actualInputs);
        if (!matches.isEmpty()) {
            List<Object> results = this.evaluateResults(ctx, this.feel, actualInputs, matches);
            Map<Integer, String> msgs = this.checkResults(ctx, matches, results);
            if (msgs.isEmpty()) {
                Object result = this.hitPolicy.getDti().dti(ctx, this, actualInputs, matches, results);
                return FEELFnResult.ofResult(result);
            }
            List<Integer> offending = msgs.keySet().stream().collect(Collectors.toList());
            return FEELFnResult.ofError(new HitPolicyViolationEvent(FEELEvent.Severity.ERROR, "Errors found evaluating decision table '" + this.getName() + "': \n" + msgs.values().stream().collect(Collectors.joining("\n")), this.name, offending));
        }
        if (this.hasDefaultValues) {
            Object result = this.defaultToOutput(ctx, this.feel);
            return FEELFnResult.ofResult(result);
        }
        if (this.hitPolicy.getDefaultValue() != null) {
            return FEELFnResult.ofResult(this.hitPolicy.getDefaultValue());
        }
        return FEELFnResult.ofError(new HitPolicyViolationEvent(FEELEvent.Severity.WARN, "No rule matched for decision table '" + this.name + "' and no default values were defined. Setting result to null.", this.name, Collections.EMPTY_LIST));
    }

    private Map<Integer, String> checkResults(EvaluationContext ctx, List<DTDecisionRule> matches, List<Object> results) {
        TreeMap<Integer, String> msgs = new TreeMap<Integer, String>();
        int i = 0;
        for (Object result : results) {
            if (this.outputs.size() == 1) {
                this.checkOneResult(ctx, matches.get(i), msgs, this.outputs.get(0), result);
            } else if (this.outputs.size() > 1) {
                Map r = (Map)result;
                for (DTOutputClause output : this.outputs) {
                    this.checkOneResult(ctx, matches.get(i), msgs, output, r.get(output.getName()));
                }
            }
            ++i;
        }
        return msgs;
    }

    private void checkOneResult(EvaluationContext ctx, DTDecisionRule rule, Map<Integer, String> msgs, DTOutputClause dtOutputClause, Object result) {
        if (dtOutputClause.isCollection() && result instanceof Collection) {
            for (Object value : (Collection)result) {
                this.checkOneValue(ctx, rule, msgs, dtOutputClause, value);
            }
        } else {
            this.checkOneValue(ctx, rule, msgs, dtOutputClause, result);
        }
    }

    private void checkOneValue(EvaluationContext ctx, DTDecisionRule rule, Map<Integer, String> msgs, DTOutputClause dtOutputClause, Object value) {
        if (((EvaluationContextImpl)ctx).isPerformRuntimeTypeCheck() && !dtOutputClause.getType().isAssignableValue(value)) {
            int index = this.outputs.indexOf(dtOutputClause) + 1;
            msgs.put(index, "Invalid result type on rule #" + rule.getIndex() + ", output " + (dtOutputClause.getName() != null ? "'" + dtOutputClause.getName() + "'" : "#" + index) + ". Value " + value + " is not of type " + dtOutputClause.getType().getName() + ".");
            return;
        }
        if (dtOutputClause.getOutputValues() != null && !dtOutputClause.getOutputValues().isEmpty()) {
            boolean found = false;
            for (UnaryTest test : dtOutputClause.getOutputValues()) {
                Boolean succeeded = (Boolean)test.apply(ctx, value);
                if (succeeded == null || !succeeded.booleanValue()) continue;
                found = true;
            }
            if (!found) {
                int index = this.outputs.indexOf(dtOutputClause) + 1;
                msgs.put(index, "Invalid result value on rule #" + rule.getIndex() + ", output " + (dtOutputClause.getName() != null ? "'" + dtOutputClause.getName() + "'" : "#" + index) + ". Value " + value + " does not match list of allowed values.");
            }
        }
    }

    private Object[] resolveActualInputs(EvaluationContext ctx, FEEL feel) {
        Map<String, Object> variables = ctx.getAllValues();
        Object[] actualInputs = new Object[this.inputs.size()];
        for (int i = 0; i < this.inputs.size(); ++i) {
            CompiledExpression compiledInput = this.inputs.get(i).getCompiledInput();
            actualInputs[i] = compiledInput != null ? feel.evaluate(compiledInput, variables) : feel.evaluate(this.inputs.get(i).getInputExpression(), variables);
        }
        return actualInputs;
    }

    private Either<FEELEvent, Object> actualInputsMatchInputValues(EvaluationContext ctx, Object[] params) {
        for (int i = 0; i < params.length; ++i) {
            DTInputClause input = this.inputs.get(i);
            if (input.getInputValues() == null || input.getInputValues().isEmpty()) continue;
            Object parameter = params[i];
            boolean satisfies = input.getInputValues().stream().map(ut -> (Boolean)ut.apply(ctx, parameter)).filter(Boolean::booleanValue).findAny().orElse(false);
            if (satisfies) continue;
            String values = input.getInputValuesText();
            return Either.ofLeft(new InvalidInputEvent(FEELEvent.Severity.ERROR, input.getInputExpression() + "='" + parameter + "' does not match any of the valid values " + values + " for decision table '" + this.getName() + "'.", this.getName(), null, values));
        }
        return Either.ofRight(true);
    }

    private List<DTDecisionRule> findMatches(EvaluationContext ctx, Object[] params) {
        ArrayList<DTDecisionRule> matchingDecisionRules = new ArrayList<DTDecisionRule>();
        for (DTDecisionRule decisionRule : this.decisionRules) {
            if (!this.matches(ctx, params, decisionRule)) continue;
            matchingDecisionRules.add(decisionRule);
        }
        ctx.notifyEvt(() -> {
            List<Integer> matches = matchingDecisionRules.stream().map(dr -> dr.getIndex() + 1).collect(Collectors.toList());
            return new DecisionTableRulesMatchedEvent(FEELEvent.Severity.INFO, "Rules matched for decision table '" + this.getName() + "': " + matches.toString(), this.getName(), this.getName(), matches);
        });
        return matchingDecisionRules;
    }

    private boolean matches(EvaluationContext ctx, Object[] params, DTDecisionRule rule) {
        for (int i = 0; i < params.length; ++i) {
            CompiledExpression compiledInput = this.inputs.get(i).getCompiledInput();
            if (compiledInput instanceof CompiledExpressionImpl) {
                ctx.setValue("?", ((CompiledExpressionImpl)compiledInput).evaluate(ctx));
            }
            if (this.satisfies(ctx, params[i], rule.getInputEntry().get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean satisfies(EvaluationContext ctx, Object param, UnaryTest test) {
        return (Boolean)test.apply(ctx, param);
    }

    private List<Object> evaluateResults(EvaluationContext ctx, FEEL feel, Object[] params, List<DTDecisionRule> matchingDecisionRules) {
        List<Object> results = matchingDecisionRules.stream().map(dr -> this.hitToOutput(ctx, feel, (DTDecisionRule)dr)).collect(Collectors.toList());
        return results;
    }

    private Object hitToOutput(EvaluationContext ctx, FEEL feel, DTDecisionRule rule) {
        List<CompiledExpression> outputEntries = rule.getOutputEntry();
        Map<String, Object> values = ctx.getAllValues();
        if (outputEntries.size() == 1) {
            Object value = feel.evaluate(outputEntries.get(0), values);
            return value;
        }
        HashMap<String, Object> output = new HashMap<String, Object>();
        for (int i = 0; i < this.outputs.size(); ++i) {
            output.put(this.outputs.get(i).getName(), feel.evaluate(outputEntries.get(i), values));
        }
        return output;
    }

    private Object defaultToOutput(EvaluationContext ctx, FEEL feel) {
        Map<String, Object> values = ctx.getAllValues();
        if (this.outputs.size() == 1) {
            Object value = feel.evaluate(this.outputs.get(0).getDefaultValue(), values);
            return value;
        }
        return IntStream.range(0, this.outputs.size()).boxed().collect(Collectors.toMap(i -> this.outputs.get((int)i).getName(), i -> feel.evaluate(this.outputs.get((int)i).getDefaultValue(), values)));
    }

    public HitPolicy getHitPolicy() {
        return this.hitPolicy;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<DTOutputClause> getOutputs() {
        return this.outputs;
    }

    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    public String getSignature() {
        return this.getName() + "( " + this.parameterNames.stream().collect(Collectors.joining(", ")) + " )";
    }
}

