/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import java.util.List;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class SublistFunction
extends BaseFEELFunction {
    public SublistFunction() {
        super("sublist");
    }

    public FEELFnResult<List> invoke(@ParameterName(value="list") List list, @ParameterName(value="start position") BigDecimal start) {
        return this.invoke(list, start, null);
    }

    public FEELFnResult<List> invoke(@ParameterName(value="list") List list, @ParameterName(value="start position") BigDecimal start, @ParameterName(value="length") BigDecimal length) {
        int end;
        if (list == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "list", "cannot be null"));
        }
        if (start == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "start", "cannot be null"));
        }
        if (start.equals(BigDecimal.ZERO)) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "start", "cannot be zero"));
        }
        if (start.abs().intValue() > list.size()) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "start", "is inconsistent with 'list' size"));
        }
        if (length != null && length.compareTo(BigDecimal.ZERO) <= 0) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "length", "must be a positive number when specified"));
        }
        if (start.intValue() > 0) {
            int end2;
            int n = end2 = length != null ? start.intValue() - 1 + length.intValue() : list.size();
            if (end2 > list.size()) {
                return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "attempting to create a sublist bigger than the original list"));
            }
            return FEELFnResult.ofResult(list.subList(start.intValue() - 1, end2));
        }
        int n = end = length != null ? list.size() + start.intValue() + length.intValue() : list.size();
        if (end > list.size()) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "attempting to create a sublist bigger than the original list"));
        }
        return FEELFnResult.ofResult(list.subList(list.size() + start.intValue(), end));
    }
}

