/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class SubstringFunction
extends BaseFEELFunction {
    public SubstringFunction() {
        super("substring");
    }

    public FEELFnResult<String> invoke(@ParameterName(value="string") String string, @ParameterName(value="start position") Number start) {
        return this.invoke(string, start, null);
    }

    public FEELFnResult<String> invoke(@ParameterName(value="string") String string, @ParameterName(value="start position") Number start, @ParameterName(value="length") Number length) {
        if (string == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "string", "cannot be null"));
        }
        if (start == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "start position", "cannot be null"));
        }
        if (length != null && length.intValue() <= 0) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "length", "must be a positive number when specified"));
        }
        if (Math.abs(start.intValue()) > string.length()) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "parameter 'start position' inconsistent with parameter 'string' length"));
        }
        if (start.intValue() > 0) {
            int end = length != null ? Math.min(string.length(), start.intValue() + length.intValue() - 1) : string.length();
            return FEELFnResult.ofResult(string.substring(start.intValue() - 1, end));
        }
        if (start.intValue() < 0) {
            int end = length != null ? Math.min(string.length(), string.length() + start.intValue() + length.intValue()) : string.length();
            return FEELFnResult.ofResult(string.substring(string.length() + start.intValue(), end));
        }
        return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "start position", "cannot be zero"));
    }
}

