/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions.extended;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;
import org.kie.dmn.feel.util.EvalHelper;

public class SqrtFunction
extends BaseFEELFunction {
    public static final SqrtFunction INSTANCE = new SqrtFunction();
    private static final BigDecimal TWO = new BigDecimal(2.0, MathContext.DECIMAL128);

    SqrtFunction() {
        super("sqrt");
    }

    public FEELFnResult<BigDecimal> invoke(@ParameterName(value="number") BigDecimal number) {
        if (number == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "number", "cannot be null"));
        }
        if (number.signum() < 0) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "number", "is negative"));
        }
        return FEELFnResult.ofResult(SqrtFunction.sqrt(EvalHelper.getBigDecimalOrNull(number)));
    }

    static BigDecimal sqrt(BigDecimal arg) {
        BigDecimal low = new BigDecimal(Math.sqrt(arg.doubleValue()), MathContext.DECIMAL128);
        BigDecimal mid = low.add(arg.subtract(low.pow(2, MathContext.DECIMAL128)).divide(low.multiply(TWO), RoundingMode.HALF_EVEN));
        BigDecimal high = mid.add(arg.subtract(mid.pow(2, MathContext.DECIMAL128)).divide(mid.multiply(TWO), RoundingMode.HALF_EVEN));
        return high;
    }
}

