/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.jpmml;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.InputField;
import org.jpmml.evaluator.LoadingModelEvaluatorBuilder;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.OutputField;
import org.jpmml.evaluator.visitors.DefaultModelEvaluatorBattery;
import org.jpmml.model.visitors.VisitorBattery;
import org.kie.api.io.Resource;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.EvaluatorResultImpl;
import org.kie.dmn.core.pmml.AbstractPMMLInvocationEvaluator;
import org.kie.dmn.feel.util.EvalHelper;
import org.kie.dmn.model.api.DMNElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNjPMMLInvocationEvaluator
extends AbstractPMMLInvocationEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(DMNjPMMLInvocationEvaluator.class);
    private final ModelEvaluator<?> evaluator;

    public DMNjPMMLInvocationEvaluator(String dmnNS, DMNElement node, Resource pmmlResource, String model) throws Exception {
        super(dmnNS, node, pmmlResource, model);
        LoadingModelEvaluatorBuilder builder = new LoadingModelEvaluatorBuilder();
        try (InputStream documentStream = this.documentResource.getInputStream();){
            Supplier<DefaultModelEvaluatorBattery> visitors = () -> new DefaultModelEvaluatorBattery();
            this.evaluator = builder.setLocatable(false).setVisitors((VisitorBattery)visitors.get()).load(documentStream).build();
            this.evaluator.verify();
        }
    }

    public EvaluatorResult evaluate(DMNRuntimeEventManager eventManager, DMNResult dmnr) {
        List inputFields = this.evaluator.getInputFields();
        LinkedHashMap<FieldName, FieldValue> arguments = new LinkedHashMap<FieldName, FieldValue>();
        for (InputField inputField : inputFields) {
            FieldName inputName = inputField.getName();
            Iterator rawValue = DMNjPMMLInvocationEvaluator.getValueForPMMLInput((DMNResult)dmnr, (String)inputName.getValue());
            FieldValue inputValue = inputField.prepare((Object)rawValue);
            LOG.trace("{}", (Object)inputName);
            LOG.trace("{}", (Object)inputValue);
            arguments.put(inputName, inputValue);
        }
        Map results = this.evaluator.evaluate(arguments);
        Map resultsRecord = EvaluatorUtil.decodeAll((Map)results);
        HashMap result = new HashMap();
        if (this.evaluator.getOutputFields().isEmpty()) {
            for (Map.Entry kv : resultsRecord.entrySet()) {
                result.put(kv.getKey(), EvalHelper.coerceNumber(kv.getValue()));
            }
        } else {
            for (OutputField of : this.evaluator.getOutputFields()) {
                String outputFieldName = of.getName().getValue();
                result.put(outputFieldName, EvalHelper.coerceNumber(resultsRecord.getOrDefault(outputFieldName, null)));
            }
        }
        HashMap coercedResult = result.size() > 1 ? result : result.values().iterator().next();
        return new EvaluatorResultImpl(coercedResult, EvaluatorResult.ResultType.SUCCESS);
    }
}

