/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.model.v1_1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.Location;
import org.kie.dmn.model.v1_1.DMNElement;
import org.kie.dmn.model.v1_1.DRGElement;
import org.kie.dmn.model.v1_1.Definitions;
import org.kie.dmn.model.v1_1.ItemDefinition;
import org.kie.dmn.model.v1_1.NamedElement;

public abstract class DMNModelInstrumentedBase {
    public static final String URI_FEEL = "http://www.omg.org/spec/FEEL/20140401";
    public static final String URI_DMN = "http://www.omg.org/spec/DMN/20151101/dmn.xsd";
    private Map<String, String> nsContext;
    private DMNModelInstrumentedBase parent;
    private final List<DMNModelInstrumentedBase> children = new ArrayList<DMNModelInstrumentedBase>();
    private Location location;

    public String getIdentifierString() {
        if (this instanceof NamedElement && ((NamedElement)this).getName() != null) {
            return ((NamedElement)this).getName();
        }
        if (this instanceof DMNElement && ((DMNElement)this).getId() != null) {
            return ((DMNElement)this).getId();
        }
        return "[unnamed " + this.getClass().getSimpleName() + "]";
    }

    public DMNModelInstrumentedBase getParentDRGElement() {
        if (this instanceof DRGElement) {
            return this;
        }
        if (this instanceof ItemDefinition && this.parent != null && this.parent instanceof Definitions) {
            return this;
        }
        if (this.parent != null) {
            return this.parent.getParentDRGElement();
        }
        return null;
    }

    public Map<String, String> getNsContext() {
        if (this.nsContext == null) {
            this.nsContext = new HashMap<String, String>();
        }
        return this.nsContext;
    }

    public String getNamespaceURI(String prefix) {
        if (this.nsContext != null && this.nsContext.containsKey(prefix)) {
            return this.nsContext.get(prefix);
        }
        if (this.parent != null) {
            return this.parent.getNamespaceURI(prefix);
        }
        return null;
    }

    public DMNModelInstrumentedBase getParent() {
        return this.parent;
    }

    public void setParent(DMNModelInstrumentedBase parent) {
        this.parent = parent;
    }

    public List<DMNModelInstrumentedBase> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void addChildren(DMNModelInstrumentedBase child) {
        this.children.add(child);
    }

    public void setLocation(Location location) {
        this.location = new RowLocation(location);
    }

    public Location getLocation() {
        return this.location;
    }

    static class RowLocation
    implements Location {
        private int lineNumber;
        private String publicId;
        private String systemId;

        RowLocation(Location from) {
            this.lineNumber = from.getLineNumber();
            this.publicId = from.getPublicId();
            this.systemId = from.getSystemId();
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Override
        public int getColumnNumber() {
            return -1;
        }

        @Override
        public int getCharacterOffset() {
            return -1;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RowLocation [getLineNumber()=").append(this.getLineNumber()).append(", getColumnNumber()=").append(this.getColumnNumber()).append(", getCharacterOffset()=").append(this.getCharacterOffset()).append(", getPublicId()=").append(this.getPublicId()).append(", getSystemId()=").append(this.getSystemId()).append("]");
            return builder.toString();
        }
    }
}

