/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.pmml;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DMNTreePMMLTest {
    public static final Logger LOG = LoggerFactory.getLogger(DMNTreePMMLTest.class);
    private static final String SUNGLASSES = "sunglasses";
    private static final String UMBRELLA = "umbrella";
    private static final String NOTHING = "nothing";

    @Test
    public void testTreeWithOutput() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"KiePMMLTree.dmn", DMNTreePMMLTest.class, (String[])new String[]{"test_tree.pmml"});
        Assertions.assertThat((Object)runtime).isNotNull();
        Assertions.assertThat((String)this.evaluateWeatherDecision(runtime, 30, 10)).isEqualTo(SUNGLASSES);
        Assertions.assertThat((String)this.evaluateWeatherDecision(runtime, 5, 70)).isEqualTo(UMBRELLA);
        Assertions.assertThat((String)this.evaluateWeatherDecision(runtime, 10, 15)).isEqualTo(NOTHING);
    }

    @Test
    public void testTreeWithoutOutput() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"KiePMMLTree_no_output.dmn", DMNTreePMMLTest.class, (String[])new String[]{"test_tree_no_output.pmml"});
        Assertions.assertThat((Object)runtime).isNotNull();
        Assertions.assertThat((String)this.evaluateWeatherDecision(runtime, 30, 10)).isEqualTo(SUNGLASSES);
        Assertions.assertThat((String)this.evaluateWeatherDecision(runtime, 5, 70)).isEqualTo(UMBRELLA);
        Assertions.assertThat((String)this.evaluateWeatherDecision(runtime, 10, 15)).isEqualTo(NOTHING);
    }

    private String evaluateWeatherDecision(DMNRuntime runtime, Integer temperature, Integer humidity) {
        DMNModel dmnModel = runtime.getModel("https://kiegroup.org/dmn/_FAA4232D-9D61-4089-BB05-5F5D7C1AECE1", "TestTreeDMN");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        Assertions.assertThat((boolean)dmnModel.hasErrors()).isFalse();
        DMNContext dmnContext = DMNFactory.newContext();
        dmnContext.set("temperature", (Object)temperature);
        dmnContext.set("humidity", (Object)humidity);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, dmnContext);
        LOG.debug("{}", (Object)dmnResult);
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isFalse();
        DMNContext resultContext = dmnResult.getContext();
        Assertions.assertThat((Object)resultContext).isNotNull();
        Assertions.assertThat((Object)resultContext.get("Decision")).isInstanceOf(String.class);
        String weatherDecision = (String)resultContext.get("Decision");
        Assertions.assertThat((String)weatherDecision).isNotNull();
        return weatherDecision;
    }
}

