/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.trisotech.core.util;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.kie.dmn.feel.runtime.Range;

public class IterableRange
implements Iterable<BigDecimal> {
    private static final BigDecimal STEP = new BigDecimal(1);
    private final Range range;

    public IterableRange(Range range) {
        this.range = range;
    }

    @Override
    public Iterator<BigDecimal> iterator() {
        return new IterableRangeIterator();
    }

    private class IterableRangeIterator
    implements Iterator<BigDecimal> {
        private BigDecimal current = null;
        private final BigDecimal from = (BigDecimal)IterableRange.access$100(IterableRange.this).getLowEndPoint();
        private final BigDecimal to = (BigDecimal)IterableRange.access$100(IterableRange.this).getHighEndPoint();

        private IterableRangeIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.current == null) {
                return true;
            }
            if (IterableRange.this.range.getHighBoundary() == Range.RangeBoundary.CLOSED) {
                return this.current.add(STEP).compareTo(this.to) <= 0;
            }
            return this.current.add(STEP).compareTo(this.to) < 0;
        }

        @Override
        public BigDecimal next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.current = this.current == null ? (IterableRange.this.range.getLowBoundary() == Range.RangeBoundary.CLOSED ? this.from : this.from.add(STEP)) : this.current.add(STEP);
            return this.current;
        }
    }
}

