/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.trisotech.backend.marshalling.v1_3.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.kie.dmn.backend.marshalling.v1_3.xstream.ExpressionConverter;
import org.kie.dmn.backend.marshalling.v1x.ConverterDefinesExpressionNodeName;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.Expression;
import org.kie.dmn.trisotech.model.api.Conditional;
import org.kie.dmn.trisotech.model.api.NamedExpression;
import org.kie.dmn.trisotech.model.v1_3.TConditional;
import org.kie.dmn.trisotech.model.v1_3.TNamedExpression;

public class ConditionalConverter
extends ExpressionConverter
implements ConverterDefinesExpressionNodeName {
    public static final String IF = "if";
    public static final String THEN = "then";
    public static final String ELSE = "else";

    protected void assignChildElement(Object parent, String nodeName, Object child) {
        Conditional cond = (Conditional)parent;
        if (IF.equals(nodeName)) {
            cond.setIf(((NamedExpression)child).getExpression());
        } else if (THEN.equals(nodeName)) {
            cond.setThen(((NamedExpression)child).getExpression());
        } else if (ELSE.equals(nodeName)) {
            cond.setElse(((NamedExpression)child).getExpression());
        } else {
            super.assignChildElement(parent, nodeName, child);
        }
    }

    protected void writeChildren(HierarchicalStreamWriter writer, MarshallingContext context, Object parent) {
        super.writeChildren(writer, context, parent);
        Conditional cond = (Conditional)parent;
        this.writeChildrenNode(writer, context, new TNamedExpression(IF, cond.getIf()), IF);
        this.writeChildrenNode(writer, context, new TNamedExpression(THEN, cond.getThen()), THEN);
        this.writeChildrenNode(writer, context, new TNamedExpression(ELSE, cond.getElse()), ELSE);
    }

    public ConditionalConverter(XStream xstream) {
        super(xstream);
    }

    protected DMNModelInstrumentedBase createModelObject() {
        return new TConditional();
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(TConditional.class);
    }

    public String defineExpressionNodeName(Expression e) {
        return "conditional";
    }
}

