/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.core.ast.DMNBaseNode;
import org.kie.dmn.core.compiler.DMNProfile;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.core.util.NamespaceUtil;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.codegen.feel11.ProcessedExpression;
import org.kie.dmn.feel.codegen.feel11.ProcessedUnaryTest;
import org.kie.dmn.feel.lang.CompilerContext;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.DashNode;
import org.kie.dmn.feel.lang.ast.InfixOpNode;
import org.kie.dmn.feel.lang.ast.InfixOperator;
import org.kie.dmn.feel.lang.ast.NameRefNode;
import org.kie.dmn.feel.lang.ast.NullNode;
import org.kie.dmn.feel.lang.ast.RangeNode;
import org.kie.dmn.feel.lang.ast.UnaryTestListNode;
import org.kie.dmn.feel.lang.ast.UnaryTestNode;
import org.kie.dmn.feel.lang.ast.UndefinedValueNode;
import org.kie.dmn.feel.lang.ast.Visitor;
import org.kie.dmn.feel.lang.impl.FEELBuilder;
import org.kie.dmn.feel.lang.impl.UnaryTestInterpretedExecutableExpression;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.model.api.BusinessKnowledgeModel;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.Decision;
import org.kie.dmn.model.api.DecisionRule;
import org.kie.dmn.model.api.DecisionTable;
import org.kie.dmn.model.api.HitPolicy;
import org.kie.dmn.model.api.InputClause;
import org.kie.dmn.model.api.ItemDefinition;
import org.kie.dmn.model.api.LiteralExpression;
import org.kie.dmn.model.api.OutputClause;
import org.kie.dmn.model.api.UnaryTests;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.DMNDTAnalyserValueFromNodeVisitor;
import org.kie.dmn.validation.dtanalysis.DMNDTAnalysisException;
import org.kie.dmn.validation.dtanalysis.InternalDMNDTAnalyser;
import org.kie.dmn.validation.dtanalysis.mcdc.MCDCAnalyser;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.BoundValueComparator;
import org.kie.dmn.validation.dtanalysis.model.DDTAInputClause;
import org.kie.dmn.validation.dtanalysis.model.DDTAInputEntry;
import org.kie.dmn.validation.dtanalysis.model.DDTAOutputClause;
import org.kie.dmn.validation.dtanalysis.model.DDTARule;
import org.kie.dmn.validation.dtanalysis.model.DDTATable;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;
import org.kie.dmn.validation.dtanalysis.model.NullBoundImpl;
import org.kie.dmn.validation.dtanalysis.model.Overlap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNDTAnalyser
implements InternalDMNDTAnalyser {
    private static final Logger LOG = LoggerFactory.getLogger(DMNDTAnalyser.class);
    private final FEEL FEEL;
    private final DMNDTAnalyserValueFromNodeVisitor valueFromNodeVisitor;
    private final DMNDTAnalyserValueFromNodeVisitor.DMNDTAnalyserOutputClauseVisitor outputClauseVisitor;

    public DMNDTAnalyser(List<DMNProfile> dmnProfiles) {
        this.FEEL = FEELBuilder.builder().withProfiles(dmnProfiles).build();
        this.valueFromNodeVisitor = new DMNDTAnalyserValueFromNodeVisitor(dmnProfiles);
        this.outputClauseVisitor = new DMNDTAnalyserValueFromNodeVisitor.DMNDTAnalyserOutputClauseVisitor(dmnProfiles);
    }

    @Override
    public List<DTAnalysis> analyse(DMNModel model, Set<DMNValidator.Validation> flags) {
        if (!flags.contains((Object)DMNValidator.Validation.ANALYZE_DECISION_TABLE)) {
            throw new IllegalArgumentException();
        }
        ArrayList<DTAnalysis> results = new ArrayList<DTAnalysis>();
        List decisionTables = model.getDefinitions().findAllChildren(DecisionTable.class);
        for (DecisionTable dt : decisionTables) {
            try {
                DTAnalysis result = this.dmnDTAnalysis(model, dt, flags);
                results.add(result);
            }
            catch (Throwable t) {
                LOG.debug("Skipped dmnDTAnalysis for table: {}", (Object)dt.getId(), (Object)t);
                DTAnalysis result = DTAnalysis.ofError(dt, t);
                results.add(result);
            }
        }
        return results;
    }

    private DTAnalysis dmnDTAnalysis(DMNModel model, DecisionTable dt, Set<DMNValidator.Validation> flags) {
        LOG.debug("Starting analsysis for DT with id: {}", (Object)dt.getId());
        DDTATable ddtaTable = new DDTATable();
        this.compileTableInputClauses(model, dt, ddtaTable);
        this.compileTableOutputClauses(model, dt, ddtaTable);
        this.compileTableRules(model, dt, ddtaTable);
        this.compileTableComputeColStringMissingEnum(model, dt, ddtaTable);
        this.printDebugTableInfo(ddtaTable);
        DTAnalysis analysis = new DTAnalysis(dt, ddtaTable);
        analysis.computeOutputInLOV();
        if (!dt.getHitPolicy().equals((Object)HitPolicy.COLLECT)) {
            if (ddtaTable.getColIDsStringWithoutEnum().isEmpty()) {
                LOG.debug("findGaps");
                DMNDTAnalyser.findGaps(analysis, ddtaTable, 0, new Interval[ddtaTable.inputCols()], Collections.emptyList());
            } else {
                LOG.debug("findGaps Skipped because getColIDsStringWithoutEnum is not empty: {}", ddtaTable.getColIDsStringWithoutEnum());
            }
            LOG.debug("findOverlaps");
            this.findOverlaps(analysis, ddtaTable, 0, new Interval[ddtaTable.inputCols()], Collections.emptyList());
        } else {
            LOG.debug("findGaps(), findOverlaps() are Skipped because getHitPolicy is COLLECT.");
        }
        LOG.debug("computeMaskedRules");
        analysis.computeMaskedRules();
        LOG.debug("computeMisleadingRules");
        analysis.computeMisleadingRules();
        LOG.debug("normalize");
        analysis.normalize();
        LOG.debug("computeSubsumptions");
        analysis.computeSubsumptions();
        LOG.debug("computeContractions");
        analysis.computeContractions();
        LOG.debug("compute1stNFViolations");
        analysis.compute1stNFViolations();
        LOG.debug("compute2ndNFViolations");
        analysis.compute2ndNFViolations();
        LOG.debug("computeHitPolicyRecommender");
        analysis.computeHitPolicyRecommender();
        if (flags.contains((Object)DMNValidator.Validation.COMPUTE_DECISION_TABLE_MCDC)) {
            LOG.debug("mcdc.");
            List<MCDCAnalyser.PosNegBlock> selectedBlocks = new MCDCAnalyser(ddtaTable, dt).compute();
            analysis.setMCDCSelectedBlocks(selectedBlocks);
        }
        LOG.debug("Finished analsysis for DT with id: {}", (Object)dt.getId());
        return analysis;
    }

    private void compileTableComputeColStringMissingEnum(DMNModel model, DecisionTable dt, DDTATable ddtaTable) {
        for (int iColIdx = 0; iColIdx < ddtaTable.inputCols(); ++iColIdx) {
            InputClause ie = (InputClause)dt.getInput().get(iColIdx);
            QName typeRef = NamespaceUtil.getNamespaceAndName((DMNModelInstrumentedBase)dt, (Map)((DMNModelImpl)model).getImportAliasesForNS(), (QName)ie.getInputExpression().getTypeRef(), (String)model.getNamespace());
            if (!"string".equals(typeRef.getLocalPart()) || ddtaTable.getInputs().get(iColIdx).isDiscreteDomain()) continue;
            Interval infStringDomain = ddtaTable.getInputs().get(iColIdx).getDomainMinMax();
            boolean areAllSinglePointOrAll = true;
            for (int jRowIdx = 0; jRowIdx < dt.getRule().size() && areAllSinglePointOrAll; ++jRowIdx) {
                DDTAInputEntry colRowInputEntry = ddtaTable.getRule().get(jRowIdx).getInputEntry().get(iColIdx);
                if (colRowInputEntry.isAllSingularities()) {
                    LOG.debug("col {} row {} are all singularities, assuming positive `areAllSinglePointOrAll`={} and continue. {}", new Object[]{iColIdx, jRowIdx, areAllSinglePointOrAll, colRowInputEntry.getUts()});
                    continue;
                }
                for (Interval interval : colRowInputEntry.getIntervals()) {
                    areAllSinglePointOrAll = areAllSinglePointOrAll && infStringDomain.equals(interval);
                }
            }
            if (!areAllSinglePointOrAll) continue;
            ddtaTable.addColIdStringWithoutEnum(iColIdx + 1);
        }
    }

    private void printDebugTableInfo(DDTATable ddtaTable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}", (Object)ddtaTable);
            LOG.debug("project on columns.");
            for (int colIdx = 0; colIdx < ddtaTable.inputCols(); ++colIdx) {
                LOG.debug("colIdx " + colIdx);
                List<Interval> intervals = ddtaTable.projectOnColumnIdx(colIdx);
                LOG.debug("{}", intervals);
                List bounds = intervals.stream().flatMap(i -> Stream.of(i.getLowerBound(), i.getUpperBound())).collect(Collectors.toList());
                LOG.debug("{}", bounds);
                Collections.sort(bounds);
                LOG.debug("{}", bounds);
            }
            LOG.debug("col IDs being String without Enum: {}", ddtaTable.getColIDsStringWithoutEnum());
        }
    }

    private void compileTableRules(DMNModel model, DecisionTable dt, DDTATable ddtaTable) {
        for (int jRowIdx = 0; jRowIdx < dt.getRule().size(); ++jRowIdx) {
            UnaryTestInterpretedExecutableExpression interpreted;
            DecisionRule r = (DecisionRule)dt.getRule().get(jRowIdx);
            DDTARule ddtaRule = new DDTARule();
            int jColIdx = 0;
            for (UnaryTests ie : r.getInputEntry()) {
                ProcessedUnaryTest compileUnaryTests = (ProcessedUnaryTest)this.FEEL.processUnaryTests(ie.getText(), this.feelCtx(model, dt));
                interpreted = compileUnaryTests.getInterpreted();
                if (interpreted == UnaryTestInterpretedExecutableExpression.EMPTY) {
                    throw new DMNDTAnalysisException("Gaps/Overlaps analysis cannot be performed for InputEntry with unary test containing: " + ie.getText(), dt);
                }
                UnaryTestListNode utln = (UnaryTestListNode)interpreted.getASTNode();
                this.verifyUtln(utln, dt);
                DDTAInputClause ddtaInputClause = ddtaTable.getInputs().get(jColIdx);
                ToIntervals toIntervals = this.toIntervals(utln.getElements(), utln.isNegated(), ddtaInputClause.getDomainMinMax(), ddtaInputClause.getDiscreteValues(), jRowIdx + 1, jColIdx + 1);
                DDTAInputEntry ddtaInputEntry = new DDTAInputEntry(utln.getElements(), toIntervals.intervals, toIntervals.allSingularities);
                for (Interval interval : ddtaInputEntry.getIntervals()) {
                    Interval domainMinMax = ddtaTable.getInputs().get(jColIdx).getDomainMinMax();
                    if (domainMinMax.includes(interval)) continue;
                    throw new IllegalStateException(MsgUtil.createMessage((Msg.Message4)Msg.DTANALYSIS_ERROR_RULE_OUTSIDE_DOMAIN, (Object)(jRowIdx + 1), (Object)interval, (Object)domainMinMax, (Object)(jColIdx + 1)));
                }
                ddtaRule.getInputEntry().add(ddtaInputEntry);
                ++jColIdx;
            }
            for (LiteralExpression oe : r.getOutputEntry()) {
                ProcessedExpression compile = (ProcessedExpression)this.FEEL.compile(oe.getText(), this.feelCtx(model, dt));
                interpreted = compile.getInterpreted();
                BaseNode outputEntryNode = (BaseNode)interpreted.getASTNode();
                Comparable<?> value = this.valueFromNode(outputEntryNode, (Visitor<Comparable<?>>)this.outputClauseVisitor);
                ddtaRule.getOutputEntry().add(value);
                ++jColIdx;
            }
            ddtaTable.addRule(ddtaRule);
        }
    }

    private void verifyUtln(UnaryTestListNode utln, DecisionTable dt) {
        for (BaseNode ut : utln.getElements()) {
            InfixOpNode infixOpNode;
            if (!(ut instanceof UnaryTestNode)) continue;
            UnaryTestNode utn = (UnaryTestNode)ut;
            if (utn.getValue() instanceof RangeNode && (utn.getOperator() == UnaryTestNode.UnaryOperator.IN || utn.getOperator() == UnaryTestNode.UnaryOperator.EQ)) {
                RangeNode rangeNode = (RangeNode)utn.getValue();
                Optional<BaseNode> diamond = this.checkForDiamondRange(rangeNode);
                if (!diamond.isPresent()) continue;
                throw new DMNDTAnalysisException("Unrecognized unary test: '" + ut.getText() + "'; did you meant to write 'not(" + diamond.get().getText() + ")' instead?", dt);
            }
            if (utn.getOperator() == UnaryTestNode.UnaryOperator.NE) {
                throw new DMNDTAnalysisException("Unrecognized unary test: '" + ut.getText() + "'; did you meant to write 'not(" + utn.getValue().getText() + ")' instead?", dt);
            }
            if (utn.getOperator() != UnaryTestNode.UnaryOperator.TEST || !(utn.getValue() instanceof InfixOpNode) || (infixOpNode = (InfixOpNode)utn.getValue()).getOperator() != InfixOperator.NE) continue;
            boolean leftIsQmark = infixOpNode.getLeft() instanceof NameRefNode && infixOpNode.getLeft().getText().equals("?");
            DMNDTAnalyserValueFromNodeVisitor.SupportedConstantValueVisitor constantVisitor = new DMNDTAnalyserValueFromNodeVisitor.SupportedConstantValueVisitor();
            boolean rightIsConstant = (Boolean)infixOpNode.getRight().accept((Visitor)constantVisitor);
            if (!leftIsQmark || !rightIsConstant) continue;
            throw new DMNDTAnalysisException("Unmanaged unary test: '" + ut.getText() + "'; you could write 'not(" + infixOpNode.getRight().getText() + ")' instead.", dt);
        }
    }

    private Optional<BaseNode> checkForDiamondRange(RangeNode rangeNode) {
        if ((rangeNode.getStart() instanceof NullNode || rangeNode.getStart() instanceof UndefinedValueNode || rangeNode.getStart() == null) && rangeNode.getUpperBound() == RangeNode.IntervalBoundary.OPEN && rangeNode.getEnd() instanceof RangeNode) {
            return Optional.ofNullable(((RangeNode)rangeNode.getEnd()).getStart());
        }
        if ((rangeNode.getEnd() instanceof NullNode || rangeNode.getEnd() instanceof UndefinedValueNode || rangeNode.getEnd() == null) && rangeNode.getLowerBound() == RangeNode.IntervalBoundary.OPEN && rangeNode.getStart() instanceof RangeNode) {
            return Optional.ofNullable(((RangeNode)rangeNode.getStart()).getEnd());
        }
        return Optional.empty();
    }

    private CompilerContext feelCtx(DMNModel model, DecisionTable dt) {
        CompilerContext feelCtx = this.FEEL.newCompilerContext();
        DMNModelInstrumentedBase parentDRGelement = dt.getParentDRDElement();
        DMNBaseNode parentNode = null;
        if (parentDRGelement instanceof Decision) {
            Decision decision = (Decision)parentDRGelement;
            parentNode = (DMNBaseNode)model.getDecisionByName(decision.getName());
        } else if (parentDRGelement instanceof BusinessKnowledgeModel) {
            BusinessKnowledgeModel bkm = (BusinessKnowledgeModel)parentDRGelement;
            parentNode = (DMNBaseNode)model.getBusinessKnowledgeModelByName(bkm.getName());
        }
        if (parentNode != null) {
            parentNode.getDependencies().keySet().forEach(k -> feelCtx.addInputVariableType(k, (Type)BuiltInType.UNKNOWN));
        }
        return feelCtx;
    }

    private void compileTableInputClauses(DMNModel model, DecisionTable dt, DDTATable ddtaTable) {
        for (int jColIdx = 0; jColIdx < dt.getInput().size(); ++jColIdx) {
            String allowedValues;
            InputClause ie = (InputClause)dt.getInput().get(jColIdx);
            Interval infDomain = new Interval(Range.RangeBoundary.CLOSED, Interval.NEG_INF, Interval.POS_INF, Range.RangeBoundary.CLOSED, 0, jColIdx + 1);
            if (ie.getInputValues() != null) {
                allowedValues = ie.getInputValues().getText();
            } else {
                QName typeRef = NamespaceUtil.getNamespaceAndName((DMNModelInstrumentedBase)dt, (Map)((DMNModelImpl)model).getImportAliasesForNS(), (QName)ie.getInputExpression().getTypeRef(), (String)model.getNamespace());
                allowedValues = this.findAllowedValues(model, typeRef);
            }
            if (allowedValues != null) {
                ProcessedUnaryTest compileUnaryTests = (ProcessedUnaryTest)this.FEEL.processUnaryTests(allowedValues, this.FEEL.newCompilerContext());
                UnaryTestInterpretedExecutableExpression interpreted = compileUnaryTests.getInterpreted();
                UnaryTestListNode utln = (UnaryTestListNode)interpreted.getASTNode();
                ArrayList<BaseNode> utlnElements = new ArrayList<BaseNode>(utln.getElements());
                boolean allowNull = this.removeEQNullUnaryTest(utlnElements);
                if (utlnElements.size() != 1) {
                    this.verifyUnaryTestsAllEQ(utlnElements, dt);
                    List<Comparable<?>> discreteValues = this.getDiscreteValues(utlnElements);
                    List<Comparable<?>> inputOrder = Collections.unmodifiableList(new ArrayList(discreteValues));
                    Collections.sort(discreteValues);
                    Interval discreteDomainMinMax = new Interval(Range.RangeBoundary.CLOSED, discreteValues.get(0), discreteValues.get(discreteValues.size() - 1), Range.RangeBoundary.CLOSED, 0, jColIdx + 1);
                    DDTAInputClause ic = new DDTAInputClause(discreteDomainMinMax, allowNull, discreteValues, inputOrder);
                    ddtaTable.getInputs().add(ic);
                    continue;
                }
                if (utlnElements.size() == 1) {
                    UnaryTestNode utn0 = (UnaryTestNode)utlnElements.get(0);
                    Interval interval = this.utnToInterval(utn0, infDomain, null, 0, jColIdx + 1);
                    DDTAInputClause ic = new DDTAInputClause(interval, allowNull);
                    ddtaTable.getInputs().add(ic);
                    continue;
                }
                throw new IllegalStateException("inputValues not null but utln: " + utln);
            }
            DDTAInputClause ic = new DDTAInputClause(infDomain, false);
            ddtaTable.getInputs().add(ic);
        }
    }

    private boolean removeEQNullUnaryTest(List<BaseNode> utlnElements) {
        boolean found = false;
        ListIterator<BaseNode> it = utlnElements.listIterator();
        while (it.hasNext()) {
            UnaryTestNode utn;
            BaseNode cur = it.next();
            if (!(cur instanceof UnaryTestNode) || (utn = (UnaryTestNode)cur).getOperator() != UnaryTestNode.UnaryOperator.EQ || !(utn.getValue() instanceof NullNode)) continue;
            it.remove();
            found = true;
        }
        return found;
    }

    private void compileTableOutputClauses(DMNModel model, DecisionTable dt, DDTATable ddtaTable) {
        for (int jColIdx = 0; jColIdx < dt.getOutput().size(); ++jColIdx) {
            OutputClause oe = (OutputClause)dt.getOutput().get(jColIdx);
            Interval infDomain = new Interval(Range.RangeBoundary.CLOSED, Interval.NEG_INF, Interval.POS_INF, Range.RangeBoundary.CLOSED, 0, jColIdx + 1);
            String allowedValues = null;
            if (oe.getOutputValues() != null) {
                allowedValues = oe.getOutputValues().getText();
            } else {
                QName outputTypeRef;
                QName qName = outputTypeRef = oe.getTypeRef() == null && dt.getOutput().size() == 1 ? dt.getTypeRef() : oe.getTypeRef();
                if (outputTypeRef != null) {
                    QName typeRef = NamespaceUtil.getNamespaceAndName((DMNModelInstrumentedBase)dt, (Map)((DMNModelImpl)model).getImportAliasesForNS(), (QName)outputTypeRef, (String)model.getNamespace());
                    allowedValues = this.findAllowedValues(model, typeRef);
                }
            }
            if (allowedValues != null) {
                ProcessedUnaryTest compileUnaryTests = (ProcessedUnaryTest)this.FEEL.processUnaryTests(allowedValues, this.FEEL.newCompilerContext());
                UnaryTestInterpretedExecutableExpression interpreted = compileUnaryTests.getInterpreted();
                UnaryTestListNode utln = (UnaryTestListNode)interpreted.getASTNode();
                ArrayList<BaseNode> utlnElements = new ArrayList<BaseNode>(utln.getElements());
                boolean allowNull = this.removeEQNullUnaryTest(utlnElements);
                if (utlnElements.size() != 1) {
                    this.verifyUnaryTestsAllEQ(utlnElements, dt);
                    List<Comparable<?>> discreteValues = this.getDiscreteValues(utlnElements);
                    List<Comparable<?>> outputOrder = Collections.unmodifiableList(new ArrayList(discreteValues));
                    Collections.sort(discreteValues);
                    Interval discreteDomainMinMax = new Interval(Range.RangeBoundary.CLOSED, discreteValues.get(0), discreteValues.get(discreteValues.size() - 1), Range.RangeBoundary.CLOSED, 0, jColIdx + 1);
                    DDTAOutputClause ic = new DDTAOutputClause(discreteDomainMinMax, discreteValues, outputOrder);
                    ddtaTable.getOutputs().add(ic);
                    continue;
                }
                if (utlnElements.size() == 1) {
                    UnaryTestNode utn0 = (UnaryTestNode)utlnElements.get(0);
                    Interval interval = this.utnToInterval(utn0, infDomain, null, 0, jColIdx + 1);
                    DDTAOutputClause ic = new DDTAOutputClause(interval);
                    ddtaTable.getOutputs().add(ic);
                    continue;
                }
                throw new IllegalStateException("inputValues not null but utln: " + utln);
            }
            DDTAOutputClause ic = new DDTAOutputClause(infDomain);
            ddtaTable.getOutputs().add(ic);
        }
    }

    private void verifyUnaryTestsAllEQ(List<BaseNode> utlnElements, DecisionTable dt) {
        if (!utlnElements.stream().allMatch(e -> e instanceof UnaryTestNode && ((UnaryTestNode)e).getOperator() == UnaryTestNode.UnaryOperator.EQ)) {
            throw new DMNDTAnalysisException("Multiple constraint on column: " + utlnElements, dt);
        }
    }

    private List<Comparable<?>> getDiscreteValues(List<BaseNode> utlnElements) {
        ArrayList discreteValues = new ArrayList();
        for (BaseNode e : utlnElements) {
            BaseNode value = ((UnaryTestNode)e).getValue();
            if (value instanceof NullNode) continue;
            Comparable<?> v = this.valueFromNode(value);
            discreteValues.add(v);
        }
        return discreteValues;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String findAllowedValues(DMNModel model, QName typeRef) {
        if (typeRef.getNamespaceURI().equals(model.getNamespace())) {
            Optional<ItemDefinition> opt = model.getDefinitions().getItemDefinition().stream().filter(id -> id.getName().equals(typeRef.getLocalPart())).findFirst();
            if (!opt.isPresent()) throw new IllegalStateException("Unable to locate typeRef " + typeRef + " to determine domain.");
            ItemDefinition id2 = opt.get();
            if (id2.getAllowedValues() != null) {
                return id2.getAllowedValues().getText();
            }
        } else if (typeRef.getNamespaceURI().equals(model.getDefinitions().getURIFEEL()) && typeRef.getLocalPart().equals("boolean")) {
            return "false, true";
        }
        List childModels = ((DMNModelImpl)model).getImportChainDirectChildModels();
        return childModels.stream().map(childModel -> this.findAllowedValues((DMNModel)childModel, typeRef)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private void findOverlaps(DTAnalysis analysis, DDTATable ddtaTable, int jColIdx, Interval[] currentIntervals, Collection<Integer> activeRules) {
        LOG.debug("findOverlaps jColIdx {}, currentIntervals {}, activeRules {}", new Object[]{jColIdx, currentIntervals, activeRules});
        if (jColIdx < ddtaTable.inputCols()) {
            List<Bound> bounds = DMNDTAnalyser.findBoundsSorted(ddtaTable, jColIdx, activeRules);
            ArrayList<Interval> activeIntervals = new ArrayList<Interval>();
            Bound lastBound = null;
            for (Bound currentBound : bounds) {
                if (lastBound == null) {
                    lastBound = currentBound;
                }
                LOG.debug("lastBound {} currentBound {}      activeIntervals {} == rules {}", new Object[]{lastBound, currentBound, activeIntervals, DMNDTAnalyser.activeIntervalsToRules(activeIntervals)});
                if (activeIntervals.size() > 1 && DMNDTAnalyser.canBeNewCurrInterval(lastBound, currentBound)) {
                    Interval analysisInterval;
                    currentIntervals[jColIdx] = analysisInterval = new Interval(lastBound.isUpperBound() ? Interval.invertBoundary(lastBound.getBoundaryType()) : lastBound.getBoundaryType(), (Comparable<?>)lastBound.getValue(), (Comparable<?>)currentBound.getValue(), currentBound.isLowerBound() ? Interval.invertBoundary(currentBound.getBoundaryType()) : currentBound.getBoundaryType(), 0, 0);
                    this.findOverlaps(analysis, ddtaTable, jColIdx + 1, currentIntervals, DMNDTAnalyser.activeIntervalsToRules(activeIntervals));
                }
                if (currentBound.isLowerBound()) {
                    activeIntervals.add(currentBound.getParent());
                } else {
                    activeIntervals.remove(currentBound.getParent());
                }
                lastBound = currentBound;
            }
            currentIntervals[jColIdx] = null;
        } else if (jColIdx == ddtaTable.inputCols()) {
            if (activeRules.size() > 1) {
                Hyperrectangle overlap = new Hyperrectangle(ddtaTable.inputCols(), Arrays.asList(currentIntervals));
                LOG.debug("OVERLAP DETECTED {}", (Object)overlap);
                analysis.addOverlap(new Overlap(activeRules, overlap));
            }
        } else {
            throw new IllegalStateException();
        }
        LOG.debug(".");
    }

    private static void findGaps(DTAnalysis analysis, DDTATable ddtaTable, int jColIdx, Interval[] currentIntervals, Collection<Integer> activeRules) {
        LOG.debug("findGaps jColIdx {}, currentIntervals {}, activeRules {}", new Object[]{jColIdx, currentIntervals, activeRules});
        if (jColIdx < ddtaTable.inputCols()) {
            DMNDTAnalyser.findBoundsSorted(ddtaTable, jColIdx, activeRules);
            List<Bound> bounds = DMNDTAnalyser.findBoundsSorted(ddtaTable, jColIdx, activeRules);
            Interval domainRange = ddtaTable.getInputs().get(jColIdx).getDomainMinMax();
            if (!domainRange.getLowerBound().equals(bounds.get(0))) {
                currentIntervals[jColIdx] = DMNDTAnalyser.lastDimensionUncoveredInterval(domainRange.getLowerBound(), bounds.get(0), domainRange);
                Hyperrectangle gap = new Hyperrectangle(ddtaTable.inputCols(), DMNDTAnalyser.buildEdgesForHyperrectangleFromIntervals(currentIntervals, jColIdx));
                analysis.addGap(gap);
                LOG.debug("STARTLEFT GAP DETECTED {}", (Object)gap);
            }
            ArrayList<Interval> activeIntervals = new ArrayList<Interval>();
            Bound lastBound = NullBoundImpl.NULL;
            for (Bound currentBound : bounds) {
                LOG.debug("lastBound {} currentBound {}      activeIntervals {} == rules {}", new Object[]{lastBound, currentBound, activeIntervals, DMNDTAnalyser.activeIntervalsToRules(activeIntervals)});
                if (activeIntervals.isEmpty() && lastBound != NullBoundImpl.NULL && !Bound.adOrOver(lastBound, currentBound)) {
                    currentIntervals[jColIdx] = DMNDTAnalyser.lastDimensionUncoveredInterval(lastBound, currentBound, domainRange);
                    Hyperrectangle gap = new Hyperrectangle(ddtaTable.inputCols(), DMNDTAnalyser.buildEdgesForHyperrectangleFromIntervals(currentIntervals, jColIdx));
                    LOG.debug("GAP DETECTED {}", (Object)gap);
                    analysis.addGap(gap);
                }
                if (!activeIntervals.isEmpty() && DMNDTAnalyser.canBeNewCurrInterval(lastBound, currentBound)) {
                    Interval missingInterval;
                    currentIntervals[jColIdx] = missingInterval = new Interval(lastBound.isUpperBound() ? Interval.invertBoundary(lastBound.getBoundaryType()) : lastBound.getBoundaryType(), (Comparable<?>)lastBound.getValue(), (Comparable<?>)currentBound.getValue(), currentBound.isLowerBound() ? Interval.invertBoundary(currentBound.getBoundaryType()) : currentBound.getBoundaryType(), 0, 0);
                    DMNDTAnalyser.findGaps(analysis, ddtaTable, jColIdx + 1, currentIntervals, DMNDTAnalyser.activeIntervalsToRules(activeIntervals));
                }
                if (currentBound.isLowerBound()) {
                    activeIntervals.add(currentBound.getParent());
                } else {
                    activeIntervals.remove(currentBound.getParent());
                }
                lastBound = currentBound;
            }
            if (!lastBound.equals(domainRange.getUpperBound())) {
                currentIntervals[jColIdx] = DMNDTAnalyser.lastDimensionUncoveredInterval(lastBound, domainRange.getUpperBound(), domainRange);
                Hyperrectangle gap = new Hyperrectangle(ddtaTable.inputCols(), DMNDTAnalyser.buildEdgesForHyperrectangleFromIntervals(currentIntervals, jColIdx));
                LOG.debug("ENDRIGHT GAP DETECTED {}", (Object)gap);
                analysis.addGap(gap);
            }
            currentIntervals[jColIdx] = null;
        }
        LOG.debug(".");
    }

    private static List<Bound> findBoundsSorted(DDTATable ddtaTable, int jColIdx, Collection<Integer> activeRules) {
        List<Interval> intervals = ddtaTable.projectOnColumnIdx(jColIdx);
        if (!activeRules.isEmpty()) {
            intervals = intervals.stream().filter(i -> activeRules.contains(i.getRule())).collect(Collectors.toList());
        }
        LOG.debug("intervals {}", intervals);
        List<Bound> bounds = intervals.stream().flatMap(i -> Stream.of(i.getLowerBound(), i.getUpperBound())).collect(Collectors.toList());
        Collections.sort(bounds);
        LOG.debug("bounds (sorted) {}", bounds);
        return bounds;
    }

    private static List<Interval> buildEdgesForHyperrectangleFromIntervals(Interval[] currentIntervals, int intervalsIndex) {
        ArrayList<Interval> edges = new ArrayList<Interval>();
        for (int p = 0; p <= intervalsIndex; ++p) {
            edges.add(currentIntervals[p]);
        }
        return edges;
    }

    private static Collection<Integer> activeIntervalsToRules(List<Interval> activeIntervals) {
        return activeIntervals.stream().map(Interval::getRule).collect(Collectors.toList());
    }

    private static boolean canBeNewCurrInterval(Bound<?> lastBound, Bound<?> currentBound) {
        int vCompare = BoundValueComparator.compareValueDispatchingToInf(lastBound, currentBound);
        if (vCompare != 0) {
            return true;
        }
        if (lastBound.isLowerBound() && currentBound.isUpperBound()) {
            return true;
        }
        return lastBound.isUpperBound() && lastBound.getBoundaryType() == Range.RangeBoundary.OPEN && currentBound.isLowerBound() && currentBound.getBoundaryType() == Range.RangeBoundary.OPEN;
    }

    private static Interval lastDimensionUncoveredInterval(Bound<?> l, Bound<?> r, Interval domain) {
        boolean isLmin = l.isLowerBound() && l.equals(domain.getLowerBound());
        boolean isRmax = r.isUpperBound() && r.equals(domain.getUpperBound());
        return new Interval(isLmin ? domain.getLowerBound().getBoundaryType() : Interval.invertBoundary(l.getBoundaryType()), (Comparable<?>)l.getValue(), (Comparable<?>)r.getValue(), isRmax ? domain.getUpperBound().getBoundaryType() : Interval.invertBoundary(r.getBoundaryType()), 0, 0);
    }

    private ToIntervals toIntervals(List<BaseNode> elements, boolean isNegated, Interval minMax, List discreteValues, int rule, int col) {
        if (elements.size() == 1 && elements.get(0) instanceof UnaryTestNode && ((UnaryTestNode)elements.get(0)).getValue() instanceof NullNode && !isNegated) {
            return new ToIntervals(Collections.emptyList(), false);
        }
        if (discreteValues != null && !discreteValues.isEmpty() && DMNDTAnalyser.areAllEQUnaryTest(elements) && elements.size() > 1) {
            return this.toIntervalsEQUnaryTests(elements, isNegated, discreteValues, rule, col);
        }
        ArrayList<Interval> results = new ArrayList<Interval>();
        for (BaseNode n : elements) {
            if (n instanceof DashNode) {
                results.add(new Interval(minMax.getLowerBound().getBoundaryType(), (Comparable<?>)minMax.getLowerBound().getValue(), (Comparable<?>)minMax.getUpperBound().getValue(), minMax.getUpperBound().getBoundaryType(), rule, col));
                continue;
            }
            if (!(n instanceof UnaryTestNode)) continue;
            UnaryTestNode ut = (UnaryTestNode)n;
            if (ut.getValue() instanceof NullNode && isNegated) {
                return new ToIntervals(Collections.singletonList(new Interval(minMax.getLowerBound().getBoundaryType(), (Comparable<?>)minMax.getLowerBound().getValue(), (Comparable<?>)minMax.getUpperBound().getValue(), minMax.getUpperBound().getBoundaryType(), rule, col)), false);
            }
            Interval interval = this.utnToInterval(ut, minMax, discreteValues, rule, col);
            results.add(interval);
        }
        boolean allSingularities = results.stream().allMatch(Interval::isSingularity);
        if (isNegated) {
            return new ToIntervals(Interval.invertOverDomain(results, minMax), allSingularities);
        }
        return new ToIntervals(results, allSingularities);
    }

    private ToIntervals toIntervalsEQUnaryTests(List<BaseNode> elements, boolean isNegated, List discreteValues, int rule, int col) {
        ArrayList<Interval> results = new ArrayList<Interval>();
        int bitsetLogicalSize = discreteValues.size();
        BitSet hitValues = new BitSet(bitsetLogicalSize);
        for (BaseNode n : elements) {
            Comparable<?> thisValue = this.valueFromNode(((UnaryTestNode)n).getValue());
            int indexOf = discreteValues.indexOf(thisValue);
            if (indexOf < 0) {
                throw new IllegalStateException("Unable to determine discreteValue index for: " + n);
            }
            hitValues.set(indexOf);
        }
        if (isNegated) {
            hitValues.flip(0, bitsetLogicalSize);
        }
        int lowerBoundIdx = -1;
        int upperBoundIdx = -1;
        for (int i = 0; i < hitValues.length(); ++i) {
            boolean curValue = hitValues.get(i);
            if (curValue) {
                if (lowerBoundIdx < 0) {
                    lowerBoundIdx = i;
                    upperBoundIdx = i;
                    continue;
                }
                upperBoundIdx = i;
                continue;
            }
            if (lowerBoundIdx < 0) continue;
            results.add(DMNDTAnalyser.createIntervalOfRule(discreteValues, rule, col, lowerBoundIdx, upperBoundIdx));
            lowerBoundIdx = -1;
            upperBoundIdx = -1;
        }
        if (lowerBoundIdx >= 0) {
            results.add(DMNDTAnalyser.createIntervalOfRule(discreteValues, rule, col, lowerBoundIdx, upperBoundIdx));
        }
        boolean allSingularities = results.stream().allMatch(Interval::isSingularity);
        return new ToIntervals(results, allSingularities);
    }

    private static Interval createIntervalOfRule(List discreteValues, int rule, int col, int lowerBoundIdx, int upperBoundIdx) {
        Comparable lowValue = (Comparable)discreteValues.get(lowerBoundIdx);
        Comparable highValue = (Comparable)discreteValues.get(upperBoundIdx);
        if (upperBoundIdx + 1 == discreteValues.size()) {
            return new Interval(Range.RangeBoundary.CLOSED, lowValue, highValue, Range.RangeBoundary.CLOSED, rule, col);
        }
        return new Interval(Range.RangeBoundary.CLOSED, lowValue, (Comparable)discreteValues.get(upperBoundIdx + 1), Range.RangeBoundary.OPEN, rule, col);
    }

    private static boolean areAllEQUnaryTest(List<BaseNode> elements) {
        try {
            boolean result = true;
            for (BaseNode n : elements) {
                result = result && ((UnaryTestNode)n).getOperator() == UnaryTestNode.UnaryOperator.EQ;
            }
            return result;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private Interval utnToInterval(UnaryTestNode ut, Interval minMax, List discreteValues, int rule, int col) {
        if (ut.getOperator() == UnaryTestNode.UnaryOperator.EQ) {
            if (discreteValues == null || discreteValues.isEmpty()) {
                return new Interval(Range.RangeBoundary.CLOSED, this.valueFromNode(ut.getValue()), this.valueFromNode(ut.getValue()), Range.RangeBoundary.CLOSED, rule, col);
            }
            Comparable<?> thisValue = this.valueFromNode(ut.getValue());
            int indexOf = discreteValues.indexOf(thisValue);
            if (indexOf < 0) {
                throw new IllegalStateException("Unable to determine discreteValue index for: " + ut);
            }
            if (indexOf + 1 == discreteValues.size()) {
                return new Interval(Range.RangeBoundary.CLOSED, thisValue, thisValue, Range.RangeBoundary.CLOSED, rule, col);
            }
            return new Interval(Range.RangeBoundary.CLOSED, thisValue, (Comparable)discreteValues.get(indexOf + 1), Range.RangeBoundary.OPEN, rule, col);
        }
        if (ut.getOperator() == UnaryTestNode.UnaryOperator.LTE) {
            return new Interval(minMax.getLowerBound().getBoundaryType(), (Comparable<?>)minMax.getLowerBound().getValue(), this.valueFromNode(ut.getValue()), Range.RangeBoundary.CLOSED, rule, col);
        }
        if (ut.getOperator() == UnaryTestNode.UnaryOperator.LT) {
            return new Interval(minMax.getLowerBound().getBoundaryType(), (Comparable<?>)minMax.getLowerBound().getValue(), this.valueFromNode(ut.getValue()), Range.RangeBoundary.OPEN, rule, col);
        }
        if (ut.getOperator() == UnaryTestNode.UnaryOperator.GT) {
            return new Interval(Range.RangeBoundary.OPEN, this.valueFromNode(ut.getValue()), (Comparable<?>)minMax.getUpperBound().getValue(), minMax.getUpperBound().getBoundaryType(), rule, col);
        }
        if (ut.getOperator() == UnaryTestNode.UnaryOperator.GTE) {
            return new Interval(Range.RangeBoundary.CLOSED, this.valueFromNode(ut.getValue()), (Comparable<?>)minMax.getUpperBound().getValue(), minMax.getUpperBound().getBoundaryType(), rule, col);
        }
        if (ut.getValue() instanceof RangeNode) {
            RangeNode rangeNode = (RangeNode)ut.getValue();
            if (!(rangeNode.getStart() instanceof NullNode || rangeNode.getStart() instanceof UndefinedValueNode || rangeNode.getEnd() instanceof NullNode || rangeNode.getEnd() instanceof UndefinedValueNode)) {
                return new Interval(rangeNode.getLowerBound() == RangeNode.IntervalBoundary.OPEN ? Range.RangeBoundary.OPEN : Range.RangeBoundary.CLOSED, this.valueFromNode(rangeNode.getStart()), this.valueFromNode(rangeNode.getEnd()), rangeNode.getUpperBound() == RangeNode.IntervalBoundary.OPEN ? Range.RangeBoundary.OPEN : Range.RangeBoundary.CLOSED, rule, col);
            }
            if (rangeNode.getStart() instanceof NullNode || rangeNode.getStart() instanceof UndefinedValueNode) {
                return new Interval(minMax.getLowerBound().getBoundaryType(), (Comparable<?>)minMax.getLowerBound().getValue(), this.valueFromNode(rangeNode.getEnd()), rangeNode.getUpperBound() == RangeNode.IntervalBoundary.OPEN ? Range.RangeBoundary.OPEN : Range.RangeBoundary.CLOSED, rule, col);
            }
            return new Interval(rangeNode.getLowerBound() == RangeNode.IntervalBoundary.OPEN ? Range.RangeBoundary.OPEN : Range.RangeBoundary.CLOSED, this.valueFromNode(rangeNode.getStart()), (Comparable<?>)minMax.getUpperBound().getValue(), minMax.getUpperBound().getBoundaryType(), rule, col);
        }
        throw new UnsupportedOperationException("UnaryTest type: " + ut);
    }

    private Comparable<?> valueFromNode(BaseNode node, Visitor<Comparable<?>> visitor) {
        return (Comparable)node.accept(visitor);
    }

    private Comparable<?> valueFromNode(BaseNode node) {
        return this.valueFromNode(node, (Visitor<Comparable<?>>)this.valueFromNodeVisitor);
    }

    private static class ToIntervals {
        public final List<Interval> intervals;
        public final boolean allSingularities;

        public ToIntervals(List<Interval> intervals, boolean allSingularities) {
            this.intervals = intervals;
            this.allSingularities = allSingularities;
        }
    }
}

