/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.DecisionTable;
import org.kie.dmn.validation.dtanalysis.DMNDTAnalysisMessage;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Overlap;

public class DTAnalysis {
    private final List<Hyperrectangle> gaps = new ArrayList<Hyperrectangle>();
    private final List<Overlap> overlaps = new ArrayList<Overlap>();
    private final DecisionTable sourceDT;
    private final Throwable error;

    public DTAnalysis(DecisionTable sourceDT) {
        this.sourceDT = sourceDT;
        this.error = null;
    }

    private DTAnalysis(DecisionTable sourceDT, Throwable error) {
        this.sourceDT = sourceDT;
        this.error = error;
    }

    public static DTAnalysis ofError(DecisionTable sourceDT, Throwable error) {
        return new DTAnalysis(sourceDT, error);
    }

    public boolean isError() {
        return this.error != null;
    }

    public Collection<Hyperrectangle> getGaps() {
        return Collections.unmodifiableList(this.gaps);
    }

    public void addGap(Hyperrectangle gap) {
        this.gaps.add(gap);
    }

    public DMNModelInstrumentedBase getSource() {
        return this.sourceDT;
    }

    public List<Overlap> getOverlaps() {
        return Collections.unmodifiableList(this.overlaps);
    }

    public void addOverlap(Overlap overlap) {
        this.overlaps.add(overlap);
    }

    public void normalize() {
        int prevSize = this.overlaps.size();
        this.internal_normalize();
        int curSize = this.overlaps.size();
        if (curSize != prevSize) {
            this.normalize();
        }
    }

    private void internal_normalize() {
        ArrayList<Overlap> newOverlaps = new ArrayList<Overlap>();
        ArrayList<Overlap> overlapsProcessing = new ArrayList<Overlap>();
        overlapsProcessing.addAll(this.overlaps);
        while (!overlapsProcessing.isEmpty()) {
            Overlap curOverlap = (Overlap)overlapsProcessing.remove(0);
            for (Overlap otherOverlap : overlapsProcessing) {
                int x = curOverlap.contigousOnDimension(otherOverlap);
                if (x <= 0) continue;
                Overlap mergedOverlap = Overlap.newByMergeOnDimension(curOverlap, otherOverlap, x);
                curOverlap = null;
                overlapsProcessing.remove(otherOverlap);
                overlapsProcessing.add(0, mergedOverlap);
            }
            if (curOverlap == null) continue;
            newOverlaps.add(curOverlap);
        }
        this.overlaps.clear();
        this.overlaps.addAll(newOverlaps);
    }

    public List<? extends DMNMessage> asDMNMessages() {
        ArrayList<DMNMessage> results = new ArrayList<DMNMessage>();
        if (this.isError()) {
            DMNDTAnalysisMessage m = new DMNDTAnalysisMessage(this, DMNMessage.Severity.INFO, MsgUtil.createMessage((Msg.Message2)Msg.DTANALYSIS_ERROR, (Object)this.sourceDT.getOutputLabel(), (Object)this.error.getMessage()), DMNMessageType.DECISION_TABLE_ANALYSIS_ERROR);
            results.addAll(Arrays.asList(new DMNMessage[]{m}));
            return results;
        }
        results.addAll(this.gapsAsMessages());
        results.addAll(this.overlapsAsMessages());
        if (results.isEmpty()) {
            DMNDTAnalysisMessage m = new DMNDTAnalysisMessage(this, DMNMessage.Severity.INFO, MsgUtil.createMessage((Msg.Message1)Msg.DTANALYSIS_EMPTY, (Object)this.sourceDT.getOutputLabel()), DMNMessageType.DECISION_TABLE_ANALYSIS);
            results.addAll(Arrays.asList(new DMNMessage[]{m}));
            return results;
        }
        return results;
    }

    private Collection overlapsAsMessages() {
        ArrayList<DMNDTAnalysisMessage> results = new ArrayList<DMNDTAnalysisMessage>();
        for (Overlap overlap : this.overlaps) {
            results.add(new DMNDTAnalysisMessage(this, DMNMessage.Severity.INFO, MsgUtil.createMessage((Msg.Message1)Msg.DTANALYSIS_OVERLAP, (Object)overlap), DMNMessageType.DECISION_TABLE_OVERLAP));
        }
        return results;
    }

    private Collection gapsAsMessages() {
        ArrayList<DMNDTAnalysisMessage> results = new ArrayList<DMNDTAnalysisMessage>();
        for (Hyperrectangle gap : this.gaps) {
            results.add(new DMNDTAnalysisMessage(this, DMNMessage.Severity.INFO, MsgUtil.createMessage((Msg.Message1)Msg.DTANALYSIS_GAP, (Object)gap), DMNMessageType.DECISION_TABLE_GAP));
        }
        return results;
    }
}

