/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kie.dmn.validation.dtanalysis.model.Interval;

public class Hyperrectangle {
    private final int dimensions;
    private final List<Interval> edges = new ArrayList<Interval>();

    public Hyperrectangle(int dimensions, List<Interval> edges) {
        this.dimensions = dimensions;
        this.edges.addAll(edges);
    }

    public String toString() {
        return IntStream.range(0, this.dimensions).mapToObj(i -> {
            if (i < this.edges.size()) {
                return this.edges.get(i).toString();
            }
            return "-";
        }).collect(Collectors.joining(" "));
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public List<Interval> getEdges() {
        return Collections.unmodifiableList(this.edges);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dimensions;
        result = 31 * result + (this.edges == null ? 0 : this.edges.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Hyperrectangle other = (Hyperrectangle)obj;
        if (this.dimensions != other.dimensions) {
            return false;
        }
        return !(this.edges == null ? other.edges != null : !this.edges.equals(other.edges));
    }
}

