/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.compiler.DMNProfile;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.codegen.feel11.ProcessedExpression;
import org.kie.dmn.feel.codegen.feel11.ProcessedUnaryTest;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.BooleanNode;
import org.kie.dmn.feel.lang.ast.DashNode;
import org.kie.dmn.feel.lang.ast.NumberNode;
import org.kie.dmn.feel.lang.ast.RangeNode;
import org.kie.dmn.feel.lang.ast.SignedUnaryNode;
import org.kie.dmn.feel.lang.ast.StringNode;
import org.kie.dmn.feel.lang.ast.UnaryTestListNode;
import org.kie.dmn.feel.lang.ast.UnaryTestNode;
import org.kie.dmn.feel.lang.impl.UnaryTestInterpretedExecutableExpression;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.util.EvalHelper;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.DecisionRule;
import org.kie.dmn.model.api.DecisionTable;
import org.kie.dmn.model.api.Expression;
import org.kie.dmn.model.api.InputClause;
import org.kie.dmn.model.api.ItemDefinition;
import org.kie.dmn.model.api.LiteralExpression;
import org.kie.dmn.model.api.OutputClause;
import org.kie.dmn.model.api.UnaryTests;
import org.kie.dmn.validation.dtanalysis.DMNDTAnalysisException;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.BoundValueComparator;
import org.kie.dmn.validation.dtanalysis.model.DDTAInputClause;
import org.kie.dmn.validation.dtanalysis.model.DDTAInputEntry;
import org.kie.dmn.validation.dtanalysis.model.DDTAOutputClause;
import org.kie.dmn.validation.dtanalysis.model.DDTARule;
import org.kie.dmn.validation.dtanalysis.model.DDTATable;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;
import org.kie.dmn.validation.dtanalysis.model.Overlap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNDTAnalyser {
    private static final Logger LOG = LoggerFactory.getLogger(DMNDTAnalyser.class);
    private final FEEL FEEL;

    public DMNDTAnalyser(List<DMNProfile> dmnProfiles) {
        this.FEEL = org.kie.dmn.feel.FEEL.newInstance(dmnProfiles);
    }

    public List<DTAnalysis> analyse(DMNModel model) {
        ArrayList<DTAnalysis> results = new ArrayList<DTAnalysis>();
        for (DecisionNode dn : model.getDecisions()) {
            Expression expression = dn.getDecision().getExpression();
            if (!(expression instanceof DecisionTable)) continue;
            DecisionTable decisionTable = (DecisionTable)expression;
            try {
                DTAnalysis result = this.dmnDTAnalysis(model, dn, decisionTable);
                results.add(result);
            }
            catch (Throwable t) {
                LOG.debug("Skipped dmnDTAnalysis for table: " + decisionTable.getId(), t);
                DTAnalysis result = DTAnalysis.ofError(decisionTable, t);
                results.add(result);
            }
        }
        return results;
    }

    private DTAnalysis dmnDTAnalysis(DMNModel model, DecisionNode dn, DecisionTable dt) {
        DDTATable ddtaTable = new DDTATable();
        this.compileTableInputClauses(model, dt, ddtaTable);
        this.compileTableOutputClauses(model, dt, ddtaTable);
        this.compileTableRules(dt, ddtaTable);
        this.printDebugTableInfo(ddtaTable);
        DTAnalysis analysis = new DTAnalysis(dt, ddtaTable);
        LOG.debug("findGaps");
        DMNDTAnalyser.findGaps(analysis, ddtaTable, 0, new Interval[ddtaTable.inputCols()], Collections.emptyList());
        LOG.debug("findOverlaps");
        this.findOverlaps(analysis, ddtaTable, 0, new Interval[ddtaTable.inputCols()], Collections.emptyList());
        LOG.debug("computeMaskedRules");
        analysis.computeMaskedRules();
        LOG.debug("computeMisleadingRules");
        analysis.computeMisleadingRules();
        LOG.debug("normalize");
        analysis.normalize();
        return analysis;
    }

    private void printDebugTableInfo(DDTATable ddtaTable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}", (Object)ddtaTable);
            LOG.debug("project on columns.");
            for (int colIdx = 0; colIdx < ddtaTable.inputCols(); ++colIdx) {
                LOG.debug("colIdx " + colIdx);
                List<Interval> intervals = ddtaTable.projectOnColumnIdx(colIdx);
                LOG.debug("{}", intervals);
                List bounds = intervals.stream().flatMap(i -> Stream.of(i.getLowerBound(), i.getUpperBound())).collect(Collectors.toList());
                LOG.debug("{}", bounds);
                Collections.sort(bounds);
                LOG.debug("{}", bounds);
            }
        }
    }

    private void compileTableRules(DecisionTable dt, DDTATable ddtaTable) {
        for (int jRowIdx = 0; jRowIdx < dt.getRule().size(); ++jRowIdx) {
            UnaryTestInterpretedExecutableExpression interpreted;
            DecisionRule r = (DecisionRule)dt.getRule().get(jRowIdx);
            DDTARule ddtaRule = new DDTARule();
            int jColIdx = 0;
            for (UnaryTests ie : r.getInputEntry()) {
                ProcessedUnaryTest compileUnaryTests = (ProcessedUnaryTest)this.FEEL.compileUnaryTests(ie.getText(), this.FEEL.newCompilerContext());
                interpreted = compileUnaryTests.getInterpreted();
                UnaryTestListNode utln = (UnaryTestListNode)interpreted.getASTNode();
                DDTAInputClause ddtaInputClause = ddtaTable.getInputs().get(jColIdx);
                DDTAInputEntry ddtaInputEntry = new DDTAInputEntry(utln.getElements(), DMNDTAnalyser.toIntervals(utln.getElements(), ddtaInputClause.getDomainMinMax(), ddtaInputClause.getDiscreteValues(), jRowIdx + 1, jColIdx + 1));
                for (Interval interval : ddtaInputEntry.getIntervals()) {
                    Interval domainMinMax = ddtaTable.getInputs().get(jColIdx).getDomainMinMax();
                    if (domainMinMax.includes(interval)) continue;
                    throw new IllegalStateException(MsgUtil.createMessage((Msg.Message4)Msg.DTANALYSIS_ERROR_RULE_OUTSIDE_DOMAIN, (Object)(jRowIdx + 1), (Object)interval, (Object)domainMinMax, (Object)(jColIdx + 1)));
                }
                ddtaRule.getInputEntry().add(ddtaInputEntry);
                ++jColIdx;
            }
            for (LiteralExpression oe : r.getOutputEntry()) {
                ProcessedExpression compile = (ProcessedExpression)this.FEEL.compile(oe.getText(), this.FEEL.newCompilerContext());
                interpreted = compile.getInterpreted();
                BaseNode outputEntryNode = (BaseNode)interpreted.getASTNode();
                Comparable<?> value = DMNDTAnalyser.valueFromNode(outputEntryNode);
                ddtaRule.getOutputEntry().add(value);
                ++jColIdx;
            }
            ddtaTable.getRule().add(ddtaRule);
        }
    }

    private void compileTableInputClauses(DMNModel model, DecisionTable dt, DDTATable ddtaTable) {
        for (int jColIdx = 0; jColIdx < dt.getInput().size(); ++jColIdx) {
            String allowedValues;
            InputClause ie = (InputClause)dt.getInput().get(jColIdx);
            Interval infDomain = new Interval(Range.RangeBoundary.CLOSED, Interval.NEG_INF, Interval.POS_INF, Range.RangeBoundary.CLOSED, 0, jColIdx + 1);
            if (ie.getInputValues() != null) {
                allowedValues = ie.getInputValues().getText();
            } else {
                QName typeRef = DMNCompilerImpl.getNamespaceAndName((DMNModelInstrumentedBase)dt, (Map)((DMNModelImpl)model).getImportAliasesForNS(), (QName)ie.getInputExpression().getTypeRef(), (String)model.getNamespace());
                allowedValues = this.findAllowedValues(model, typeRef);
            }
            if (allowedValues != null) {
                DDTAInputClause ic;
                ProcessedUnaryTest compileUnaryTests = (ProcessedUnaryTest)this.FEEL.compileUnaryTests(allowedValues, this.FEEL.newCompilerContext());
                UnaryTestInterpretedExecutableExpression interpreted = compileUnaryTests.getInterpreted();
                UnaryTestListNode utln = (UnaryTestListNode)interpreted.getASTNode();
                if (utln.getElements().size() != 1) {
                    this.verifyUnaryTestsAllEQ(utln, dt);
                    List<Comparable<?>> discreteValues = this.getDiscreteValues(utln);
                    Collections.sort(discreteValues);
                    Interval discreteDomainMinMax = new Interval(Range.RangeBoundary.CLOSED, discreteValues.get(0), discreteValues.get(discreteValues.size() - 1), Range.RangeBoundary.CLOSED, 0, jColIdx + 1);
                    ic = new DDTAInputClause(discreteDomainMinMax, discreteValues);
                    ddtaTable.getInputs().add(ic);
                    continue;
                }
                if (utln.getElements().size() == 1) {
                    UnaryTestNode utn0 = (UnaryTestNode)utln.getElements().get(0);
                    Interval interval = DMNDTAnalyser.utnToInterval(utn0, infDomain, null, 0, jColIdx + 1);
                    ic = new DDTAInputClause(interval);
                    ddtaTable.getInputs().add(ic);
                    continue;
                }
                throw new IllegalStateException("inputValues not null but utln: " + utln);
            }
            DDTAInputClause ic = new DDTAInputClause(infDomain);
            ddtaTable.getInputs().add(ic);
        }
    }

    private void compileTableOutputClauses(DMNModel model, DecisionTable dt, DDTATable ddtaTable) {
        for (int jColIdx = 0; jColIdx < dt.getOutput().size(); ++jColIdx) {
            OutputClause oe = (OutputClause)dt.getOutput().get(jColIdx);
            Interval infDomain = new Interval(Range.RangeBoundary.CLOSED, Interval.NEG_INF, Interval.POS_INF, Range.RangeBoundary.CLOSED, 0, jColIdx + 1);
            String allowedValues = null;
            if (oe.getOutputValues() != null) {
                allowedValues = oe.getOutputValues().getText();
            } else {
                QName outputTypeRef;
                QName qName = outputTypeRef = oe.getTypeRef() == null && dt.getOutput().size() == 1 ? dt.getTypeRef() : oe.getTypeRef();
                if (outputTypeRef != null) {
                    QName typeRef = DMNCompilerImpl.getNamespaceAndName((DMNModelInstrumentedBase)dt, (Map)((DMNModelImpl)model).getImportAliasesForNS(), (QName)outputTypeRef, (String)model.getNamespace());
                    allowedValues = this.findAllowedValues(model, typeRef);
                }
            }
            if (allowedValues != null) {
                ProcessedUnaryTest compileUnaryTests = (ProcessedUnaryTest)this.FEEL.compileUnaryTests(allowedValues, this.FEEL.newCompilerContext());
                UnaryTestInterpretedExecutableExpression interpreted = compileUnaryTests.getInterpreted();
                UnaryTestListNode utln = (UnaryTestListNode)interpreted.getASTNode();
                if (utln.getElements().size() != 1) {
                    this.verifyUnaryTestsAllEQ(utln, dt);
                    List<Comparable<?>> discreteValues = this.getDiscreteValues(utln);
                    ArrayList outputOrder = new ArrayList(discreteValues);
                    Collections.sort(discreteValues);
                    Interval discreteDomainMinMax = new Interval(Range.RangeBoundary.CLOSED, discreteValues.get(0), discreteValues.get(discreteValues.size() - 1), Range.RangeBoundary.CLOSED, 0, jColIdx + 1);
                    DDTAOutputClause ic = new DDTAOutputClause(discreteDomainMinMax, discreteValues, outputOrder);
                    ddtaTable.getOutputs().add(ic);
                    continue;
                }
                if (utln.getElements().size() == 1) {
                    UnaryTestNode utn0 = (UnaryTestNode)utln.getElements().get(0);
                    Interval interval = DMNDTAnalyser.utnToInterval(utn0, infDomain, null, 0, jColIdx + 1);
                    DDTAOutputClause ic = new DDTAOutputClause(interval);
                    ddtaTable.getOutputs().add(ic);
                    continue;
                }
                throw new IllegalStateException("inputValues not null but utln: " + utln);
            }
            DDTAOutputClause ic = new DDTAOutputClause(infDomain);
            ddtaTable.getOutputs().add(ic);
        }
    }

    private void verifyUnaryTestsAllEQ(UnaryTestListNode utln, DecisionTable dt) {
        if (!utln.getElements().stream().allMatch(e -> e instanceof UnaryTestNode && ((UnaryTestNode)e).getOperator() == UnaryTestNode.UnaryOperator.EQ)) {
            throw new DMNDTAnalysisException("Multiple constraint on column: " + utln, dt);
        }
    }

    private List<Comparable<?>> getDiscreteValues(UnaryTestListNode utln) {
        ArrayList discreteValues = new ArrayList();
        for (BaseNode e : utln.getElements()) {
            Comparable<?> v = DMNDTAnalyser.valueFromNode(((UnaryTestNode)e).getValue());
            discreteValues.add(v);
        }
        return discreteValues;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String findAllowedValues(DMNModel model, QName typeRef) {
        if (typeRef.getNamespaceURI().equals(model.getNamespace())) {
            Optional<ItemDefinition> opt = model.getDefinitions().getItemDefinition().stream().filter(id -> id.getName().equals(typeRef.getLocalPart())).findFirst();
            if (!opt.isPresent()) throw new IllegalStateException("Unable to locate typeRef " + typeRef + " to determine domain.");
            ItemDefinition id2 = opt.get();
            if (id2.getAllowedValues() == null) return null;
            return id2.getAllowedValues().getText();
        }
        if (!typeRef.getNamespaceURI().equals(model.getDefinitions().getURIFEEL()) || !typeRef.getLocalPart().equals("boolean")) return null;
        return "false, true";
    }

    private void findOverlaps(DTAnalysis analysis, DDTATable ddtaTable, int jColIdx, Interval[] currentIntervals, Collection<Integer> activeRules) {
        LOG.debug("findOverlaps jColIdx {}, currentIntervals {}, activeRules {}", new Object[]{jColIdx, currentIntervals, activeRules});
        if (jColIdx < ddtaTable.inputCols()) {
            List<Bound> bounds = DMNDTAnalyser.findBoundsSorted(ddtaTable, jColIdx, activeRules);
            ArrayList<Interval> activeIntervals = new ArrayList<Interval>();
            Bound lastBound = bounds.get(0);
            for (Bound currentBound : bounds) {
                LOG.debug("lastBound {} currentBound {}      activeIntervals {} == rules {}", new Object[]{lastBound, currentBound, activeIntervals, DMNDTAnalyser.activeIntervalsToRules(activeIntervals)});
                if (activeIntervals.size() > 1 && DMNDTAnalyser.canBeNewCurrIntervalForOverlaps(lastBound, currentBound)) {
                    Interval analysisInterval;
                    currentIntervals[jColIdx] = analysisInterval = new Interval(lastBound.isUpperBound() ? DMNDTAnalyser.invertBoundary(lastBound.getBoundaryType()) : lastBound.getBoundaryType(), (Comparable<?>)lastBound.getValue(), (Comparable<?>)currentBound.getValue(), currentBound.isLowerBound() ? DMNDTAnalyser.invertBoundary(currentBound.getBoundaryType()) : currentBound.getBoundaryType(), 0, 0);
                    this.findOverlaps(analysis, ddtaTable, jColIdx + 1, currentIntervals, DMNDTAnalyser.activeIntervalsToRules(activeIntervals));
                }
                if (currentBound.isLowerBound()) {
                    activeIntervals.add(currentBound.getParent());
                } else {
                    activeIntervals.remove(currentBound.getParent());
                }
                lastBound = currentBound;
            }
            currentIntervals[jColIdx] = null;
        } else if (jColIdx == ddtaTable.inputCols()) {
            if (activeRules.size() > 1) {
                Hyperrectangle overlap = new Hyperrectangle(ddtaTable.inputCols(), Arrays.asList(currentIntervals));
                LOG.debug("OVERLAP DETECTED {}", (Object)overlap);
                analysis.addOverlap(new Overlap(activeRules, overlap));
            }
        } else {
            throw new IllegalStateException();
        }
        LOG.debug(".");
    }

    private static boolean canBeNewCurrIntervalForOverlaps(Bound<?> lastBound, Bound<?> currentBound) {
        int vCompare = BoundValueComparator.compareValueDispatchingToInf(lastBound, currentBound);
        if (vCompare != 0) {
            return true;
        }
        return lastBound.getBoundaryType() == Range.RangeBoundary.CLOSED && currentBound.getBoundaryType() == Range.RangeBoundary.CLOSED;
    }

    private static void findGaps(DTAnalysis analysis, DDTATable ddtaTable, int jColIdx, Interval[] currentIntervals, Collection<Integer> activeRules) {
        LOG.debug("findGaps jColIdx {}, currentIntervals {}, activeRules {}", new Object[]{jColIdx, currentIntervals, activeRules});
        if (jColIdx < ddtaTable.inputCols()) {
            DMNDTAnalyser.findBoundsSorted(ddtaTable, jColIdx, activeRules);
            List<Bound> bounds = DMNDTAnalyser.findBoundsSorted(ddtaTable, jColIdx, activeRules);
            Interval domainRange = ddtaTable.getInputs().get(jColIdx).getDomainMinMax();
            if (!domainRange.getLowerBound().equals(bounds.get(0))) {
                currentIntervals[jColIdx] = DMNDTAnalyser.lastDimensionUncoveredInterval(domainRange.getLowerBound(), bounds.get(0), domainRange);
                Hyperrectangle gap = new Hyperrectangle(ddtaTable.inputCols(), DMNDTAnalyser.buildEdgesForHyperrectangleFromIntervals(currentIntervals, jColIdx));
                analysis.addGap(gap);
                LOG.debug("STARTLEFT GAP DETECTED {}", (Object)gap);
            }
            ArrayList<Interval> activeIntervals = new ArrayList<Interval>();
            Bound lastBound = null;
            for (Bound currentBound : bounds) {
                LOG.debug("lastBound {} currentBound {}      activeIntervals {} == rules {}", new Object[]{lastBound, currentBound, activeIntervals, DMNDTAnalyser.activeIntervalsToRules(activeIntervals)});
                if (activeIntervals.isEmpty() && lastBound != null && !Bound.adOrOver(lastBound, currentBound)) {
                    currentIntervals[jColIdx] = DMNDTAnalyser.lastDimensionUncoveredInterval(lastBound, currentBound, domainRange);
                    Hyperrectangle gap = new Hyperrectangle(ddtaTable.inputCols(), DMNDTAnalyser.buildEdgesForHyperrectangleFromIntervals(currentIntervals, jColIdx));
                    LOG.debug("GAP DETECTED {}", (Object)gap);
                    analysis.addGap(gap);
                }
                if (!activeIntervals.isEmpty() && DMNDTAnalyser.canBeNewCurrInterval(lastBound, currentBound)) {
                    Interval missingInterval;
                    currentIntervals[jColIdx] = missingInterval = new Interval(lastBound.isUpperBound() ? DMNDTAnalyser.invertBoundary(lastBound.getBoundaryType()) : lastBound.getBoundaryType(), (Comparable<?>)lastBound.getValue(), (Comparable<?>)currentBound.getValue(), currentBound.isLowerBound() ? DMNDTAnalyser.invertBoundary(currentBound.getBoundaryType()) : currentBound.getBoundaryType(), 0, 0);
                    DMNDTAnalyser.findGaps(analysis, ddtaTable, jColIdx + 1, currentIntervals, DMNDTAnalyser.activeIntervalsToRules(activeIntervals));
                }
                if (currentBound.isLowerBound()) {
                    activeIntervals.add(currentBound.getParent());
                } else {
                    activeIntervals.remove(currentBound.getParent());
                }
                lastBound = currentBound;
            }
            if (!lastBound.equals(domainRange.getUpperBound())) {
                currentIntervals[jColIdx] = DMNDTAnalyser.lastDimensionUncoveredInterval(lastBound, domainRange.getUpperBound(), domainRange);
                Hyperrectangle gap = new Hyperrectangle(ddtaTable.inputCols(), DMNDTAnalyser.buildEdgesForHyperrectangleFromIntervals(currentIntervals, jColIdx));
                LOG.debug("ENDRIGHT GAP DETECTED {}", (Object)gap);
                analysis.addGap(gap);
            }
            currentIntervals[jColIdx] = null;
        }
        LOG.debug(".");
    }

    private static List<Bound> findBoundsSorted(DDTATable ddtaTable, int jColIdx, Collection<Integer> activeRules) {
        List<Interval> intervals = ddtaTable.projectOnColumnIdx(jColIdx);
        if (!activeRules.isEmpty()) {
            intervals = intervals.stream().filter(i -> activeRules.contains(i.getRule())).collect(Collectors.toList());
        }
        LOG.debug("intervals {}", intervals);
        List<Bound> bounds = intervals.stream().flatMap(i -> Stream.of(i.getLowerBound(), i.getUpperBound())).collect(Collectors.toList());
        Collections.sort(bounds);
        LOG.debug("bounds (sorted) {}", bounds);
        return bounds;
    }

    private static List<Interval> buildEdgesForHyperrectangleFromIntervals(Interval[] currentIntervals, int intervalsIndex) {
        ArrayList<Interval> edges = new ArrayList<Interval>();
        for (int p = 0; p <= intervalsIndex; ++p) {
            edges.add(currentIntervals[p]);
        }
        return edges;
    }

    private static Collection<Integer> activeIntervalsToRules(List<Interval> activeIntervals) {
        return activeIntervals.stream().map(Interval::getRule).collect(Collectors.toList());
    }

    private static boolean canBeNewCurrInterval(Bound<?> lastBound, Bound<?> currentBound) {
        int vCompare = BoundValueComparator.compareValueDispatchingToInf(lastBound, currentBound);
        if (vCompare != 0) {
            return true;
        }
        if (lastBound.isLowerBound() && currentBound.isUpperBound()) {
            return true;
        }
        return lastBound.isUpperBound() && lastBound.getBoundaryType() == Range.RangeBoundary.OPEN && currentBound.isLowerBound() && currentBound.getBoundaryType() == Range.RangeBoundary.OPEN;
    }

    private static Interval lastDimensionUncoveredInterval(Bound<?> l, Bound<?> r, Interval domain) {
        boolean isLmin = l.isLowerBound() && l.equals(domain.getLowerBound());
        boolean isRmax = r.isUpperBound() && r.equals(domain.getUpperBound());
        return new Interval(isLmin ? domain.getLowerBound().getBoundaryType() : DMNDTAnalyser.invertBoundary(l.getBoundaryType()), (Comparable<?>)l.getValue(), (Comparable<?>)r.getValue(), isRmax ? domain.getUpperBound().getBoundaryType() : DMNDTAnalyser.invertBoundary(r.getBoundaryType()), 0, 0);
    }

    private static Range.RangeBoundary invertBoundary(Range.RangeBoundary b) {
        if (b == Range.RangeBoundary.OPEN) {
            return Range.RangeBoundary.CLOSED;
        }
        if (b == Range.RangeBoundary.CLOSED) {
            return Range.RangeBoundary.OPEN;
        }
        throw new IllegalStateException("invertBoundary for: " + b);
    }

    private static List<Interval> toIntervals(List<BaseNode> elements, Interval minMax, List discreteValues, int rule, int col) {
        ArrayList<Interval> results = new ArrayList<Interval>();
        if (discreteValues != null && !discreteValues.isEmpty() && DMNDTAnalyser.areAllEQUnaryTest(elements) && elements.size() > 1) {
            BitSet hitValues = new BitSet(discreteValues.size());
            for (BaseNode n : elements) {
                Comparable<?> thisValue = DMNDTAnalyser.valueFromNode(((UnaryTestNode)n).getValue());
                int indexOf = discreteValues.indexOf(thisValue);
                if (indexOf < 0) {
                    throw new IllegalStateException("Unable to determine discreteValue index for: " + n);
                }
                hitValues.set(indexOf);
            }
            int lowerBoundIdx = -1;
            int upperBoundIdx = -1;
            for (int i = 0; i < hitValues.length(); ++i) {
                boolean curValue = hitValues.get(i);
                if (curValue) {
                    if (lowerBoundIdx < 0) {
                        lowerBoundIdx = i;
                        upperBoundIdx = i;
                        continue;
                    }
                    upperBoundIdx = i;
                    continue;
                }
                if (lowerBoundIdx < 0 || upperBoundIdx < 0) continue;
                results.add(DMNDTAnalyser.createIntervalOfRule(discreteValues, rule, col, lowerBoundIdx, upperBoundIdx));
            }
            if (lowerBoundIdx >= 0 && upperBoundIdx >= 0) {
                results.add(DMNDTAnalyser.createIntervalOfRule(discreteValues, rule, col, lowerBoundIdx, upperBoundIdx));
            }
        } else {
            for (BaseNode n : elements) {
                if (n instanceof DashNode) {
                    results.add(new Interval(minMax.getLowerBound().getBoundaryType(), (Comparable<?>)minMax.getLowerBound().getValue(), (Comparable<?>)minMax.getUpperBound().getValue(), minMax.getUpperBound().getBoundaryType(), rule, col));
                    continue;
                }
                UnaryTestNode ut = (UnaryTestNode)n;
                results.add(DMNDTAnalyser.utnToInterval(ut, minMax, discreteValues, rule, col));
            }
        }
        return results;
    }

    private static Interval createIntervalOfRule(List discreteValues, int rule, int col, int lowerBoundIdx, int upperBoundIdx) {
        Comparable lowValue = (Comparable)discreteValues.get(lowerBoundIdx);
        Comparable highValue = (Comparable)discreteValues.get(upperBoundIdx);
        if (upperBoundIdx + 1 == discreteValues.size()) {
            return new Interval(Range.RangeBoundary.CLOSED, lowValue, highValue, Range.RangeBoundary.CLOSED, rule, col);
        }
        return new Interval(Range.RangeBoundary.CLOSED, lowValue, (Comparable)discreteValues.get(upperBoundIdx + 1), Range.RangeBoundary.OPEN, rule, col);
    }

    private static boolean areAllEQUnaryTest(List<BaseNode> elements) {
        try {
            boolean result = true;
            for (BaseNode n : elements) {
                result = result && ((UnaryTestNode)n).getOperator() == UnaryTestNode.UnaryOperator.EQ;
            }
            return result;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static Interval utnToInterval(UnaryTestNode ut, Interval minMax, List discreteValues, int rule, int col) {
        if (ut.getOperator() == UnaryTestNode.UnaryOperator.EQ) {
            if (discreteValues == null || discreteValues.isEmpty()) {
                return new Interval(Range.RangeBoundary.CLOSED, DMNDTAnalyser.valueFromNode(ut.getValue()), DMNDTAnalyser.valueFromNode(ut.getValue()), Range.RangeBoundary.CLOSED, rule, col);
            }
            Comparable<?> thisValue = DMNDTAnalyser.valueFromNode(ut.getValue());
            int indexOf = discreteValues.indexOf(thisValue);
            if (indexOf < 0) {
                throw new IllegalStateException("Unable to determine discreteValue index for: " + ut);
            }
            if (indexOf + 1 == discreteValues.size()) {
                return new Interval(Range.RangeBoundary.CLOSED, thisValue, thisValue, Range.RangeBoundary.CLOSED, rule, col);
            }
            return new Interval(Range.RangeBoundary.CLOSED, thisValue, (Comparable)discreteValues.get(indexOf + 1), Range.RangeBoundary.OPEN, rule, col);
        }
        if (ut.getOperator() == UnaryTestNode.UnaryOperator.LTE) {
            return new Interval(minMax.getLowerBound().getBoundaryType(), (Comparable<?>)minMax.getLowerBound().getValue(), DMNDTAnalyser.valueFromNode(ut.getValue()), Range.RangeBoundary.CLOSED, rule, col);
        }
        if (ut.getOperator() == UnaryTestNode.UnaryOperator.LT) {
            return new Interval(minMax.getLowerBound().getBoundaryType(), (Comparable<?>)minMax.getLowerBound().getValue(), DMNDTAnalyser.valueFromNode(ut.getValue()), Range.RangeBoundary.OPEN, rule, col);
        }
        if (ut.getOperator() == UnaryTestNode.UnaryOperator.GT) {
            return new Interval(Range.RangeBoundary.OPEN, DMNDTAnalyser.valueFromNode(ut.getValue()), (Comparable<?>)minMax.getUpperBound().getValue(), minMax.getUpperBound().getBoundaryType(), rule, col);
        }
        if (ut.getOperator() == UnaryTestNode.UnaryOperator.GTE) {
            return new Interval(Range.RangeBoundary.CLOSED, DMNDTAnalyser.valueFromNode(ut.getValue()), (Comparable<?>)minMax.getUpperBound().getValue(), minMax.getUpperBound().getBoundaryType(), rule, col);
        }
        if (ut.getValue() instanceof RangeNode) {
            RangeNode rangeNode = (RangeNode)ut.getValue();
            return new Interval(rangeNode.getLowerBound() == RangeNode.IntervalBoundary.OPEN ? Range.RangeBoundary.OPEN : Range.RangeBoundary.CLOSED, DMNDTAnalyser.valueFromNode(rangeNode.getStart()), DMNDTAnalyser.valueFromNode(rangeNode.getEnd()), rangeNode.getUpperBound() == RangeNode.IntervalBoundary.OPEN ? Range.RangeBoundary.OPEN : Range.RangeBoundary.CLOSED, rule, col);
        }
        throw new UnsupportedOperationException("UnaryTest type: " + ut);
    }

    private static Comparable<?> valueFromNode(BaseNode node) {
        if (node instanceof NumberNode) {
            NumberNode numberNode = (NumberNode)node;
            return numberNode.getValue();
        }
        if (node instanceof BooleanNode) {
            BooleanNode booleanNode = (BooleanNode)node;
            return booleanNode.getValue();
        }
        if (node instanceof StringNode) {
            StringNode stringNode = (StringNode)node;
            return EvalHelper.unescapeString((String)stringNode.getText());
        }
        if (node instanceof SignedUnaryNode) {
            SignedUnaryNode signedUnaryNode = (SignedUnaryNode)node;
            BaseNode signedExpr = signedUnaryNode.getExpression();
            if (signedExpr instanceof NumberNode) {
                BigDecimal valueFromNode = (BigDecimal)DMNDTAnalyser.valueFromNode(signedExpr);
                if (signedUnaryNode.getSign() == SignedUnaryNode.Sign.NEGATIVE) {
                    return BigDecimal.valueOf(-1L).multiply(valueFromNode);
                }
                return valueFromNode;
            }
            throw new UnsupportedOperationException("valueFromNode: " + node);
        }
        throw new UnsupportedOperationException("valueFromNode: " + node);
    }
}

