/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis.model;

import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.validation.dtanalysis.model.Bound;

public class Interval {
    public static final Comparable<?> POS_INF = new Comparable<Object>(){

        @Override
        public int compareTo(Object o) {
            return o == this ? 0 : 1;
        }

        public String toString() {
            return "+Inf";
        }
    };
    public static final Comparable<?> NEG_INF = new Comparable<Object>(){

        @Override
        public int compareTo(Object o) {
            return o == this ? 0 : -1;
        }

        public String toString() {
            return "-Inf";
        }
    };
    private final Bound<?> lowerBound;
    private final Bound<?> upperBound;
    private final int rule;
    private final int col;

    public Interval(Range.RangeBoundary lowBoundary, Comparable<?> start, Comparable<?> end, Range.RangeBoundary highBoundary, int rule, int col) {
        this.lowerBound = new Bound(start, lowBoundary, this);
        this.upperBound = new Bound(end, highBoundary, this);
        this.rule = rule;
        this.col = col;
    }

    private Interval(Bound<?> lowerBound, Bound<?> upperBound) {
        this.lowerBound = new Bound(lowerBound.getValue(), lowerBound.getBoundaryType(), this);
        this.upperBound = new Bound(upperBound.getValue(), upperBound.getBoundaryType(), this);
        this.rule = 0;
        this.col = 0;
    }

    public static Interval newFromBounds(Bound<?> lowerBound, Bound<?> upperBound) {
        return new Interval(lowerBound, upperBound);
    }

    public String toString() {
        return (this.lowerBound.getBoundaryType() == Range.RangeBoundary.OPEN ? "(" : "[") + " " + Bound.boundValueToString(this.lowerBound.getValue()) + " .. " + Bound.boundValueToString(this.upperBound.getValue()) + " " + (this.upperBound.getBoundaryType() == Range.RangeBoundary.OPEN ? ")" : "]");
    }

    public Bound<?> getLowerBound() {
        return this.lowerBound;
    }

    public Bound<?> getUpperBound() {
        return this.upperBound;
    }

    public int getRule() {
        return this.rule;
    }

    public int getCol() {
        return this.col;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lowerBound == null ? 0 : this.lowerBound.hashCode());
        result = 31 * result + (this.upperBound == null ? 0 : this.upperBound.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interval other = (Interval)obj;
        if (this.lowerBound == null ? other.lowerBound != null : !this.lowerBound.equals(other.lowerBound)) {
            return false;
        }
        return !(this.upperBound == null ? other.upperBound != null : !this.upperBound.equals(other.upperBound));
    }

    public boolean includes(Interval o) {
        return this.lowerBound.compareTo(o.lowerBound) <= 0 && this.upperBound.compareTo(o.upperBound) >= 0;
    }
}

