/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis.model;

import java.util.Collections;
import java.util.List;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.Interval;

public class DDTAOutputClause {
    private final Interval domainMinMax;
    private final List discreteValues;
    private final List outputOrder;

    public DDTAOutputClause(Interval domainMinMax) {
        this.domainMinMax = domainMinMax;
        this.discreteValues = Collections.emptyList();
        this.outputOrder = Collections.emptyList();
    }

    public DDTAOutputClause(Interval domainMinMax, List discreteValues, List outputOrder) {
        this.domainMinMax = domainMinMax;
        this.discreteValues = discreteValues;
        this.outputOrder = outputOrder;
    }

    public Bound<?> getMin() {
        return this.domainMinMax.getLowerBound();
    }

    public Bound<?> getMax() {
        return this.domainMinMax.getUpperBound();
    }

    public Interval getDomainMinMax() {
        return this.domainMinMax;
    }

    public List getDiscreteValues() {
        return Collections.unmodifiableList(this.discreteValues);
    }

    public boolean isDiscreteDomain() {
        return this.discreteValues != null && !this.discreteValues.isEmpty();
    }

    public List getOutputOrder() {
        return Collections.unmodifiableList(this.outputOrder);
    }
}

