/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.drools.io.BaseResource;
import org.drools.io.FileSystemResource;
import org.drools.io.ReaderResource;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.modelcompiler.KieBaseBuilder;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceWithConfiguration;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.dmn.api.core.DMNCompilerConfiguration;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.backend.marshalling.v1x.DMNMarshallerFactory;
import org.kie.dmn.backend.marshalling.v1x.XStreamMarshaller;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.api.DMNMessageManager;
import org.kie.dmn.core.assembler.DMNAssemblerService;
import org.kie.dmn.core.assembler.DMNResource;
import org.kie.dmn.core.assembler.DMNResourceDependenciesSorter;
import org.kie.dmn.core.compiler.DMNCompilerConfigurationImpl;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.compiler.DMNProfile;
import org.kie.dmn.core.impl.DMNMessageImpl;
import org.kie.dmn.core.util.DefaultDMNMessagesManager;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.util.ClassLoaderUtil;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.DecisionService;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.v1_1.KieDMNModelInstrumentedBase;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.MessageReporter;
import org.kie.dmn.validation.bootstrap.ValidationBootstrapModels;
import org.kie.dmn.validation.dtanalysis.InternalDMNDTAnalyser;
import org.kie.dmn.validation.dtanalysis.InternalDMNDTAnalyserFactory;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.internal.command.CommandFactory;
import org.kie.internal.io.ResourceWithConfigurationImpl;
import org.kie.internal.utils.ChainedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class DMNValidatorImpl
implements DMNValidator {
    public static final Logger LOG = LoggerFactory.getLogger(DMNValidatorImpl.class);
    static final Schema schemav1_1;
    static final Schema schemav1_2;
    static final Schema schemav1_3;
    static final Schema schemav1_4;
    private Schema overrideSchema = null;
    private final List<DMNProfile> dmnProfiles = new ArrayList<DMNProfile>();
    private final DMNCompilerConfiguration dmnCompilerConfig;
    private final InternalDMNDTAnalyser dmnDTValidator;
    private InternalKnowledgeBase kb11 = KieBaseBuilder.createKieBaseFromModel(Arrays.asList(ValidationBootstrapModels.V1X_MODEL, ValidationBootstrapModels.V11_MODEL), (KieBaseOption[])new KieBaseOption[0]);
    private InternalKnowledgeBase kb12 = KieBaseBuilder.createKieBaseFromModel(Arrays.asList(ValidationBootstrapModels.V1X_MODEL, ValidationBootstrapModels.V12_MODEL), (KieBaseOption[])new KieBaseOption[0]);

    public DMNValidatorImpl(ClassLoader cl, List<DMNProfile> dmnProfiles, Properties p) {
        ChainedProperties localChainedProperties = ChainedProperties.getChainedProperties((ClassLoader)cl);
        if (p != null) {
            localChainedProperties.addProperties(p);
        }
        this.dmnProfiles.addAll(DMNAssemblerService.getDefaultDMNProfiles((ChainedProperties)localChainedProperties));
        this.dmnProfiles.addAll(dmnProfiles);
        ClassLoader classLoader = cl == null ? ClassLoaderUtil.findDefaultClassLoader() : cl;
        DMNCompilerConfigurationImpl dmnCompilerConfiguration = DMNAssemblerService.compilerConfigWithKModulePrefs((ClassLoader)classLoader, (ChainedProperties)localChainedProperties, this.dmnProfiles, (DMNCompilerConfigurationImpl)((DMNCompilerConfigurationImpl)DMNFactory.newCompilerConfiguration()));
        try {
            DMNAssemblerService.applyDecisionLogicCompilerFactory((ClassLoader)classLoader, (DMNCompilerConfigurationImpl)dmnCompilerConfiguration);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to initialize DMNCompiler decisionlogicCompilerFactory based on parameters provided", e);
        }
        this.dmnCompilerConfig = dmnCompilerConfiguration;
        this.dmnDTValidator = InternalDMNDTAnalyserFactory.newDMNDTAnalyser(this.dmnProfiles);
    }

    @Override
    public void dispose() {
    }

    private static List<DMNMessage> processDMNDTValidatorMessages(DMNResource dmnR, List<DTAnalysis> vs) {
        String path = dmnR.getResAndConfig().getResource().getSourcePath();
        List<DMNMessage> dtAnalysisResults = vs.stream().flatMap(a -> a.asDMNMessages().stream()).map(m -> ((DMNMessageImpl)m).withPath(path)).collect(Collectors.toList());
        return dtAnalysisResults;
    }

    public Schema getOverrideSchema() {
        return this.overrideSchema;
    }

    public void setOverrideSchema(Schema overrideSchema) {
        this.overrideSchema = overrideSchema;
    }

    @Override
    public DMNValidator.ValidatorBuilder validateUsing(DMNValidator.Validation ... options) {
        return new ValidatorBuilderImpl(this, options);
    }

    @Override
    public List<DMNMessage> validate(Definitions dmnModel) {
        return this.validate(dmnModel, DMNValidator.Validation.VALIDATE_MODEL);
    }

    @Override
    public List<DMNMessage> validate(Definitions dmnModel, DMNValidator.Validation ... options) {
        DefaultDMNMessagesManager results = new DefaultDMNMessagesManager(null);
        EnumSet<DMNValidator.Validation> flags = EnumSet.copyOf(Arrays.asList(options));
        if (flags.contains((Object)DMNValidator.Validation.VALIDATE_SCHEMA)) {
            MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)dmnModel, (DMNMessageManager)results, null, null, (Msg.Message0)Msg.FAILED_NO_XML_SOURCE);
        }
        try {
            this.validateModelCompilation(DMNValidatorImpl.wrapDefinitions(dmnModel, null), (DMNMessageManager)results, flags);
        }
        catch (Throwable t) {
            MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, (Throwable)t, null, (Msg.Message1)Msg.VALIDATION_RUNTIME_PROBLEM, (Object)t.getMessage());
        }
        return results.getMessages();
    }

    @Override
    public List<DMNMessage> validate(File xmlFile) {
        return this.validate(xmlFile, DMNValidator.Validation.VALIDATE_MODEL);
    }

    @Override
    public List<DMNMessage> validate(File xmlFile, DMNValidator.Validation ... options) {
        return this.validate((Resource)new FileSystemResource(xmlFile), options);
    }

    @Override
    public List<DMNMessage> validate(Reader reader) {
        return this.validate(reader, DMNValidator.Validation.VALIDATE_MODEL);
    }

    @Override
    public List<DMNMessage> validate(Reader reader, DMNValidator.Validation ... options) {
        return this.validate((Resource)new ReaderResource(reader), options);
    }

    @Override
    public List<DMNMessage> validate(Resource resource) {
        return this.validate(resource, DMNValidator.Validation.VALIDATE_MODEL);
    }

    @Override
    public List<DMNMessage> validate(Resource resource, DMNValidator.Validation ... options) {
        DefaultDMNMessagesManager results = new DefaultDMNMessagesManager(resource);
        EnumSet<DMNValidator.Validation> flags = EnumSet.copyOf(Arrays.asList(options));
        try {
            String content = DMNValidatorImpl.readContent(resource.getReader());
            if (flags.contains((Object)DMNValidator.Validation.VALIDATE_SCHEMA)) {
                results.addAll(this.validateSchema(content, resource.getSourcePath()));
            }
            if (flags.contains((Object)DMNValidator.Validation.VALIDATE_MODEL) || flags.contains((Object)DMNValidator.Validation.VALIDATE_COMPILATION) || flags.contains((Object)DMNValidator.Validation.ANALYZE_DECISION_TABLE)) {
                DMNResource dmnResource = DMNValidatorImpl.unmarshallDMNResource(this.dmnCompilerConfig, resource, content);
                this.validateModelCompilation(dmnResource, (DMNMessageManager)results, flags);
            }
        }
        catch (Throwable t) {
            MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, (Throwable)t, null, (Msg.Message1)Msg.VALIDATION_RUNTIME_PROBLEM, (Object)t.getMessage());
        }
        return results.getMessages();
    }

    private static String readContent(Reader reader) throws IOException {
        char[] b = new char[32768];
        StringBuilder content = new StringBuilder();
        int chars = -1;
        while ((chars = reader.read(b)) > 0) {
            content.append(b, 0, chars);
        }
        return content.toString();
    }

    private static DMNResource unmarshallDMNResource(DMNCompilerConfiguration config, Resource originalResource, String content) {
        Definitions dmndefs = DMNMarshallerFactory.newMarshallerWithExtensions((List)config.getRegisteredExtensions()).unmarshal(content);
        dmndefs.normalize();
        return DMNValidatorImpl.wrapDefinitions(dmndefs, originalResource.getSourcePath());
    }

    private static DMNResource wrapDefinitions(Definitions dmndefs, String path) {
        return new DMNResource(dmndefs, (ResourceWithConfiguration)new ResourceWithConfigurationImpl((Resource)new DMNValidatorResource(path), null, x -> {}, y -> {}));
    }

    private void validateModelCompilation(DMNResource dmnModel, DMNMessageManager results, EnumSet<DMNValidator.Validation> flags) {
        if (flags.contains((Object)DMNValidator.Validation.VALIDATE_MODEL)) {
            results.addAll(this.validateModel(dmnModel, Collections.emptyList()));
        }
        if (flags.contains((Object)DMNValidator.Validation.VALIDATE_COMPILATION)) {
            results.addAll(this.validateCompilation(dmnModel));
        }
        if (flags.contains((Object)DMNValidator.Validation.ANALYZE_DECISION_TABLE)) {
            results.addAllUnfiltered(this.analyseDT(dmnModel, flags));
        }
    }

    private List<DMNMessage> validateSchema(String xml, String path) {
        ArrayList<DMNMessage> problems = new ArrayList<DMNMessage>();
        try {
            XStreamMarshaller.DMN_VERSION inferDMNVersion = XStreamMarshaller.inferDMNVersion((Reader)new StringReader(xml));
            Schema usingSchema = this.determineSchema(inferDMNVersion);
            StreamSource s = new StreamSource(new StringReader(xml));
            this.validateSchema(s, usingSchema);
        }
        catch (Exception e) {
            problems.add((DMNMessage)new DMNMessageImpl(DMNMessage.Severity.ERROR, MsgUtil.createMessage((Msg.Message1)Msg.FAILED_XML_VALIDATION, (Object)e.getMessage()), Msg.FAILED_XML_VALIDATION.getType(), null, (Throwable)e).withPath(path));
        }
        return problems;
    }

    private Schema determineSchema(XStreamMarshaller.DMN_VERSION dmnVersion) {
        if (this.overrideSchema != null) {
            return this.overrideSchema;
        }
        switch (dmnVersion) {
            case DMN_v1_1: {
                return schemav1_1;
            }
            case DMN_v1_2: {
                return schemav1_2;
            }
            case DMN_v1_3: {
                return schemav1_3;
            }
        }
        return schemav1_4;
    }

    private void validateSchema(Source s, Schema using) throws SAXException, IOException {
        Validator validator = using.newValidator();
        validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        validator.validate(s);
    }

    private List<DMNMessage> validateModel(DMNResource mainModel, List<DMNResource> otherModels) {
        Definitions mainDefinitions = mainModel.getDefinitions();
        StatelessKieSession kieSession = mainDefinitions instanceof KieDMNModelInstrumentedBase ? this.kb11.newStatelessKieSession() : this.kb12.newStatelessKieSession();
        MessageReporter reporter = new MessageReporter(mainModel);
        kieSession.setGlobal("reporter", (Object)reporter);
        List dmnModelElements = DMNValidatorImpl.allChildren((DMNModelInstrumentedBase)mainDefinitions).filter(d -> !(d instanceof DecisionService) || !Boolean.parseBoolean((String)d.getAdditionalAttributes().get(new QName("http://www.trisotech.com/2015/triso/modeling", "dynamicDecisionService")))).collect(Collectors.toList());
        List otherModelsDefinitions = otherModels.stream().map(DMNResource::getDefinitions).collect(Collectors.toList());
        BatchExecutionCommand batch = CommandFactory.newBatchExecution(Arrays.asList(CommandFactory.newInsertElements(dmnModelElements, (String)"DEFAULT", (boolean)false, (String)"DEFAULT"), CommandFactory.newInsertElements(otherModelsDefinitions, (String)"DMNImports", (boolean)false, (String)"DMNImports")));
        kieSession.execute((Command)batch);
        return reporter.getMessages().getMessages();
    }

    private List<DMNMessage> validateCompilation(DMNResource dmnR) {
        if (dmnR != null) {
            DMNCompilerImpl compiler = new DMNCompilerImpl(this.dmnCompilerConfig);
            DMNModel model = compiler.compile(dmnR.getDefinitions(), dmnR.getResAndConfig().getResource(), Collections.emptyList());
            if (model != null) {
                return model.getMessages();
            }
            throw new IllegalStateException("Compiled model is null!");
        }
        return Collections.emptyList();
    }

    private List<DMNMessage> analyseDT(DMNResource dmnR, Set<DMNValidator.Validation> flags) {
        if (dmnR != null) {
            DMNCompilerImpl compiler = new DMNCompilerImpl(this.dmnCompilerConfig);
            DMNModel model = compiler.compile(dmnR.getDefinitions(), dmnR.getResAndConfig().getResource(), Collections.emptyList());
            if (model != null) {
                List<DTAnalysis> vs = this.dmnDTValidator.analyse(model, flags);
                return DMNValidatorImpl.processDMNDTValidatorMessages(dmnR, vs);
            }
            throw new IllegalStateException("Compiled model is null!");
        }
        return Collections.emptyList();
    }

    private static Stream<DMNModelInstrumentedBase> allChildren(DMNModelInstrumentedBase root) {
        return Stream.concat(Stream.of(root), root.getChildren().stream().flatMap(DMNValidatorImpl::allChildren));
    }

    static {
        try {
            schemav1_1 = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20151101/dmn.xsd")));
        }
        catch (SAXException e) {
            throw new RuntimeException("Unable to initialize correctly DMNValidator.", e);
        }
        try {
            schemav1_2 = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new Source[]{new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20180521/DC.xsd")), new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20180521/DI.xsd")), new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20180521/DMNDI12.xsd")), new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20180521/DMN12.xsd"))});
        }
        catch (SAXException e) {
            throw new RuntimeException("Unable to initialize correctly DMNValidator.", e);
        }
        try {
            schemav1_3 = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new Source[]{new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20191111/DC.xsd")), new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20191111/DI.xsd")), new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20191111/DMNDI13.xsd")), new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20191111/DMN13.xsd"))});
        }
        catch (SAXException e) {
            throw new RuntimeException("Unable to initialize correctly DMNValidator.", e);
        }
        try {
            schemav1_4 = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new Source[]{new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20211108/DC.xsd")), new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20211108/DI.xsd")), new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20211108/DMNDI13.xsd")), new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20211108/DMN14.xsd"))});
        }
        catch (SAXException e) {
            throw new RuntimeException("Unable to initialize correctly DMNValidator.", e);
        }
    }

    public static class ValidatorBuilderImpl
    implements DMNValidator.ValidatorBuilder {
        private final EnumSet<DMNValidator.Validation> flags;
        private final DMNValidatorImpl validator;
        private DMNValidator.ValidatorBuilder.ValidatorImportReaderResolver importResolver;

        public ValidatorBuilderImpl(DMNValidatorImpl dmnValidatorImpl, DMNValidator.Validation[] options) {
            this.validator = dmnValidatorImpl;
            this.flags = EnumSet.copyOf(Arrays.asList(options));
        }

        @Override
        public DMNValidator.ValidatorBuilder usingImports(DMNValidator.ValidatorBuilder.ValidatorImportReaderResolver r) {
            this.importResolver = r;
            return this;
        }

        @Override
        public DMNValidator.ValidatorBuilder usingSchema(Schema r) {
            this.validator.setOverrideSchema(r);
            return this;
        }

        @Override
        public List<DMNMessage> theseModels(File ... files) {
            Resource[] array = Arrays.stream(files).map(FileSystemResource::new).collect(Collectors.toList()).toArray(new Resource[0]);
            return this.theseModels(array);
        }

        @Override
        public List<DMNMessage> theseModels(Resource ... resources) {
            DefaultDMNMessagesManager results = new DefaultDMNMessagesManager(null);
            ArrayList<DMNResource> models = new ArrayList<DMNResource>();
            for (Resource r : resources) {
                try {
                    String content = DMNValidatorImpl.readContent(r.getReader());
                    if (this.flags.contains((Object)DMNValidator.Validation.VALIDATE_SCHEMA)) {
                        results.addAll(this.validator.validateSchema(content, r.getSourcePath()));
                    }
                    if (results.hasErrors()) continue;
                    DMNResource dmnResource = DMNValidatorImpl.unmarshallDMNResource(this.validator.dmnCompilerConfig, r, content);
                    models.add(dmnResource);
                }
                catch (Exception t) {
                    MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, (Throwable)t, null, (Msg.Message1)Msg.VALIDATION_RUNTIME_PROBLEM, (Object)t.getMessage());
                }
            }
            if (this.flags.contains((Object)DMNValidator.Validation.VALIDATE_MODEL) || this.flags.contains((Object)DMNValidator.Validation.VALIDATE_COMPILATION) || this.flags.contains((Object)DMNValidator.Validation.ANALYZE_DECISION_TABLE)) {
                if (results.hasErrors()) {
                    MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, null, null, (Msg.Message0)Msg.VALIDATION_STOPPED);
                    return results.getMessages();
                }
                this.processDMNResourcesAndValidate((DMNMessageManager)results, models);
            }
            return results.getMessages();
        }

        private void processDMNResourcesAndValidate(DMNMessageManager results, List<DMNResource> models) {
            DMNAssemblerService.enrichDMNResourcesWithImportsDependencies(models, Collections.emptyList());
            List sortedModels = DMNResourceDependenciesSorter.sort(models);
            this.validateDMNResources(sortedModels, results);
        }

        @Override
        public List<DMNMessage> theseModels(Reader ... readers) {
            Resource[] array = Arrays.stream(readers).map(ReaderResource::new).collect(Collectors.toList()).toArray(new Resource[0]);
            return this.theseModels(array);
        }

        @Override
        public List<DMNMessage> theseModels(Definitions ... models) {
            DefaultDMNMessagesManager results = new DefaultDMNMessagesManager(null);
            if (this.flags.contains((Object)DMNValidator.Validation.VALIDATE_SCHEMA)) {
                MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, null, null, (Msg.Message0)Msg.FAILED_NO_XML_SOURCE);
            }
            if (this.flags.contains((Object)DMNValidator.Validation.VALIDATE_MODEL) || this.flags.contains((Object)DMNValidator.Validation.VALIDATE_COMPILATION) || this.flags.contains((Object)DMNValidator.Validation.ANALYZE_DECISION_TABLE)) {
                if (results.hasErrors()) {
                    MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, null, null, (Msg.Message0)Msg.VALIDATION_STOPPED);
                    return results.getMessages();
                }
                List<DMNResource> dmnRs = Arrays.stream(models).map(d -> DMNValidatorImpl.wrapDefinitions(d, null)).collect(Collectors.toList());
                this.processDMNResourcesAndValidate((DMNMessageManager)results, dmnRs);
            }
            return results.getMessages();
        }

        private void validateDMNResources(List<DMNResource> models, DMNMessageManager results) {
            ArrayList<DMNResource> otherModelsDMNResources = new ArrayList<DMNResource>();
            ArrayList<DMNModel> otherModelsDMNModels = new ArrayList<DMNModel>();
            for (DMNResource dmnR : models) {
                try {
                    DMNModel model;
                    if (this.flags.contains((Object)DMNValidator.Validation.VALIDATE_MODEL)) {
                        results.addAll(this.validator.validateModel(dmnR, otherModelsDMNResources));
                        otherModelsDMNResources.add(dmnR);
                    }
                    if (!this.flags.contains((Object)DMNValidator.Validation.VALIDATE_COMPILATION) && !this.flags.contains((Object)DMNValidator.Validation.ANALYZE_DECISION_TABLE)) continue;
                    DMNCompilerImpl compiler = new DMNCompilerImpl(this.validator.dmnCompilerConfig);
                    Function<String, Reader> relativeResolver = null;
                    if (this.importResolver != null) {
                        relativeResolver = locationURI -> this.importResolver.newReader(dmnR.getDefinitions().getNamespace(), dmnR.getDefinitions().getName(), (String)locationURI);
                    }
                    if ((model = compiler.compile(dmnR.getDefinitions(), otherModelsDMNModels, dmnR.getResAndConfig().getResource(), relativeResolver)) != null) {
                        results.addAll(model.getMessages());
                        otherModelsDMNModels.add(model);
                        if (!this.flags.contains((Object)DMNValidator.Validation.ANALYZE_DECISION_TABLE)) continue;
                        List<DTAnalysis> vs = this.validator.dmnDTValidator.analyse(model, this.flags);
                        List<DMNMessage> dtAnalysisResults = DMNValidatorImpl.processDMNDTValidatorMessages(dmnR, vs);
                        results.addAllUnfiltered(dtAnalysisResults);
                        continue;
                    }
                    throw new IllegalStateException("Compiled model is null!");
                }
                catch (Throwable t) {
                    MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, (Throwable)t, null, (Msg.Message1)Msg.VALIDATION_RUNTIME_PROBLEM, (Object)t.getMessage());
                }
            }
        }
    }

    private static class DMNValidatorResource
    extends BaseResource {
        public DMNValidatorResource() {
        }

        public DMNValidatorResource(String path) {
            this.setSourcePath(path);
        }

        public URL getURL() throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean hasURL() {
            throw new UnsupportedOperationException();
        }

        public boolean isDirectory() {
            throw new UnsupportedOperationException();
        }

        public Collection<Resource> listResources() {
            throw new UnsupportedOperationException();
        }

        public String getEncoding() {
            throw new UnsupportedOperationException();
        }

        public InputStream getInputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public Reader getReader() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

