/*
 * Decompiled with CFR 0.152.
 */
package org.kie.drl.engine.runtime.mapinput.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.kie.drl.engine.runtime.mapinput.model.EfestoOutputDrlMap;
import org.kie.drl.engine.runtime.mapinput.utils.DrlRuntimeHelper;
import org.kie.efesto.common.api.cache.EfestoClassKey;
import org.kie.efesto.common.api.exceptions.KieEfestoCommonException;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.common.api.model.EfestoRuntimeContext;
import org.kie.efesto.common.core.utils.JSONUtils;
import org.kie.efesto.runtimemanager.api.model.BaseEfestoInput;
import org.kie.efesto.runtimemanager.api.model.EfestoInput;
import org.kie.efesto.runtimemanager.api.model.EfestoLocalRuntimeContext;
import org.kie.efesto.runtimemanager.api.model.EfestoMapInputDTO;
import org.kie.efesto.runtimemanager.api.model.EfestoOriginalTypeGeneratedType;
import org.kie.efesto.runtimemanager.api.service.KieRuntimeService;
import org.kie.efesto.runtimemanager.core.model.EfestoRuntimeContextUtils;

public class KieRuntimeServiceDrlMapInput
implements KieRuntimeService<EfestoMapInputDTO, Map<String, Object>, BaseEfestoInput<EfestoMapInputDTO>, EfestoOutputDrlMap, EfestoRuntimeContext> {
    private static final ObjectMapper objectMapper = JSONUtils.getObjectMapper();

    public EfestoClassKey getEfestoClassKeyIdentifier() {
        return new EfestoClassKey(BaseEfestoInput.class, new Type[]{EfestoMapInputDTO.class});
    }

    public boolean canManageInput(EfestoInput toEvaluate, EfestoRuntimeContext context) {
        return DrlRuntimeHelper.canManage(toEvaluate, context);
    }

    public Optional<EfestoOutputDrlMap> evaluateInput(BaseEfestoInput<EfestoMapInputDTO> toEvaluate, EfestoRuntimeContext context) {
        if (!(context instanceof EfestoLocalRuntimeContext)) {
            context = EfestoRuntimeContextUtils.buildWithParentClassLoader((ClassLoader)context.getClass().getClassLoader(), (Map)context.getGeneratedResourcesMap());
        }
        return DrlRuntimeHelper.execute(toEvaluate, (EfestoLocalRuntimeContext)context);
    }

    public String getModelType() {
        return "drl";
    }

    public Optional<BaseEfestoInput<EfestoMapInputDTO>> parseJsonInput(String modelLocalUriIdString, String inputDataString) {
        ModelLocalUriId modelLocalUriId;
        try {
            modelLocalUriId = (ModelLocalUriId)objectMapper.readValue(modelLocalUriIdString, ModelLocalUriId.class);
            if (!modelLocalUriId.model().equals(this.getModelType())) {
                return Optional.empty();
            }
        }
        catch (Exception e) {
            throw new KieEfestoCommonException(String.format("Failed to parse %s as ModelLocalUriId", modelLocalUriIdString));
        }
        try {
            Map inputData = JSONUtils.getInputData((String)inputDataString);
            return Optional.of(new BaseEfestoInput(modelLocalUriId, (Object)KieRuntimeServiceDrlMapInput.getDrlMapInput(inputData)));
        }
        catch (Exception e) {
            throw new KieEfestoCommonException(String.format("Failed to parse %s as Map<String, Object>", inputDataString));
        }
    }

    private static EfestoMapInputDTO getDrlMapInput(Map<String, Object> inputData) {
        List inserts = new ArrayList();
        if (inputData.containsKey("inserts")) {
            inserts = (List)inputData.get("inserts");
            inputData.remove("inserts");
        }
        Map globals = new HashMap();
        if (inputData.containsKey("globals")) {
            globals = (Map)inputData.get("globals");
            inputData.remove("globals");
        }
        String packageName = (String)inputData.get("package");
        inputData.remove("package");
        String modelName = (String)inputData.get("modelName");
        inputData.remove("modelName");
        HashMap fieldTypeMap = new HashMap();
        inputData.forEach((s, o) -> {
            String objectType = o.getClass().getCanonicalName();
            EfestoOriginalTypeGeneratedType toPut = new EfestoOriginalTypeGeneratedType(objectType, objectType);
            fieldTypeMap.put(s, toPut);
        });
        return new EfestoMapInputDTO(inserts, globals, inputData, fieldTypeMap, modelName, packageName);
    }
}

