/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fuse.eap.config;

import de.pdark.decentxml.Attribute;
import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.XMLParser;
import de.pdark.decentxml.XMLStringSource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import org.jboss.fuse.eap.config.ConfigEditor;
import org.jboss.fuse.eap.config.ConfigMain;
import org.jboss.fuse.eap.config.LayerConfig;

public class ConfigSupport {
    public static final List<String> standalonePaths = new ArrayList<String>();
    public static final List<String> domainPaths = new ArrayList<String>();

    public static String getJBossHome() throws UnsupportedEncodingException {
        String jbossHome = System.getProperty("jboss.home");
        if (jbossHome == null) {
            String path = ConfigMain.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            String decodedPath = URLDecoder.decode(path, "UTF-8");
            String containingFolder = decodedPath.substring(0, decodedPath.lastIndexOf(File.separator));
            if (containingFolder.endsWith("bin")) {
                jbossHome = containingFolder.substring(0, containingFolder.lastIndexOf(File.separator));
            } else {
                throw new CommandException("The execution is not correct. This jar should be placed inside of ${JBOSS_HOME}/bin");
            }
        }
        String standalonePath = jbossHome + "/standalone/configuration";
        String domainPath = jbossHome + "/domain/configuration";
        File stanaloneFile = new File(standalonePath);
        File domainFile = new File(domainPath);
        if (!stanaloneFile.exists() || !domainFile.exists()) {
            throw new CommandException("\t The execution is not correct. This jar should be placed inside of ${JBOSS_HOME}/bin");
        }
        return jbossHome;
    }

    public static void applyConfigChange(String jbossHome, boolean enable, ConfigEditor editor) throws Exception {
        String newXML;
        Document doc;
        String xml;
        String path;
        String layersValue;
        File layersConf = new File(new File(jbossHome), "modules/layers.conf");
        Properties layersProperties = new Properties();
        ArrayList<String> layers = new ArrayList<String>();
        if (layersConf.exists()) {
            try (FileInputStream is = new FileInputStream(layersConf);){
                layersProperties.load(is);
            }
            layersValue = layersProperties.getProperty("layers");
            if (layersValue == null) {
                layersValue = "";
            }
            for (String s : layersValue.split(",")) {
                if ((s = s.trim()).length() <= 0) continue;
                layers.add(s);
            }
        }
        ConfigSupport.applyLayerConfigChange(enable, editor, layers);
        layersValue = "";
        for (String layer : layers) {
            if (layersValue.length() != 0) {
                layersValue = layersValue + ",";
            }
            layersValue = layersValue + layer;
        }
        layersProperties.put("layers", layersValue);
        try (FileOutputStream out = new FileOutputStream(layersConf);){
            layersProperties.store(out, null);
        }
        XMLParser parser = new XMLParser();
        for (String p : standalonePaths) {
            path = jbossHome + p;
            System.out.println("\tEnabling configuration on " + path);
            xml = ConfigSupport.readFile(path, "UTF-8");
            doc = parser.parse(new XMLStringSource(xml));
            editor.applyStandaloneConfigChange(enable, doc);
            newXML = doc.toXML();
            if (newXML.equals(xml)) continue;
            ConfigSupport.backup(path, xml);
            ConfigSupport.writeFile(path, newXML, "UTF-8");
        }
        for (String p : domainPaths) {
            path = jbossHome + p;
            System.out.println("\tEnabling configuration on " + path);
            xml = ConfigSupport.readFile(path, "UTF-8");
            doc = parser.parse(new XMLStringSource(xml));
            editor.applyDomainConfigChange(enable, doc);
            newXML = doc.toXML();
            if (newXML.equals(xml)) continue;
            ConfigSupport.backup(path, xml);
            ConfigSupport.writeFile(path, newXML, "UTF-8");
        }
    }

    public static void applyLayerConfigChange(boolean enable, ConfigEditor editor, ArrayList<String> layers) {
        LayerData ld;
        ArrayList<LayerConfig> configs = new ArrayList<LayerConfig>(editor.getLayerConfigs());
        ArrayList<LayerData> workingList = new ArrayList<LayerData>();
        int secondaryCounter = 0;
        for (int i = 0; i < layers.size(); ++i) {
            String name = layers.get(i);
            ld = new LayerData();
            ld.name = name;
            ld.primaryPriority = 0;
            ld.secondaryPriority = i;
            boolean add = true;
            for (LayerConfig config : configs) {
                if (!config.pattern.matcher(name).matches()) continue;
                if (enable) {
                    ld.config = config;
                    if (config.type == LayerConfig.Type.INSTALLING) {
                        ld.name = config.name;
                    }
                    ld.primaryPriority = config.priority;
                    ld.secondaryPriority = secondaryCounter++;
                    break;
                }
                if (config.type != LayerConfig.Type.INSTALLING) break;
                add = false;
                break;
            }
            if (!add) continue;
            workingList.add(ld);
        }
        for (LayerData layerData : workingList) {
            if (layerData.config == null) continue;
            configs.remove(layerData.config);
        }
        for (LayerConfig config : configs) {
            switch (config.type) {
                case OPTIONAL: {
                    break;
                }
                case REQUIRED: {
                    if (!enable) break;
                    throw new CommandException("Required layer has not yet been configured: " + config.name);
                }
                case INSTALLING: {
                    if (!enable) break;
                    ld = new LayerData();
                    ld.name = config.name;
                    ld.config = config;
                    ld.primaryPriority = config.priority;
                    ld.secondaryPriority = secondaryCounter++;
                    workingList.add(ld);
                }
            }
        }
        Collections.sort(workingList);
        layers.clear();
        for (LayerData layerData : workingList) {
            layers.add(layerData.name);
        }
    }

    public static Element createElementFromText(String xml) {
        XMLParser parser = new XMLParser();
        Document doc = parser.parse(new XMLStringSource(xml));
        return doc.getRootElement();
    }

    public static Element loadElementFrom(URL resource) {
        try {
            byte[] data = ConfigSupport.loadBytesFromURL(resource);
            String xml = new String(data, "UTF-8");
            return ConfigSupport.createElementFromText(xml);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] loadBytesFromURL(URL resource) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[10234];
        try (InputStream in = resource.openStream();){
            int count;
            while ((count = in.read(buffer, 0, buffer.length)) >= 0) {
                out.write(buffer, 0, count);
            }
        }
        return out.toByteArray();
    }

    public static Element findElementWithAttributeValue(Collection<Element> elements, String attrName, String attrValue) {
        if (elements == null) {
            return null;
        }
        for (Element element : elements) {
            Attribute attribute = element.getAttribute(attrName);
            if (attribute == null || !attrValue.equals(attribute.getValue())) continue;
            return element;
        }
        return null;
    }

    public static Element findElementWithStartingAttributeValue(Collection<Element> elements, String attrName, String attrValue) {
        if (elements == null) {
            return null;
        }
        for (Element element : elements) {
            Attribute attribute = element.getAttribute(attrName);
            if (attribute == null || !attribute.getValue().startsWith(attrValue)) continue;
            return element;
        }
        return null;
    }

    public static void assertExists(Element extensions, String message) {
        if (extensions == null) {
            throw new BadDocument(message);
        }
    }

    public static void backup(String path, String xml) throws IOException {
        String name = path + ".bak";
        int counter = 2;
        while (Files.exists(Paths.get(name, new String[0]), new LinkOption[0])) {
            name = path + ".bak" + counter;
            ++counter;
        }
        ConfigSupport.writeFile(name, xml, "UTF-8");
    }

    public static String readFile(String path, String encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }

    public static Path writeFile(String path, String value, String encoding) throws IOException {
        byte[] bytes = value.getBytes(encoding);
        return Files.write(Paths.get(path, new String[0]), bytes, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
    }

    public static LinkedHashMap<String, Element> mapByAttributeName(List<Element> elements, String attrName) {
        LinkedHashMap<String, Element> rc = new LinkedHashMap<String, Element>();
        for (Element element : elements) {
            Attribute attribute = element.getAttribute(attrName);
            if (attribute == null) continue;
            rc.put(attribute.getValue(), element);
        }
        return rc;
    }

    public static List<Element> findProfileElements(Document doc) {
        Element profile = doc.getRootElement().getChild("profile");
        if (profile != null) {
            return Collections.singletonList(profile);
        }
        Element profiles = doc.getRootElement().getChild("profiles");
        if (profiles != null) {
            return profiles.getChildren("profile");
        }
        ConfigSupport.assertExists(null, "Did not find the <profile> element");
        return null;
    }

    static {
        standalonePaths.add("/standalone/configuration/standalone.xml");
        standalonePaths.add("/standalone/configuration/standalone-full.xml");
        standalonePaths.add("/standalone/configuration/standalone-full-ha.xml");
        standalonePaths.add("/standalone/configuration/standalone-ha.xml");
        domainPaths.add("/domain/configuration/domain.xml");
    }

    static class LayerData
    implements Comparable<LayerData> {
        String name;
        int primaryPriority;
        int secondaryPriority;
        LayerConfig config;

        LayerData() {
        }

        @Override
        public int compareTo(LayerData o) {
            if (o.primaryPriority != this.primaryPriority) {
                return this.primaryPriority - o.primaryPriority;
            }
            return this.secondaryPriority - o.secondaryPriority;
        }
    }

    public static class CommandException
    extends RuntimeException {
        public CommandException(String message) {
            super(message);
        }
    }

    public static class BadDocument
    extends RuntimeException {
        public BadDocument(String message) {
            super(message);
        }
    }
}

