/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.conf;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.kie.api.PropertiesConfiguration;
import org.kie.api.conf.ConfigurationKey;
import org.kie.api.conf.MultiValueOption;
import org.kie.api.conf.Option;
import org.kie.api.conf.OptionKey;
import org.kie.api.conf.OptionsConfiguration;
import org.kie.api.conf.SingleValueOption;
import org.kie.internal.conf.ConfigurationFactory;
import org.kie.internal.conf.InternalPropertiesConfiguration;
import org.kie.internal.utils.ChainedProperties;

public class CompositeConfiguration<T extends Option, S extends SingleValueOption, M extends MultiValueOption>
implements OptionsConfiguration<T, S, M>,
Externalizable {
    private ClassLoader classLoader;
    private ChainedProperties chainedProperties;
    private Map<String, OptionsConfiguration<T, S, M>> configurations = new HashMap<String, OptionsConfiguration<T, S, M>>();

    public CompositeConfiguration(ChainedProperties chainedProperties, ClassLoader classloader, ConfigurationFactory<T, S, M> ... factories) {
        this.setClassLoader(classloader);
        this.chainedProperties = chainedProperties;
        for (ConfigurationFactory<T, S, M> f : factories) {
            this.configurations.put(f.type(), f.create(this, classloader, chainedProperties));
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.chainedProperties.filterDroolsPropertiesForSerialization();
        out.writeObject(this.chainedProperties);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.chainedProperties = (ChainedProperties)in.readObject();
    }

    public void makeImmutable() {
        this.configurations.values().stream().forEach(conf -> conf.makeImmutable());
    }

    public <C extends T> void setOption(C option) {
        OptionsConfiguration<T, S, M> delegate = this.configurations.get(option.type());
        if (delegate == null) {
            throw new RuntimeException("Configuration for type " + option.type() + " does not exist");
        }
        delegate.setOption(option);
    }

    public <C extends S> C getOption(OptionKey<C> optionKey) {
        OptionsConfiguration<T, S, M> delegate = this.configurations.get(optionKey.type());
        if (delegate == null) {
            throw new RuntimeException("Configuration for type " + optionKey.type() + " does not exist");
        }
        return (C)delegate.getOption(optionKey);
    }

    public <C extends M> C getOption(OptionKey<C> optionKey, String subKey) {
        OptionsConfiguration<T, S, M> delegate = this.configurations.get(optionKey.type());
        if (delegate == null) {
            throw new RuntimeException("Configuration for type " + optionKey.type() + " does not exist");
        }
        return (C)delegate.getOption(optionKey, subKey);
    }

    public <C extends M> Set<String> getOptionSubKeys(OptionKey<C> optionKey) {
        OptionsConfiguration<T, S, M> delegate = this.configurations.get(optionKey.type());
        if (delegate == null) {
            throw new RuntimeException("Configuration for type " + optionKey.type() + " does not exist");
        }
        return delegate.getOptionSubKeys(optionKey);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ChainedProperties getProperties() {
        return this.chainedProperties;
    }

    public <X extends OptionsConfiguration<T, S, M>> X as(ConfigurationKey<X> configuration) {
        return (X)this.configurations.get(configuration.type());
    }

    public boolean setProperty(String name, String value) {
        return this.setProperty(null, name, value);
    }

    public String getProperty(String name) {
        return this.getProperty(null, name);
    }

    public boolean setProperty(PropertiesConfiguration exclude, String name, String value) {
        for (PropertiesConfiguration propertiesConfiguration : this.configurations.values()) {
            if (propertiesConfiguration == exclude || !((InternalPropertiesConfiguration)propertiesConfiguration).setInternalProperty(name, value)) continue;
            return true;
        }
        Properties additionalProperty = new Properties();
        additionalProperty.setProperty(name, value);
        this.chainedProperties.addProperties(additionalProperty);
        return false;
    }

    public String getProperty(PropertiesConfiguration exclude, String name) {
        for (PropertiesConfiguration propertiesConfiguration : this.configurations.values()) {
            String value;
            if (propertiesConfiguration == exclude || (value = ((InternalPropertiesConfiguration)propertiesConfiguration).getInternalProperty(name)) == null) continue;
            return value;
        }
        return null;
    }
}

