/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.drools.core.util.DroolsStreamUtils;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.runtime.KieContainer;

@Mojo(name="serialize", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresProject=true, defaultPhase=LifecyclePhase.COMPILE, configurator="include-project-dependencies")
public class SerializeMojo
extends AbstractMojo {
    @Parameter(property="kie.kiebases", required=true)
    private List<String> kiebases;
    @Parameter(property="kie.resDirectory", defaultValue="${project.basedir}/src/main/res/raw")
    private String resDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            File outputFolder = new File(this.resDirectory);
            outputFolder.mkdirs();
            KieServices ks = KieServices.Factory.get();
            KieContainer kc = ks.newKieClasspathContainer();
            Results messages = kc.verify();
            List warnings = messages.getMessages(new Message.Level[]{Message.Level.WARNING});
            for (Message warning : warnings) {
                this.getLog().warn((CharSequence)warnings.toString());
            }
            List errors = messages.getMessages(new Message.Level[]{Message.Level.ERROR});
            if (!errors.isEmpty()) {
                for (Message error : errors) {
                    this.getLog().error((CharSequence)error.toString());
                }
                throw new MojoFailureException("Build failed!");
            }
            for (String kbase : this.kiebases) {
                KieBase kb = kc.getKieBase(kbase);
                this.getLog().info((CharSequence)("Writing KBase: " + kbase));
                File file = new File(outputFolder, kbase.replace('.', '_').toLowerCase());
                FileOutputStream out = new FileOutputStream(file);
                DroolsStreamUtils.streamOut((OutputStream)out, (Object)kb.getKiePackages());
                out.close();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("error", e);
        }
    }
}

