/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.appformer.maven.support.PomModel;
import org.drools.compiler.compiler.io.Folder;
import org.drools.compiler.compiler.io.memory.MemoryFile;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.compiler.kie.builder.impl.MemoryKieModule;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.modelcompiler.CanonicalKieModule;
import org.drools.modelcompiler.builder.CanonicalModelKieProject;
import org.drools.modelcompiler.builder.ModelBuilderImpl;
import org.drools.modelcompiler.builder.ModelWriter;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.ReleaseId;
import org.kie.maven.plugin.AbstractKieMojo;
import org.kie.maven.plugin.ExecModelMode;
import org.kie.maven.plugin.ProjectPomModel;

@Mojo(name="generateModel", requiresDependencyResolution=ResolutionScope.NONE, requiresProject=true, defaultPhase=LifecyclePhase.COMPILE)
public class GenerateModelMojo
extends AbstractKieMojo {
    public static PathMatcher drlFileMatcher = FileSystems.getDefault().getPathMatcher("glob:**.drl");
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession mavenSession;
    @Parameter(required=true, defaultValue="${project.build.directory}")
    private File targetDirectory;
    @Parameter(required=true, defaultValue="${project.basedir}")
    private File projectDir;
    @Parameter(required=true, defaultValue="${project.build.testSourceDirectory}")
    private File testDir;
    @Parameter
    private Map<String, String> properties;
    @Parameter(required=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(property="generateModel", defaultValue="YES_WITHDRL")
    private String generateModel;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean modelParameterEnabled = ExecModelMode.modelParameterEnabled(this.generateModel);
        boolean modelCompilerInClassPath = ExecModelMode.isModelCompilerInClassPath(this.project.getDependencies());
        if (modelParameterEnabled && modelCompilerInClassPath) {
            this.generateModel();
        } else if (modelParameterEnabled) {
            this.getLog().warn((CharSequence)"You're trying to build rule assets in a project from an executable rule model, but you did not provide the required dependency on the project classpath.\nTo enable executable rule models for your project, add the `drools-model-compiler` dependency in the `pom.xml` file of your project.\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateModel() throws MojoExecutionException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            HashSet<URL> urls = new HashSet<URL>();
            for (String element : this.project.getCompileClasspathElements()) {
                urls.add(new File(element).toURI().toURL());
            }
            this.project.setArtifactFilter((ArtifactFilter)new CumulativeScopeArtifactFilter(Arrays.asList("compile", "runtime")));
            for (Artifact artifact : this.project.getArtifacts()) {
                File file = artifact.getFile();
                if (file == null) continue;
                urls.add(file.toURI().toURL());
            }
            urls.add(this.outputDirectory.toURI().toURL());
            URLClassLoader projectClassLoader = URLClassLoader.newInstance(urls.toArray(new URL[0]), ((Object)((Object)this)).getClass().getClassLoader());
            Thread.currentThread().setContextClassLoader(projectClassLoader);
        }
        catch (MalformedURLException | DependencyResolutionRequiredException e) {
            throw new RuntimeException(e);
        }
        try {
            this.setSystemProperties(this.properties);
            KieServices ks = KieServices.Factory.get();
            KieBuilderImpl kieBuilder = (KieBuilderImpl)ks.newKieBuilder(this.projectDir);
            kieBuilder.setPomModel((PomModel)new ProjectPomModel(this.mavenSession));
            kieBuilder.buildAll(ExecutableModelMavenProject.SUPPLIER, s -> !s.contains("src/test/java") && !s.contains("src\\test\\java"));
            InternalKieModule kieModule = (InternalKieModule)kieBuilder.getKieModule();
            List generatedFiles = kieModule.getFileNames().stream().filter(f -> f.endsWith("java")).collect(Collectors.toList());
            Set<String> drlFiles = kieModule.getFileNames().stream().filter(f -> f.endsWith("drl")).collect(Collectors.toSet());
            this.getLog().info((CharSequence)String.format("Found %d generated files in Canonical Model", generatedFiles.size()));
            MemoryFileSystem mfs = kieModule instanceof CanonicalKieModule ? ((MemoryKieModule)((CanonicalKieModule)kieModule).getInternalKieModule()).getMemoryFileSystem() : ((MemoryKieModule)kieModule).getMemoryFileSystem();
            String droolsModelCompilerPath = "/generated-sources/drools-model-compiler/main/java";
            String newCompileSourceRoot = this.targetDirectory.getPath() + "/generated-sources/drools-model-compiler/main/java";
            this.project.addCompileSourceRoot(newCompileSourceRoot);
            for (String generatedFile : generatedFiles) {
                MemoryFile f2 = (MemoryFile)mfs.getFile(generatedFile);
                Path newFile = Paths.get(this.targetDirectory.getPath(), "/generated-sources/drools-model-compiler/main/java", f2.getPath().toPortableString());
                try {
                    Files.deleteIfExists(newFile);
                    Files.createDirectories(newFile.getParent(), new FileAttribute[0]);
                    Files.copy(f2.getContents(), newFile, StandardCopyOption.REPLACE_EXISTING);
                    this.getLog().info((CharSequence)("Generating " + newFile));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new MojoExecutionException("Unable to write file", (Exception)e);
                }
            }
            String path = CanonicalKieModule.getModelFileWithGAV((ReleaseId)kieModule.getReleaseId());
            MemoryFile packagesMemoryFile = (MemoryFile)mfs.getFile(path);
            String packagesMemoryFilePath = packagesMemoryFile.getFolder().getPath().toPortableString();
            Path packagesDestinationPath = Paths.get(this.targetDirectory.getPath(), "classes", packagesMemoryFilePath, packagesMemoryFile.getName());
            try {
                if (!Files.exists(packagesDestinationPath, new LinkOption[0])) {
                    Files.createDirectories(packagesDestinationPath.getParent(), new FileAttribute[0]);
                }
                Files.copy(packagesMemoryFile.getContents(), packagesDestinationPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new MojoExecutionException("Unable to write file", (Exception)e);
            }
            if (ExecModelMode.shouldDeleteFile(this.generateModel)) {
                this.deleteDrlFiles(drlFiles);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        this.getLog().info((CharSequence)"DSL successfully generated");
    }

    private void deleteDrlFiles(Set<String> actualDrlFiles) throws MojoExecutionException {
        try (Stream<Path> drlFilesToDeleted = Files.find(this.outputDirectory.toPath(), Integer.MAX_VALUE, (p, f) -> drlFileMatcher.matches((Path)p), new FileVisitOption[0]);){
            HashSet deletedFiles = new HashSet();
            drlFilesToDeleted.forEach(p -> {
                try {
                    Files.delete(p);
                    deletedFiles.add(p.toString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Unable to delete file " + p);
                }
            });
            actualDrlFiles.retainAll(deletedFiles);
            if (!actualDrlFiles.isEmpty()) {
                String actualDrlFiles1 = String.join((CharSequence)",", actualDrlFiles);
                this.getLog().warn((CharSequence)("Base directory: " + this.projectDir));
                this.getLog().warn((CharSequence)("Files not deleted: " + actualDrlFiles1));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoExecutionException("Unable to find .drl files");
        }
    }

    public static class ExecutableModelMavenProject
    implements KieBuilder.ProjectType {
        public static final BiFunction<InternalKieModule, ClassLoader, KieModuleKieProject> SUPPLIER = ExecutableModelMavenPluginKieProject::new;

        public static class ExecutableModelMavenPluginKieProject
        extends CanonicalModelKieProject {
            public ExecutableModelMavenPluginKieProject(InternalKieModule kieModule, ClassLoader classLoader) {
                super(true, kieModule, classLoader);
            }

            public void writeProjectOutput(MemoryFileSystem trgMfs, ResultsImpl messages) {
                MemoryFileSystem srcMfs = new MemoryFileSystem();
                ArrayList modelFiles = new ArrayList();
                ModelWriter modelWriter = new ModelWriter();
                for (ModelBuilderImpl modelBuilder : this.modelBuilders) {
                    ModelWriter.Result result = modelWriter.writeModel(srcMfs, modelBuilder.getPackageSources());
                    modelFiles.addAll(result.getModelFiles());
                    Folder sourceFolder = srcMfs.getFolder("src/main/java");
                    Folder targetFolder = trgMfs.getFolder(".");
                    srcMfs.copyFolder(sourceFolder, trgMfs, targetFolder, new String[0]);
                }
                modelWriter.writeModelFile(modelFiles, trgMfs, this.getInternalKieModule().getReleaseId());
            }
        }
    }
}

