/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.appformer.maven.support.PomModel;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.DroolsError;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.io.impl.DescrResource;
import org.drools.core.io.impl.FileSystemResource;
import org.drools.modelcompiler.builder.GeneratedFile;
import org.drools.modelcompiler.builder.ModelBuilderImpl;
import org.drools.modelcompiler.builder.PackageSources;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.definition.KieDescr;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.pmml.PMMLConstants;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.maven.plugin.AbstractKieMojo;
import org.kie.maven.plugin.ExecModelMode;
import org.kie.maven.plugin.PMMLResource;
import org.kie.maven.plugin.ProjectPomModel;
import org.kie.pmml.commons.model.HasNestedModels;
import org.kie.pmml.commons.model.HasSourcesMap;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.evaluator.assembler.service.PMMLCompilerService;
import org.kie.pmml.models.drools.commons.model.KiePMMLDroolsModelWithSources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="generatePMMLModel", requiresDependencyResolution=ResolutionScope.NONE, requiresProject=true, defaultPhase=LifecyclePhase.COMPILE)
public class GeneratePMMLModelMojo
extends AbstractKieMojo {
    private static final Logger logger = LoggerFactory.getLogger(GeneratePMMLModelMojo.class);
    private static final String PMML = "pmml";
    private static final String generatedSourcesPath = "/generated-sources/";
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession mavenSession;
    @Parameter(required=true, defaultValue="${project.build.directory}")
    private File targetDirectory;
    @Parameter(required=true, defaultValue="${project.basedir}")
    private File projectDir;
    @Parameter(required=true, defaultValue="${project.build.testSourceDirectory}")
    private File testDir;
    @Parameter
    private Map<String, String> properties;
    @Parameter(required=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project.resources}", required=true, readonly=true)
    private List<org.apache.maven.model.Resource> resourcesDirectories;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!GeneratePMMLModelMojo.isNewInvoked()) {
            this.getLog().warn((CharSequence)("Skipping `generatePMMLModel` because " + PMMLConstants.KIE_PMML_IMPLEMENTATION.getName() + " is not " + PMMLConstants.NEW.getName()));
            return;
        }
        boolean modelCompilerInClassPath = ExecModelMode.isModelCompilerInClassPath(this.project.getDependencies());
        if (!modelCompilerInClassPath) {
            this.getLog().warn((CharSequence)"Skipping `generatePMMLModel` because you did not provide the required dependency on the project classpath.\nTo enable it for your project, add the `drools-model-compiler` dependency in the `pom.xml` file of your project.\n");
        } else {
            this.generateModel();
        }
    }

    static boolean isNewInvoked() {
        String property = System.getProperty(PMMLConstants.KIE_PMML_IMPLEMENTATION.getName(), PMMLConstants.LEGACY.getName());
        return property.equals(PMMLConstants.NEW.getName());
    }

    private void generateModel() throws MojoExecutionException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader projectClassLoader = null;
        try {
            HashSet<URL> urls = new HashSet<URL>();
            for (String element : this.project.getCompileClasspathElements()) {
                urls.add(new File(element).toURI().toURL());
            }
            this.project.setArtifactFilter((ArtifactFilter)new CumulativeScopeArtifactFilter(Arrays.asList("compile", "runtime")));
            for (Artifact artifact : this.project.getArtifacts()) {
                File file = artifact.getFile();
                if (file == null) continue;
                urls.add(file.toURI().toURL());
            }
            urls.add(this.outputDirectory.toURI().toURL());
            projectClassLoader = URLClassLoader.newInstance(urls.toArray(new URL[0]), ((Object)((Object)this)).getClass().getClassLoader());
            Thread.currentThread().setContextClassLoader(projectClassLoader);
            this.generateFiles();
        }
        catch (MalformedURLException | DependencyResolutionRequiredException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            if (projectClassLoader != null) {
                try {
                    projectClassLoader.close();
                }
                catch (IOException e) {
                    this.getLog().warn((Throwable)e);
                }
            }
        }
        this.getLog().info((CharSequence)"PMML model successfully generated");
    }

    private void generateFiles() throws MojoExecutionException {
        List<GeneratedFile> generatedFiles = this.getGeneratedFiles();
        KieServices ks = KieServices.Factory.get();
        KieBuilderImpl kieBuilder = (KieBuilderImpl)ks.newKieBuilder(this.projectDir);
        kieBuilder.setPomModel((PomModel)new ProjectPomModel(this.mavenSession));
        String newCompileSourceRoot = this.targetDirectory.getPath() + generatedSourcesPath;
        this.project.addCompileSourceRoot(newCompileSourceRoot);
        for (GeneratedFile generatedFile : generatedFiles) {
            this.writeFile(generatedFile);
        }
    }

    void writeFile(GeneratedFile generatedFile) throws MojoExecutionException {
        Path newFile = Paths.get(this.targetDirectory.getPath(), generatedSourcesPath, generatedFile.getPath());
        try {
            Files.deleteIfExists(newFile);
            Files.createDirectories(newFile.getParent(), new FileAttribute[0]);
            Files.copy(new ByteArrayInputStream(generatedFile.getData()), newFile, StandardCopyOption.REPLACE_EXISTING);
            this.getLog().info((CharSequence)("Generating " + newFile));
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Unable to write file", (Exception)e);
        }
    }

    private List<GeneratedFile> getGeneratedFiles() throws MojoExecutionException {
        ArrayList<GeneratedFile> toReturn = new ArrayList<GeneratedFile>();
        for (org.apache.maven.model.Resource resourceDirectory : this.resourcesDirectories) {
            File directoryFile = new File(resourceDirectory.getDirectory());
            this.getLog().info((CharSequence)("Looking for PMML models in " + directoryFile.getPath()));
            String errorMessageTemplate = null;
            if (!directoryFile.exists()) {
                errorMessageTemplate = "Resource path %s does not exists";
            } else if (!directoryFile.canRead()) {
                errorMessageTemplate = "Resource path %s is not readable";
            } else if (!directoryFile.isDirectory()) {
                errorMessageTemplate = "Resource path %s is not a directory";
            }
            if (errorMessageTemplate != null) {
                throw new MojoExecutionException(String.format(errorMessageTemplate, resourceDirectory));
            }
            toReturn.addAll(this.getGeneratedFiles(directoryFile));
        }
        if (toReturn.isEmpty()) {
            this.getLog().info((CharSequence)"No PMML Models found.");
        } else {
            this.getLog().info((CharSequence)String.format("Found %s PMML models", toReturn.size()));
        }
        return toReturn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<GeneratedFile> getGeneratedFiles(File resourceDirectory) throws MojoExecutionException {
        ArrayList toReturn = new ArrayList();
        try (Stream<Path> stream = Files.walk(resourceDirectory.toPath(), Integer.MAX_VALUE, new FileVisitOption[0]).filter(path -> path.toString().endsWith(PMML));){
            List list = stream.map(Path::toFile).map(FileSystemResource::new).map(this::parseResource).map(this::getGenerateFiles).reduce(toReturn, (previous, toAdd) -> {
                previous.addAll(toAdd);
                return previous;
            });
            return list;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private List<GeneratedFile> getGenerateFiles(PMMLResource pmmlResources) {
        ArrayList<GeneratedFile> toReturn = new ArrayList<GeneratedFile>();
        ModelBuilderImpl modelBuilder = new ModelBuilderImpl(PackageSources::dumpSources, new KnowledgeBuilderConfigurationImpl(new ClassLoader[]{((Object)((Object)this)).getClass().getClassLoader()}), (ReleaseId)new ReleaseIdImpl("dummy:dummy:0.0.0"), true, false);
        CompositeKnowledgeBuilder batch = modelBuilder.batch();
        List<KiePMMLModel> kiepmmlModels = pmmlResources.getKiePmmlModels();
        this.addModels(kiepmmlModels, pmmlResources, batch, toReturn);
        toReturn.addAll(this.generateRules((ModelBuilderImpl<PackageSources>)modelBuilder, batch));
        return toReturn;
    }

    private void addModels(List<KiePMMLModel> kiepmmlModels, PMMLResource resource, CompositeKnowledgeBuilder batch, List<GeneratedFile> generatedFiles) {
        for (KiePMMLModel model : kiepmmlModels) {
            String errorMessage;
            if (model.getName() == null || model.getName().isEmpty()) {
                errorMessage = String.format("Model name should not be empty inside %s", resource.getModelPath());
                throw new RuntimeException(errorMessage);
            }
            if (!(model instanceof HasSourcesMap)) {
                errorMessage = String.format("Expecting HasSourcesMap instance, retrieved %s inside %s", model.getClass().getName(), resource.getModelPath());
                throw new RuntimeException(errorMessage);
            }
            Map sourceMap = ((HasSourcesMap)model).getSourcesMap();
            for (Map.Entry sourceMapEntry : sourceMap.entrySet()) {
                String path = ((String)sourceMapEntry.getKey()).replace('.', File.separatorChar) + ".java";
                generatedFiles.add(new GeneratedFile(GeneratedFile.Type.PMML, path, (String)sourceMapEntry.getValue()));
            }
            if (model instanceof KiePMMLDroolsModelWithSources) {
                PackageDescr packageDescr = ((KiePMMLDroolsModelWithSources)model).getPackageDescr();
                batch.add((Resource)new DescrResource((KieDescr)packageDescr), ResourceType.DESCR);
            }
            if (!(model instanceof HasNestedModels)) continue;
            this.addModels(((HasNestedModels)model).getNestedModels(), resource, batch, generatedFiles);
        }
    }

    private List<GeneratedFile> generateRules(ModelBuilderImpl<PackageSources> modelBuilder, CompositeKnowledgeBuilder batch) {
        try {
            batch.build();
            if (modelBuilder.hasErrors()) {
                StringBuilder builder = new StringBuilder();
                for (DroolsError error : modelBuilder.getErrors().getErrors()) {
                    logger.error(error.toString());
                    builder.append(error.toString()).append(" ");
                }
                throw new MojoExecutionException(builder.toString());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            StringBuilder builder = new StringBuilder(e.getMessage()).append(" ");
            for (DroolsError error : modelBuilder.getErrors().getErrors()) {
                logger.error(error.toString());
                builder.append(error.toString()).append(" ");
            }
            throw new RuntimeException(builder.toString(), e);
        }
        return this.generateModels(modelBuilder).stream().map(f -> new GeneratedFile(GeneratedFile.Type.RULE, f.getPath(), new String(f.getData()))).collect(Collectors.toList());
    }

    List<GeneratedFile> generateModels(ModelBuilderImpl<PackageSources> modelBuilder) {
        ArrayList<GeneratedFile> toReturn = new ArrayList<GeneratedFile>();
        for (PackageSources pkgSources : modelBuilder.getPackageSources()) {
            pkgSources.collectGeneratedFiles(toReturn);
        }
        return toReturn;
    }

    private PMMLResource parseResource(Resource resource) {
        KnowledgeBaseImpl knowledgeBase = new KnowledgeBaseImpl("PMML", null);
        KnowledgeBuilderImpl kbuilderImpl = new KnowledgeBuilderImpl((InternalKnowledgeBase)knowledgeBase);
        List kiePMMLModels = PMMLCompilerService.getKiePMMLModelsFromResourceFromPlugin((KnowledgeBuilderImpl)kbuilderImpl, (Resource)resource);
        String modelPath = resource.getSourcePath();
        return new PMMLResource(kiePMMLModels, new File(resource.getSourcePath()).toPath(), modelPath);
    }
}

