/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.kie.memorycompiler.JavaConfiguration;

public abstract class AbstractKieMojo
extends AbstractMojo {
    @Parameter(property="dumpKieSourcesFolder", defaultValue="")
    protected String dumpKieSourcesFolder;
    @Parameter(property="javaCompiler", defaultValue="ecj")
    private String javaCompiler;

    protected JavaConfiguration.CompilerType getCompilerType() {
        return this.javaCompiler.equalsIgnoreCase("native") ? JavaConfiguration.CompilerType.NATIVE : JavaConfiguration.CompilerType.ECLIPSE;
    }

    protected void setSystemProperties(Map<String, String> properties) {
        if (properties != null) {
            this.getLog().debug((CharSequence)("Additional system properties: " + properties));
            for (Map.Entry<String, String> property : properties.entrySet()) {
                System.setProperty(property.getKey(), property.getValue());
            }
            this.getLog().debug((CharSequence)"Configured system properties were successfully set.");
        }
    }

    protected List<String> getFilesByType(InternalKieModule kieModule, String fileType) {
        return kieModule.getFileNames().stream().filter(f -> f.endsWith(fileType)).collect(Collectors.toList());
    }
}

