/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.drools.core.util.IoUtils;
import org.kie.memorycompiler.resources.ResourceStore;

public class DiskResourceStore
implements ResourceStore {
    private final File root;

    public DiskResourceStore(File root) {
        this.root = root;
    }

    public void write(String pResourceName, byte[] pResourceData) {
        this.write(pResourceName, pResourceData, false);
    }

    public void write(String pResourceName, byte[] pResourceData, boolean createFolder) {
        File dir;
        File file = new File(this.getFilePath(pResourceName));
        if (createFolder && !(dir = file.getParentFile()).exists()) {
            dir.mkdirs();
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(pResourceData);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public byte[] read(String pResourceName) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.getFilePath(pResourceName));
            byte[] byArray = IoUtils.readBytesFromInputStream((InputStream)fis);
            return byArray;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void remove(String pResourceName) {
        File file = new File(this.getFilePath(pResourceName));
        if (file.exists()) {
            file.delete();
        }
    }

    private String getFilePath(String pResourceName) {
        return this.root.getAbsolutePath() + File.separator + pResourceName;
    }
}

