/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.drools.ancompiler.CompiledNetworkSource;
import org.drools.ancompiler.ObjectTypeNodeCompiler;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.Rete;
import org.drools.modelcompiler.CanonicalKieModule;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.maven.plugin.AbstractDMNValidationAwareMojo;
import org.kie.maven.plugin.ExecModelMode;
import org.kie.maven.plugin.GenerateCodeUtil;
import org.kie.memorycompiler.JavaCompilerSettings;

@Mojo(name="generateANC", requiresDependencyResolution=ResolutionScope.NONE, defaultPhase=LifecyclePhase.COMPILE)
public class GenerateANCMojo
extends AbstractDMNValidationAwareMojo {
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession mavenSession;
    @Parameter(required=true, defaultValue="${project.build.directory}")
    private File targetDirectory;
    @Parameter(required=true, defaultValue="${project.basedir}")
    private File projectDir;
    @Parameter(required=true, defaultValue="${project.build.testSourceDirectory}")
    private File testDir;
    @Parameter
    private Map<String, String> properties;
    @Parameter(required=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;

    public void execute() throws MojoExecutionException {
        boolean ancParameterEnabled = ExecModelMode.ancEnabled(this.getGenerateModelOption());
        boolean modelCompilerInClassPath = ExecModelMode.isModelCompilerInClassPath(this.project.getDependencies());
        if (ancParameterEnabled && modelCompilerInClassPath) {
            this.generateANC();
        } else if (ancParameterEnabled) {
            this.getLog().warn((CharSequence)"You're trying to build rule assets in a project from an executable rule model, but you did not provide the required dependency on the project classpath.\nTo enable executable rule models for your project, add the `drools-model-compiler` dependency in the `pom.xml` file of your project.\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateANC() throws MojoExecutionException {
        JavaCompilerSettings javaCompilerSettings = GenerateCodeUtil.createJavaCompilerSettings();
        URLClassLoader projectClassLoader = GenerateCodeUtil.getProjectClassLoader(this.project, this.outputDirectory, javaCompilerSettings);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(projectClassLoader);
        try {
            this.setSystemProperties(this.properties);
            KieServices ks = KieServices.Factory.get();
            KieContainer kieContainer = ks.newKieContainer((ReleaseId)new ReleaseIdImpl(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion()));
            HashMap<String, String> classNameSourceMap = new HashMap<String, String>();
            for (String kbase : kieContainer.getKieBaseNames()) {
                InternalKnowledgeBase kieBase = (InternalKnowledgeBase)kieContainer.getKieBase(kbase);
                List ancSourceFiles = ObjectTypeNodeCompiler.compiledNetworkSources((Rete)kieBase.getRete());
                this.getLog().info((CharSequence)String.format("Found %d generated files in Knowledge Base %s", ancSourceFiles.size(), kbase));
                for (CompiledNetworkSource generatedFile : ancSourceFiles) {
                    String className = GenerateCodeUtil.toClassName(generatedFile.getSourceName());
                    classNameSourceMap.put(className, generatedFile.getSource());
                    this.getLog().info((CharSequence)("Generated Alpha Network class: " + className));
                }
            }
            GenerateCodeUtil.compileAndWriteClasses(this.targetDirectory, projectClassLoader, javaCompilerSettings, this.getCompilerType(), classNameSourceMap, this.dumpKieSourcesFolder);
            String ancFile = CanonicalKieModule.getANCFile((ReleaseId)new ReleaseIdImpl(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion()));
            Path ancFilePath = Paths.get(this.targetDirectory.getPath(), "classes", ancFile);
            try {
                Files.deleteIfExists(ancFilePath);
                Files.createDirectories(ancFilePath.getParent(), new FileAttribute[0]);
                Files.createFile(ancFilePath, new FileAttribute[0]);
                this.getLog().info((CharSequence)("Written ANC File: " + ancFilePath.toAbsolutePath()));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new MojoExecutionException("Unable to write file: ", (Exception)e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            if (projectClassLoader != null) {
                try {
                    projectClassLoader.close();
                }
                catch (IOException e) {
                    this.getLog().warn((Throwable)e);
                }
            }
        }
        this.getLog().info((CharSequence)"Compiled Alpha Network successfully generated");
    }
}

