/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin.executors;

import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.RuleBase;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.SessionsAwareKnowledgeBase;
import org.drools.model.codegen.execmodel.GeneratedFile;
import org.drools.util.io.FileSystemResource;
import org.kie.api.KieServices;
import org.kie.api.io.Resource;
import org.kie.maven.plugin.KieMavenPluginContext;
import org.kie.maven.plugin.PMMLResource;
import org.kie.maven.plugin.ProjectPomModel;
import org.kie.maven.plugin.helpers.GenerateCodeHelper;
import org.kie.memorycompiler.JavaCompilerSettings;
import org.kie.memorycompiler.JavaConfiguration;
import org.kie.pmml.commons.model.HasNestedModels;
import org.kie.pmml.commons.model.HasSourcesMap;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.evaluator.assembler.service.PMMLCompilerService;
import org.kie.util.maven.support.PomModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratePMMLModelExecutor {
    private static final Logger logger = LoggerFactory.getLogger(GeneratePMMLModelExecutor.class);
    private static final String PMML = "pmml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generatePMMLModel(KieMavenPluginContext kieMavenPluginContext) throws MojoExecutionException {
        MavenProject project = kieMavenPluginContext.getProject();
        MavenSession mavenSession = kieMavenPluginContext.getMavenSession();
        File outputDirectory = kieMavenPluginContext.getOutputDirectory();
        File projectDir = kieMavenPluginContext.getProjectDir();
        File targetDirectory = kieMavenPluginContext.getTargetDirectory();
        String dumpKieSourcesFolder = kieMavenPluginContext.getDumpKieSourcesFolder();
        List<org.apache.maven.model.Resource> resourcesDirectories = kieMavenPluginContext.getResourcesDirectories();
        JavaConfiguration.CompilerType compilerType = kieMavenPluginContext.getCompilerType();
        Log log = kieMavenPluginContext.getLog();
        JavaCompilerSettings javaCompilerSettings = GenerateCodeHelper.createJavaCompilerSettings();
        URLClassLoader projectClassLoader = GenerateCodeHelper.getProjectClassLoader(project, outputDirectory, javaCompilerSettings);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(projectClassLoader);
        try {
            Map<String, String> generatedFilesMap = GeneratePMMLModelExecutor.generateFiles(mavenSession, projectDir, resourcesDirectories, log);
            GenerateCodeHelper.compileAndWriteClasses(targetDirectory, projectClassLoader, javaCompilerSettings, compilerType, generatedFilesMap, dumpKieSourcesFolder);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            if (projectClassLoader != null) {
                try {
                    projectClassLoader.close();
                }
                catch (IOException e) {
                    log.warn((Throwable)e);
                }
            }
        }
        log.info((CharSequence)"PMML model successfully generated");
    }

    private static Map<String, String> generateFiles(MavenSession mavenSession, File projectDir, List<org.apache.maven.model.Resource> resourcesDirectories, Log log) throws MojoExecutionException {
        List<GeneratedFile> generatedFiles = GeneratePMMLModelExecutor.getGeneratedFiles(resourcesDirectories, log);
        KieServices ks = KieServices.Factory.get();
        KieBuilderImpl kieBuilder = (KieBuilderImpl)ks.newKieBuilder(projectDir);
        kieBuilder.setPomModel((PomModel)new ProjectPomModel(mavenSession));
        HashMap<String, String> classNameSourceMap = new HashMap<String, String>();
        for (GeneratedFile generatedFile : generatedFiles) {
            String className = GenerateCodeHelper.toClassName(generatedFile.getPath());
            classNameSourceMap.put(className, new String(generatedFile.getData()));
            log.info((CharSequence)("Generating " + className));
        }
        return classNameSourceMap;
    }

    private static List<GeneratedFile> getGeneratedFiles(List<org.apache.maven.model.Resource> resourcesDirectories, Log log) throws MojoExecutionException {
        ArrayList<GeneratedFile> toReturn = new ArrayList<GeneratedFile>();
        for (org.apache.maven.model.Resource resourceDirectory : resourcesDirectories) {
            File directoryFile = new File(resourceDirectory.getDirectory());
            log.info((CharSequence)("Looking for PMML models in " + directoryFile.getPath()));
            String errorMessageTemplate = null;
            if (!directoryFile.exists()) {
                errorMessageTemplate = "Resource path %s does not exists";
            } else if (!directoryFile.canRead()) {
                errorMessageTemplate = "Resource path %s is not readable";
            } else if (!directoryFile.isDirectory()) {
                errorMessageTemplate = "Resource path %s is not a directory";
            }
            if (errorMessageTemplate != null) {
                throw new MojoExecutionException(String.format(errorMessageTemplate, resourceDirectory));
            }
            toReturn.addAll(GeneratePMMLModelExecutor.getGeneratedFiles(directoryFile));
        }
        if (toReturn.isEmpty()) {
            log.info((CharSequence)"No PMML Models found.");
        } else {
            log.info((CharSequence)String.format("Found %s PMML models", toReturn.size()));
        }
        return toReturn;
    }

    private static List<GeneratedFile> getGeneratedFiles(File resourceDirectory) throws MojoExecutionException {
        List list;
        block8: {
            ArrayList toReturn = new ArrayList();
            Stream<Path> stream = Files.walk(resourceDirectory.toPath(), Integer.MAX_VALUE, new FileVisitOption[0]).filter(path -> path.toFile().isFile() && path.toString().endsWith(PMML));
            try {
                list = stream.map(Path::toFile).map(FileSystemResource::new).map(GeneratePMMLModelExecutor::parseResource).map(GeneratePMMLModelExecutor::getGenerateFiles).reduce(toReturn, (previous, toAdd) -> {
                    previous.addAll(toAdd);
                    return previous;
                });
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new MojoExecutionException(e.getMessage(), e);
                }
            }
            stream.close();
        }
        return list;
    }

    private static List<GeneratedFile> getGenerateFiles(PMMLResource pmmlResources) {
        ArrayList<GeneratedFile> toReturn = new ArrayList<GeneratedFile>();
        List<KiePMMLModel> kiepmmlModels = pmmlResources.getKiePmmlModels();
        GeneratePMMLModelExecutor.addModels(kiepmmlModels, pmmlResources, toReturn);
        return toReturn;
    }

    private static void addModels(List<KiePMMLModel> kiepmmlModels, PMMLResource resource, List<GeneratedFile> generatedFiles) {
        for (KiePMMLModel model : kiepmmlModels) {
            String errorMessage;
            if (model.getName() == null || model.getName().isEmpty()) {
                errorMessage = String.format("Model name should not be empty inside %s", resource.getModelPath());
                throw new RuntimeException(errorMessage);
            }
            if (!(model instanceof HasSourcesMap)) {
                errorMessage = String.format("Expecting HasSourcesMap instance, retrieved %s inside %s", model.getClass().getName(), resource.getModelPath());
                throw new RuntimeException(errorMessage);
            }
            Map sourceMap = ((HasSourcesMap)model).getSourcesMap();
            for (Map.Entry sourceMapEntry : sourceMap.entrySet()) {
                String path = ((String)sourceMapEntry.getKey()).replace('.', File.separatorChar) + ".java";
                generatedFiles.add(new GeneratedFile(GeneratedFile.Type.PMML, path, (String)sourceMapEntry.getValue()));
            }
            Map rulesSourceMap = ((HasSourcesMap)model).getRulesSourcesMap();
            if (rulesSourceMap != null) {
                for (Map.Entry rulesSourceMapEntry : rulesSourceMap.entrySet()) {
                    String path = ((String)rulesSourceMapEntry.getKey()).replace('.', File.separatorChar) + ".java";
                    generatedFiles.add(new GeneratedFile(GeneratedFile.Type.RULE, path, (String)rulesSourceMapEntry.getValue()));
                }
            }
            if (!(model instanceof HasNestedModels)) continue;
            GeneratePMMLModelExecutor.addModels(((HasNestedModels)model).getNestedModels(), resource, generatedFiles);
        }
    }

    private static PMMLResource parseResource(Resource resource) {
        KnowledgeBaseImpl ruleBase = new KnowledgeBaseImpl("PMML", null);
        SessionsAwareKnowledgeBase knowledgeBase = new SessionsAwareKnowledgeBase((RuleBase)ruleBase);
        KnowledgeBuilderImpl kbuilderImpl = new KnowledgeBuilderImpl((InternalKnowledgeBase)knowledgeBase);
        List kiePMMLModels = PMMLCompilerService.getKiePMMLModelsFromResourceWithSources((KnowledgeBuilderImpl)kbuilderImpl, (Resource)resource);
        String modelPath = resource.getSourcePath();
        return new PMMLResource(kiePMMLModels, new File(resource.getSourcePath()).toPath(), modelPath);
    }
}

