/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin.executors;

import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.drools.compiler.compiler.io.Folder;
import org.drools.compiler.compiler.io.memory.MemoryFile;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.BuildContext;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.compiler.kie.builder.impl.MemoryKieModule;
import org.drools.model.codegen.execmodel.CanonicalModelKieProject;
import org.drools.model.codegen.execmodel.ModelBuilderImpl;
import org.drools.model.codegen.execmodel.ModelSourceClass;
import org.drools.model.codegen.execmodel.ModelWriter;
import org.drools.modelcompiler.CanonicalKieModule;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.ReleaseId;
import org.kie.maven.plugin.KieMavenPluginContext;
import org.kie.maven.plugin.ProjectPomModel;
import org.kie.maven.plugin.helpers.DMNValidationHelper;
import org.kie.maven.plugin.helpers.ExecModelModeHelper;
import org.kie.maven.plugin.helpers.ExecutorHelper;
import org.kie.maven.plugin.helpers.GenerateCodeHelper;
import org.kie.memorycompiler.JavaCompilerSettings;
import org.kie.memorycompiler.JavaConfiguration;
import org.kie.util.maven.support.PomModel;

public class GenerateModelExecutor {
    public static PathMatcher drlFileMatcher = FileSystems.getDefault().getPathMatcher("glob:**.drl");

    private GenerateModelExecutor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateModel(KieMavenPluginContext kieMavenPluginContext) throws MojoExecutionException, MojoFailureException {
        MavenProject project = kieMavenPluginContext.getProject();
        MavenSession mavenSession = kieMavenPluginContext.getMavenSession();
        File outputDirectory = kieMavenPluginContext.getOutputDirectory();
        File projectDir = kieMavenPluginContext.getProjectDir();
        Map<String, String> properties = kieMavenPluginContext.getProperties();
        File targetDirectory = kieMavenPluginContext.getTargetDirectory();
        String dumpKieSourcesFolder = kieMavenPluginContext.getDumpKieSourcesFolder();
        List<Resource> resources = kieMavenPluginContext.getResources();
        JavaConfiguration.CompilerType compilerType = kieMavenPluginContext.getCompilerType();
        String validateDMN = kieMavenPluginContext.getValidateDMN();
        String generateModel = kieMavenPluginContext.getGenerateModel();
        Log log = kieMavenPluginContext.getLog();
        JavaCompilerSettings javaCompilerSettings = GenerateCodeHelper.createJavaCompilerSettings();
        URLClassLoader projectClassLoader = GenerateCodeHelper.getProjectClassLoader(project, outputDirectory, javaCompilerSettings);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(projectClassLoader);
        try {
            ExecutorHelper.setSystemProperties(properties, log);
            KieServices ks = KieServices.Factory.get();
            KieBuilderImpl kieBuilder = (KieBuilderImpl)ks.newKieBuilder(projectDir);
            kieBuilder.setPomModel((PomModel)new ProjectPomModel(mavenSession));
            kieBuilder.buildAll(ExecutableModelMavenProject.SUPPLIER, s -> !s.contains("src/test/java") && !s.contains("src\\test\\java"));
            InternalKieModule kieModule = (InternalKieModule)kieBuilder.getKieModule();
            List generatedFiles = kieModule.getFileNames().stream().filter(f -> f.endsWith("java")).collect(Collectors.toList());
            log.info((CharSequence)String.format("Found %d generated files in Canonical Model", generatedFiles.size()));
            MemoryFileSystem mfs = kieModule instanceof CanonicalKieModule ? ((MemoryKieModule)((CanonicalKieModule)kieModule).getInternalKieModule()).getMemoryFileSystem() : ((MemoryKieModule)kieModule).getMemoryFileSystem();
            HashMap<String, String> classNameSourceMap = new HashMap<String, String>();
            for (String generatedFile : generatedFiles) {
                MemoryFile f2 = (MemoryFile)mfs.getFile(generatedFile);
                String className = GenerateCodeHelper.toClassName(generatedFile);
                classNameSourceMap.put(className, new String(mfs.getFileContents(f2)));
                log.info((CharSequence)("Generating " + className));
            }
            GenerateCodeHelper.compileAndWriteClasses(targetDirectory, projectClassLoader, javaCompilerSettings, compilerType, classNameSourceMap, dumpKieSourcesFolder);
            GenerateModelExecutor.copyMetaInfFile(targetDirectory, mfs, CanonicalKieModule.getModelFileWithGAV((ReleaseId)kieModule.getReleaseId()));
            GenerateModelExecutor.copyMetaInfFile(targetDirectory, mfs, "META-INF/services/org.drools.ruleunits.api.RuleUnit");
            if (DMNValidationHelper.shallPerformDMNDTAnalysis(validateDMN, log)) {
                DMNValidationHelper.performDMNDTAnalysis(kieModule, resources, log);
            }
            if (ExecModelModeHelper.shouldDeleteFile(generateModel)) {
                Set<String> drlFiles = kieModule.getFileNames().stream().filter(f -> f.endsWith("drl")).collect(Collectors.toSet());
                GenerateModelExecutor.deleteDrlFiles(outputDirectory, projectDir, drlFiles, log);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            if (projectClassLoader != null) {
                try {
                    projectClassLoader.close();
                }
                catch (IOException e) {
                    log.warn((Throwable)e);
                }
            }
        }
        log.info((CharSequence)"DSL successfully generated");
    }

    private static void copyMetaInfFile(File targetDirectory, MemoryFileSystem mfs, String path) throws MojoExecutionException {
        MemoryFile memoryFile = (MemoryFile)mfs.getFile(path);
        if (!memoryFile.exists()) {
            return;
        }
        String packagesMemoryFilePath = memoryFile.getFolder().getPath().asString();
        Path packagesDestinationPath = Paths.get(targetDirectory.getPath(), "classes", packagesMemoryFilePath, memoryFile.getName());
        try {
            if (!Files.exists(packagesDestinationPath, new LinkOption[0])) {
                Files.createDirectories(packagesDestinationPath.getParent(), new FileAttribute[0]);
            }
            Files.copy(memoryFile.getContents(), packagesDestinationPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write file", (Exception)e);
        }
    }

    private static void deleteDrlFiles(File outputDirectory, File projectDir, Set<String> actualDrlFiles, Log log) throws MojoExecutionException {
        try (Stream<Path> drlFilesToDeleted = Files.find(outputDirectory.toPath(), Integer.MAX_VALUE, (p, f) -> drlFileMatcher.matches((Path)p), new FileVisitOption[0]);){
            HashSet deletedFiles = new HashSet();
            drlFilesToDeleted.forEach(p -> {
                try {
                    Files.delete(p);
                    deletedFiles.add(p.toString());
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to delete file " + p);
                }
            });
            actualDrlFiles.retainAll(deletedFiles);
            if (!actualDrlFiles.isEmpty()) {
                String actualDrlFiles1 = String.join((CharSequence)",", actualDrlFiles);
                log.warn((CharSequence)("Base directory: " + projectDir));
                log.warn((CharSequence)("Files not deleted: " + actualDrlFiles1));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to find .drl files");
        }
    }

    public static class ExecutableModelMavenProject
    implements KieBuilder.ProjectType {
        public static final BiFunction<InternalKieModule, ClassLoader, KieModuleKieProject> SUPPLIER = ExecutableModelMavenPluginKieProject::new;

        private ExecutableModelMavenProject() {
        }

        public static class ExecutableModelMavenPluginKieProject
        extends CanonicalModelKieProject {
            public ExecutableModelMavenPluginKieProject(InternalKieModule kieModule, ClassLoader classLoader) {
                super(kieModule, classLoader);
            }

            public void writeProjectOutput(MemoryFileSystem trgMfs, BuildContext buildContext) {
                MemoryFileSystem srcMfs = new MemoryFileSystem();
                Folder sourceFolder = srcMfs.getFolder("src/main/java");
                ArrayList modelFiles = new ArrayList();
                ArrayList ruleUnitClassNames = new ArrayList();
                ModelWriter modelWriter = new ModelWriter();
                HashMap<String, List> modelsByKBase = new HashMap<String, List>();
                for (Map.Entry modelBuilder : this.modelBuilders.entrySet()) {
                    ModelWriter.Result result = modelWriter.writeModel(srcMfs, ((ModelBuilderImpl)modelBuilder.getValue()).getPackageSources());
                    modelFiles.addAll(result.getModelFiles());
                    ruleUnitClassNames.addAll(result.getRuleUnitClassNames());
                    modelsByKBase.put((String)modelBuilder.getKey(), result.getModelFiles());
                }
                InternalKieModule kieModule = this.getInternalKieModule();
                ModelSourceClass modelSourceClass = new ModelSourceClass(kieModule.getReleaseId(), kieModule.getKieModuleModel().getKieBaseModels(), modelsByKBase, this.hasDynamicClassLoader());
                String projectSourcePath = modelSourceClass.getName();
                srcMfs.write(projectSourcePath, modelSourceClass.generate().getBytes());
                Folder targetFolder = trgMfs.getFolder(".");
                srcMfs.copyFolder(sourceFolder, trgMfs, targetFolder, new String[0]);
                modelWriter.writeModelFile(modelFiles, trgMfs, this.getInternalKieModule().getReleaseId());
                modelWriter.writeRuleUnitServiceFile(ruleUnitClassNames, trgMfs);
            }
        }
    }
}

