/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin.helpers;

import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.kie.api.builder.Message;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.definition.KiePackage;
import org.kie.api.internal.io.ResourceTypePackage;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.core.assembler.DMNAssemblerService;
import org.kie.dmn.core.compiler.DMNProfile;
import org.kie.dmn.feel.util.ClassLoaderUtil;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.InternalDMNDTAnalyser;
import org.kie.dmn.validation.dtanalysis.InternalDMNDTAnalyserFactory;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.internal.utils.ChainedProperties;

public class DMNValidationHelper {
    private DMNValidationHelper() {
    }

    public static void logValidationMessages(List<DMNMessage> validation, Function<DMNMessage, String> prefixer, Function<DMNMessage, String> computeMessage, Log log) {
        for (DMNMessage msg : validation) {
            Consumer<CharSequence> logFn = null;
            switch (msg.getLevel()) {
                case ERROR: {
                    logFn = arg_0 -> ((Log)log).error(arg_0);
                    break;
                }
                case WARNING: {
                    logFn = arg_0 -> ((Log)log).warn(arg_0);
                    break;
                }
                default: {
                    logFn = arg_0 -> ((Log)log).info(arg_0);
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append(prefixer.apply(msg));
            sb.append(computeMessage.apply(msg));
            logFn.accept(sb.toString());
        }
    }

    public static List<DMNValidator.Validation> computeFlagsFromCSVString(String csvString, Log log) {
        ArrayList<DMNValidator.Validation> flags = new ArrayList<DMNValidator.Validation>();
        boolean resetFlag = false;
        for (String p : csvString.split(",")) {
            try {
                flags.add(DMNValidator.Validation.valueOf((String)p));
            }
            catch (IllegalArgumentException e) {
                log.info((CharSequence)("validateDMN configured with flag: '" + p + "' determines this Mojo will not be executed (reset all flags)."));
                resetFlag = true;
            }
        }
        if (resetFlag) {
            flags.clear();
        }
        return flags;
    }

    public static boolean shallPerformDMNDTAnalysis(String validateDMN, Log log) {
        return DMNValidationHelper.computeFlagsFromCSVString(validateDMN, log).contains(DMNValidator.Validation.ANALYZE_DECISION_TABLE);
    }

    public static void performDMNDTAnalysis(InternalKieModule kieModule, List<org.apache.maven.model.Resource> resources, Log log) throws MojoExecutionException, MojoFailureException {
        Collection<DMNModel> dmnModels = DMNValidationHelper.extractDMNModelsFromKieModule(kieModule);
        log.info((CharSequence)"Initializing DMN DT Validator...");
        InternalDMNDTAnalyser analyser = InternalDMNDTAnalyserFactory.newDMNDTAnalyser(DMNValidationHelper.computeDMNProfiles(resources, log));
        log.info((CharSequence)"DMN DT Validator initialized.");
        for (DMNModel model : dmnModels) {
            log.info((CharSequence)("Analysing decision tables in DMN Model '" + model.getName() + "' ..."));
            List results = analyser.analyse(model, new HashSet<DMNValidator.Validation>(Arrays.asList(DMNValidator.Validation.ANALYZE_DECISION_TABLE)));
            if (results.isEmpty()) {
                log.info((CharSequence)" no decision tables found.");
                continue;
            }
            for (DTAnalysis r : results) {
                log.info((CharSequence)(" analysis for decision table '" + r.nameOrIDOfTable() + "':"));
                List messages = r.asDMNMessages();
                DMNValidationHelper.logValidationMessages(messages, u -> "  ", Message::getText, log);
                if (!messages.stream().anyMatch(m -> m.getLevel() == Message.Level.ERROR)) continue;
                throw new MojoFailureException("There are DMN Validation Error(s).");
            }
        }
    }

    public static List<Path> resourcesPaths(List<org.apache.maven.model.Resource> resources, Log log) {
        List<Path> resourcesPaths = resources.stream().map(r -> new File(r.getDirectory()).toPath()).collect(Collectors.toList());
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("resourcesPaths: " + resourcesPaths.stream().map(Path::toString).collect(Collectors.joining(",\n"))));
        }
        return resourcesPaths;
    }

    private static Collection<DMNModel> extractDMNModelsFromKieModule(InternalKieModule kieModule) {
        Collection kpkgs = kieModule.getKieModuleModel().getKieBaseModels().keySet().stream().flatMap(name -> kieModule.getKnowledgePackagesForKieBase(name).stream()).collect(Collectors.toList());
        HashSet<DMNModel> models = new HashSet<DMNModel>();
        for (KiePackage kp : kpkgs) {
            InternalKnowledgePackage ikpkg = (InternalKnowledgePackage)kp;
            ResourceTypePackage rtp = ikpkg.getResourceTypePackages().get(ResourceType.DMN);
            if (rtp == null) continue;
            for (DMNModel dmnModel : rtp) {
                models.add(dmnModel);
            }
        }
        HashMap<Resource, DMNModel> removeDups = new HashMap<Resource, DMNModel>();
        for (DMNModel m : models) {
            removeDups.put(m.getResource(), m);
        }
        return removeDups.values();
    }

    public static List<DMNProfile> computeDMNProfiles(List<org.apache.maven.model.Resource> resources, Log log) throws MojoExecutionException {
        ClassLoader classLoader = ClassLoaderUtil.findDefaultClassLoader();
        ChainedProperties chainedProperties = ChainedProperties.getChainedProperties((ClassLoader)classLoader);
        ArrayList<KieModuleModel> kieModules = new ArrayList<KieModuleModel>();
        for (Path p : DMNValidationHelper.resourcesPaths(resources, log)) {
            try {
                Stream<Path> walk = Files.walk(p, new FileVisitOption[0]);
                try {
                    List collect = walk.filter(f -> f.toString().endsWith("kmodule.xml")).collect(Collectors.toList());
                    for (Path k : collect) {
                        kieModules.add(KieModuleModelImpl.fromXML((File)k.toFile()));
                    }
                }
                finally {
                    if (walk == null) continue;
                    walk.close();
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed executing AbstractDMNValidationAwareMojo while computing DMNProfile(s)", e);
            }
        }
        for (KieModuleModel kmm : kieModules) {
            Properties ps = new Properties();
            ps.putAll((Map<?, ?>)kmm.getConfigurationProperties());
            chainedProperties.addProperties(ps);
        }
        ArrayList<DMNProfile> dmnProfiles = new ArrayList<DMNProfile>();
        dmnProfiles.addAll(DMNAssemblerService.getDefaultDMNProfiles((ChainedProperties)chainedProperties));
        try {
            HashMap dmnProfileProperties = new HashMap();
            chainedProperties.mapStartsWith(dmnProfileProperties, "org.kie.dmn.profiles.", false);
            for (Map.Entry dmnProfileProperty : dmnProfileProperties.entrySet()) {
                DMNProfile dmnProfile = (DMNProfile)classLoader.loadClass((String)dmnProfileProperty.getValue()).newInstance();
                dmnProfiles.add(dmnProfile);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new MojoExecutionException("Failed executing AbstractDMNValidationAwareMojo while computing DMNProfile(s)", (Exception)e);
        }
        return dmnProfiles;
    }
}

