/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin.executors;

import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.kie.efesto.common.api.model.GeneratedClassResource;
import org.kie.efesto.common.api.model.GeneratedResources;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationContext;
import org.kie.efesto.compilationmanager.api.model.EfestoFileResource;
import org.kie.efesto.compilationmanager.api.model.EfestoResource;
import org.kie.efesto.compilationmanager.api.service.CompilationManager;
import org.kie.efesto.compilationmanager.api.utils.SPIUtils;
import org.kie.maven.plugin.KieMavenPluginContext;
import org.kie.maven.plugin.helpers.GenerateCodeHelper;
import org.kie.memorycompiler.JavaCompilerSettings;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.kie.pmml.api.compilation.PMMLCompilationContext;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.PMMLCompilationContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratePMMLModelExecutor {
    private static final Logger logger = LoggerFactory.getLogger(GeneratePMMLModelExecutor.class);

    private GeneratePMMLModelExecutor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generatePMMLModel(KieMavenPluginContext kieMavenPluginContext) throws MojoExecutionException {
        MavenProject project = kieMavenPluginContext.getProject();
        File outputDirectory = kieMavenPluginContext.getOutputDirectory();
        File targetDirectory = kieMavenPluginContext.getTargetDirectory();
        List<Resource> resourcesDirectories = kieMavenPluginContext.getResourcesDirectories();
        Log log = kieMavenPluginContext.getLog();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        JavaCompilerSettings javaCompilerSettings = GenerateCodeHelper.createJavaCompilerSettings();
        URLClassLoader projectClassLoader = GenerateCodeHelper.getProjectClassLoader(project, outputDirectory, javaCompilerSettings);
        Thread.currentThread().setContextClassLoader(projectClassLoader);
        try {
            Map<String, byte[]> compiledClassesMap = GeneratePMMLModelExecutor.compileFiles(resourcesDirectories, projectClassLoader, outputDirectory, log);
            GenerateCodeHelper.writeClasses(targetDirectory, compiledClassesMap);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            if (projectClassLoader != null) {
                try {
                    projectClassLoader.close();
                }
                catch (IOException e) {
                    log.warn((Throwable)e);
                }
            }
        }
        log.info((CharSequence)"PMML model successfully generated");
    }

    private static Map<String, byte[]> compileFiles(List<Resource> resourcesDirectories, ClassLoader projectClassloader, File outputDirectory, Log log) throws MojoExecutionException {
        CompilationManager compilationManager = (CompilationManager)SPIUtils.getCompilationManager((boolean)true).orElseThrow(() -> new MojoExecutionException("Failed to load CompilationManager"));
        KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader = new KieMemoryCompiler.MemoryCompilerClassLoader(projectClassloader);
        List<EfestoResource> efestoResources = GeneratePMMLModelExecutor.getEfestoResources(resourcesDirectories, log);
        PMMLCompilationContextImpl pmmlContext = new PMMLCompilationContextImpl("", memoryCompilerClassLoader);
        compilationManager.processResource((EfestoCompilationContext)pmmlContext, efestoResources.toArray(new EfestoResource[0]));
        Map indexFilesCreated = pmmlContext.createIndexFiles(outputDirectory.toPath());
        indexFilesCreated.forEach((key, value) -> logger.debug("IndexFile generated {} {}", key, (Object)value.toPath()));
        return GeneratePMMLModelExecutor.getCodeFromPMMLContext((PMMLCompilationContext)pmmlContext);
    }

    private static Map<String, byte[]> getCodeFromPMMLContext(PMMLCompilationContext pmmlContext) {
        List generatedClasses = pmmlContext.getGeneratedResourcesMap().values().stream().flatMap(generatedResources -> GeneratePMMLModelExecutor.getGeneratedClassesFromGeneratedResources(generatedResources).stream()).collect(Collectors.toList());
        return generatedClasses.stream().collect(Collectors.toMap(fullClassName -> fullClassName, fullClassName -> GeneratePMMLModelExecutor.getMappedCode(fullClassName, pmmlContext)));
    }

    private static byte[] getMappedCode(String fullClassName, PMMLCompilationContext pmmlContext) throws KiePMMLException {
        byte[] toReturn = pmmlContext.getCode(fullClassName);
        if (toReturn == null) {
            throw new KiePMMLException(String.format("Failed to found %s in %s", fullClassName, pmmlContext));
        }
        return toReturn;
    }

    private static List<String> getGeneratedClassesFromGeneratedResources(GeneratedResources generatedResources) {
        return generatedResources.stream().filter(GeneratedClassResource.class::isInstance).map(GeneratedClassResource.class::cast).map(GeneratedClassResource::getFullClassName).collect(Collectors.toList());
    }

    private static List<EfestoResource> getEfestoResources(List<Resource> resourcesDirectories, Log log) throws MojoExecutionException {
        ArrayList<EfestoResource> toReturn = new ArrayList<EfestoResource>();
        for (Resource resourceDirectory : resourcesDirectories) {
            File directoryFile = new File(resourceDirectory.getDirectory());
            log.info((CharSequence)("Looking for PMML models in " + directoryFile.getPath()));
            String errorMessageTemplate = null;
            if (!directoryFile.exists()) {
                errorMessageTemplate = "Resource path %s does not exists";
            } else if (!directoryFile.canRead()) {
                errorMessageTemplate = "Resource path %s is not readable";
            } else if (!directoryFile.isDirectory()) {
                errorMessageTemplate = "Resource path %s is not a directory";
            }
            if (errorMessageTemplate != null) {
                throw new MojoExecutionException(String.format(errorMessageTemplate, resourceDirectory));
            }
            toReturn.addAll(GeneratePMMLModelExecutor.getEfestoResources(directoryFile));
        }
        if (toReturn.isEmpty()) {
            log.info((CharSequence)"No PMML Models found.");
        } else {
            log.info((CharSequence)String.format("Found %s PMML models", toReturn.size()));
        }
        return toReturn;
    }

    private static List<EfestoResource> getEfestoResources(File resourceDirectory) throws MojoExecutionException {
        List<EfestoResource> list;
        block8: {
            Stream<Path> stream = Files.walk(resourceDirectory.toPath(), Integer.MAX_VALUE, new FileVisitOption[0]).filter(path -> path.toFile().isFile() && path.toString().endsWith("pmml"));
            try {
                list = stream.map(Path::toFile).map(EfestoFileResource::new).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new MojoExecutionException(e.getMessage(), e);
                }
            }
            stream.close();
        }
        return list;
    }
}

