/*
 * Decompiled with CFR 0.152.
 */
package org.kie.memorycompiler.resources;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.memorycompiler.resources.KiePath;
import org.kie.memorycompiler.resources.ResourceReader;

public class MemoryResourceReader
implements ResourceReader {
    private final Map<KiePath, byte[]> resources = new ConcurrentHashMap<KiePath, byte[]>();
    private Set<String> modifiedResourcesSinceLastMark;

    @Override
    public boolean isAvailable(KiePath path) {
        return this.resources.containsKey(path);
    }

    public void add(String resourceName, byte[] pContent) {
        KiePath normalizedName = KiePath.of(resourceName);
        this.resources.put(normalizedName, pContent);
        if (this.modifiedResourcesSinceLastMark != null) {
            this.modifiedResourcesSinceLastMark.add(normalizedName.asString());
        }
    }

    public void remove(KiePath path) {
        this.resources.remove(path);
    }

    @Override
    public void mark() {
        this.modifiedResourcesSinceLastMark = new HashSet<String>();
    }

    @Override
    public Collection<String> getModifiedResourcesSinceLastMark() {
        return this.modifiedResourcesSinceLastMark;
    }

    @Override
    public byte[] getBytes(KiePath path) {
        return this.resources.get(path);
    }

    @Override
    public Collection<KiePath> getFilePaths() {
        return this.resources.keySet();
    }
}

