/*
 * Decompiled with CFR 0.152.
 */
package org.kie.perf.suite;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import org.kie.perf.SharedMetricRegistry;
import org.kie.perf.TestConfig;
import org.kie.perf.annotation.KPKLimit;
import org.kie.perf.run.IRunType;
import org.kie.perf.scenario.IPerfTest;
import org.kie.perf.suite.ITestSuite;

public class ConcurrentLoadSuite
implements ITestSuite {
    protected int iterations = 1;
    protected int threads = 1;

    @Override
    public String getTestPackage() {
        return "org.kie.perf.scenario.load";
    }

    @Override
    public void initScenario(IPerfTest scenario) throws Exception {
        TestConfig tc = TestConfig.getInstance();
        this.iterations = tc.getIterations();
        this.threads = tc.getThreads();
        scenario.init();
    }

    @Override
    public void startScenario(final IPerfTest scenario) {
        ArrayList<Thread> threadsList = new ArrayList<Thread>();
        KPKLimit limit = scenario.getClass().getAnnotation(KPKLimit.class);
        final int max = limit != null ? limit.value() : Integer.MAX_VALUE;
        Timer duration = SharedMetricRegistry.getInstance().timer(MetricRegistry.name(scenario.getClass(), (String[])new String[]{"scenario.total.duration"}));
        Timer.Context context = duration.time();
        for (int i = 0; i < this.threads; ++i) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    Timer duration = SharedMetricRegistry.getInstance().timer(MetricRegistry.name(scenario.getClass(), (String[])new String[]{"scenario.single.duration"}));
                    IRunType run = TestConfig.getInstance().getRunType().newInstance();
                    run.start(max);
                    while (!run.isEnd()) {
                        Timer.Context context = duration.time();
                        scenario.execute();
                        context.stop();
                    }
                }
            });
            threadsList.add(t);
        }
        for (Thread t : threadsList) {
            t.start();
        }
        for (Thread t : threadsList) {
            try {
                t.join();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        context.stop();
        scenario.close();
        threadsList.clear();
    }
}

