/*
 * Decompiled with CFR 0.152.
 */
package org.kie.perf.suite;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import org.kie.perf.SharedMetricRegistry;
import org.kie.perf.TestConfig;
import org.kie.perf.annotation.KPKLimit;
import org.kie.perf.run.IRunType;
import org.kie.perf.scenario.IPerfTest;
import org.kie.perf.suite.ITestSuite;

public class LoadSuite
implements ITestSuite {
    protected int iterations;

    @Override
    public String getTestPackage() {
        return "org.kie.perf.scenario.load";
    }

    @Override
    public void initScenario(IPerfTest scenario) throws Exception {
        TestConfig tc = TestConfig.getInstance();
        this.iterations = tc.getIterations();
        scenario.init();
    }

    @Override
    public void startScenario(IPerfTest scenario) {
        MetricRegistry metrics = SharedMetricRegistry.getInstance();
        TestConfig tc = TestConfig.getInstance();
        IRunType run = tc.getRunType().newInstance();
        Timer.Context contextDuration = null;
        if (tc.getRunType() != TestConfig.RunType.DURATION) {
            Timer duration = metrics.timer(MetricRegistry.name(scenario.getClass(), (String[])new String[]{"scenario.total.duration"}));
            contextDuration = duration.time();
        }
        KPKLimit limit = scenario.getClass().getAnnotation(KPKLimit.class);
        int max = Integer.MAX_VALUE;
        if (limit != null) {
            max = limit.value();
        }
        Timer scenarioDuration = metrics.timer(MetricRegistry.name(scenario.getClass(), (String[])new String[]{"scenario.single.duration"}));
        run.start(max);
        while (!run.isEnd()) {
            Timer.Context context = scenarioDuration.time();
            try {
                scenario.execute();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            context.stop();
        }
        if (contextDuration != null) {
            contextDuration.stop();
        }
        scenario.close();
    }
}

