/*
 * Decompiled with CFR 0.152.
 */
package org.kie.perf.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.kie.perf.TestConfig;
import org.perfrepo.client.PerfRepoClient;
import org.perfrepo.model.Metric;
import org.perfrepo.model.Test;
import org.perfrepo.model.TestExecution;
import org.perfrepo.model.builder.TestExecutionBuilder;

public class PerfRepoReporter
extends ScheduledReporter {
    private final PerfRepoClient client;
    private TestExecution testExecution;
    private boolean scheduled;
    private long passedTime;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private PerfRepoReporter(MetricRegistry registry, PerfRepoClient client, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter, boolean scheduled) {
        super(registry, "perf-repo-reporter", filter, rateUnit, durationUnit);
        this.client = client;
        this.scheduled = scheduled;
        this.passedTime = 0L;
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        String testName;
        TestConfig tc = TestConfig.getInstance();
        String testExecutionName = testName = tc.getProjectName() + " - " + tc.getSuite();
        if (this.scheduled) {
            testName = testName + " - " + tc.getVersion();
            this.passedTime += (long)tc.getPeriodicity();
            testExecutionName = testExecutionName + " - " + (double)this.passedTime / 60.0 + "m passed";
        } else {
            if (tc.getScenario() != null) {
                testName = testName + " - " + tc.getScenario();
            }
            testExecutionName = tc.getRunType() == TestConfig.RunType.DURATION ? testExecutionName + " - " + tc.getDuration() + " seconds" : testExecutionName + " - " + tc.getIterations() + " iterations";
        }
        String testUid = tc.getProjectName().toLowerCase().replaceAll(" ", "_") + "_" + tc.getSuite().toLowerCase() + "_" + tc.getScenario().toLowerCase();
        TestExecutionBuilder testExecution = TestExecution.builder().testUid(testUid).name(testExecutionName + " - Result").started(new Date());
        if (this.testExecution != null) {
            testExecution.id(this.testExecution.getId());
        }
        for (String string : tc.getTags()) {
            testExecution.tag(string);
        }
        for (Map.Entry entry : tc.getProperties().entrySet()) {
            testExecution.parameter(entry.getKey().toString(), entry.getValue().toString());
        }
        testExecution.parameter("java.vm.name", System.getProperty("java.vm.name"));
        testExecution.parameter("java.version", System.getProperty("java.version"));
        testExecution.parameter("java.runtime.availableProcessors", String.valueOf(Runtime.getRuntime().availableProcessors()));
        try {
            testExecution.parameter("machine.hostname", InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        testExecution.parameter("os.arch", System.getProperty("os.arch"));
        testExecution.parameter("os.name", System.getProperty("os.name"));
        ArrayList<String> metricLabels = new ArrayList<String>();
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            this.reportGauge(testExecution, entry.getKey(), entry.getValue());
            metricLabels.add(entry.getKey() + ".value");
        }
        for (Map.Entry<String, Counter> entry : counters.entrySet()) {
            this.reportCounter(testExecution, entry.getKey(), entry.getValue());
            metricLabels.add(entry.getKey() + ".count");
        }
        for (Map.Entry<String, Histogram> entry : histograms.entrySet()) {
            this.reportHistogram(testExecution, entry.getKey(), entry.getValue());
            metricLabels.add(entry.getKey() + ".count");
            metricLabels.add(entry.getKey() + ".min");
            metricLabels.add(entry.getKey() + ".mean");
            metricLabels.add(entry.getKey() + ".max");
            metricLabels.add(entry.getKey() + ".stddev");
            metricLabels.add(entry.getKey() + ".median");
            metricLabels.add(entry.getKey() + ".p75");
            metricLabels.add(entry.getKey() + ".p95");
            metricLabels.add(entry.getKey() + ".p98");
            metricLabels.add(entry.getKey() + ".p99");
            metricLabels.add(entry.getKey() + ".p999");
        }
        for (Map.Entry<String, Meter> entry : meters.entrySet()) {
            this.reportMeter(testExecution, entry.getKey(), entry.getValue());
            metricLabels.add(entry.getKey() + ".count");
        }
        for (Map.Entry<String, Timer> entry : timers.entrySet()) {
            this.reportTimer(testExecution, entry.getKey(), entry.getValue());
            metricLabels.add(entry.getKey());
            metricLabels.add(entry.getKey() + ".count");
            metricLabels.add(entry.getKey() + ".throughput");
            metricLabels.add(entry.getKey() + ".min");
            metricLabels.add(entry.getKey() + ".mean");
            metricLabels.add(entry.getKey() + ".max");
            metricLabels.add(entry.getKey() + ".stddev");
            metricLabels.add(entry.getKey() + ".median");
            metricLabels.add(entry.getKey() + ".p75");
            metricLabels.add(entry.getKey() + ".p95");
            metricLabels.add(entry.getKey() + ".p98");
            metricLabels.add(entry.getKey() + ".p99");
            metricLabels.add(entry.getKey() + ".p999");
        }
        try {
            Test test = this.client.getTestByUid(testUid);
            if (test == null) {
                ArrayList<Metric> arrayList = new ArrayList<Metric>();
                for (String ml : metricLabels) {
                    Metric m = new Metric();
                    m.setName(this.getMeterName(ml));
                    m.setDescription("TBD");
                    arrayList.add(m);
                }
                Test test2 = new Test();
                test2.setDescription("Automatically created test definition by PerfRepoReporter.");
                test2.setUid(testUid);
                test2.setGroupId("BxMS");
                test2.setName(testName);
                test2.setMetrics(arrayList);
                this.client.createTest(test2);
            }
            if (this.testExecution == null) {
                this.testExecution = testExecution.build();
                long l = this.client.createTestExecution(this.testExecution);
                this.testExecution.setId(Long.valueOf(l));
            } else {
                this.testExecution = testExecution.build();
                this.client.addValue(this.testExecution);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setScheduled(boolean scheduled) {
        this.scheduled = scheduled;
    }

    private void reportTimer(TestExecutionBuilder testExecution, String name, Timer timer) {
        Snapshot snapshot = timer.getSnapshot();
        testExecution.value(this.getMeterName(name) + ".count", Double.valueOf(timer.getCount()));
        testExecution.value(this.getMeterName(name) + ".throughput", Double.valueOf(this.convertRate(timer.getMeanRate())), "unit", "events/" + this.getRateUnit());
        testExecution.value(this.getMeterName(name) + ".min", Double.valueOf(this.convertDuration(snapshot.getMin())), "unit", this.getDurationUnit());
        testExecution.value(this.getMeterName(name) + ".mean", Double.valueOf(this.convertDuration(snapshot.getMean())), "unit", this.getDurationUnit());
        testExecution.value(this.getMeterName(name) + ".max", Double.valueOf(this.convertDuration(snapshot.getMax())), "unit", this.getDurationUnit());
        testExecution.value(this.getMeterName(name) + ".stddev", Double.valueOf(this.convertDuration(snapshot.getStdDev())));
        testExecution.value(this.getMeterName(name) + ".median", Double.valueOf(this.convertDuration(snapshot.getMedian())));
        testExecution.value(this.getMeterName(name) + ".p75", Double.valueOf(this.convertDuration(snapshot.get75thPercentile())));
        testExecution.value(this.getMeterName(name) + ".p95", Double.valueOf(this.convertDuration(snapshot.get95thPercentile())));
        testExecution.value(this.getMeterName(name) + ".p98", Double.valueOf(this.convertDuration(snapshot.get98thPercentile())));
        testExecution.value(this.getMeterName(name) + ".p99", Double.valueOf(this.convertDuration(snapshot.get99thPercentile())));
        testExecution.value(this.getMeterName(name) + ".p999", Double.valueOf(this.convertDuration(snapshot.get999thPercentile())));
    }

    private void reportMeter(TestExecutionBuilder testExecution, String name, Meter meter) {
        testExecution.value(this.getMeterName(name) + ".count", Double.valueOf(meter.getCount()));
    }

    private void reportHistogram(TestExecutionBuilder testExecution, String name, Histogram histogram) {
        Snapshot snapshot = histogram.getSnapshot();
        testExecution.value(this.getMeterName(name) + ".count", Double.valueOf(histogram.getCount()));
        testExecution.value(this.getMeterName(name) + ".min", Double.valueOf(snapshot.getMin()));
        testExecution.value(this.getMeterName(name) + ".mean", Double.valueOf(snapshot.getMean()));
        testExecution.value(this.getMeterName(name) + ".max", Double.valueOf(snapshot.getMax()));
        testExecution.value(this.getMeterName(name) + ".stddev", Double.valueOf(snapshot.getStdDev()));
        testExecution.value(this.getMeterName(name) + ".median", Double.valueOf(snapshot.getMedian()));
        testExecution.value(this.getMeterName(name) + ".p75", Double.valueOf(snapshot.get75thPercentile()));
        testExecution.value(this.getMeterName(name) + ".p95", Double.valueOf(snapshot.get95thPercentile()));
        testExecution.value(this.getMeterName(name) + ".p98", Double.valueOf(snapshot.get98thPercentile()));
        testExecution.value(this.getMeterName(name) + ".p99", Double.valueOf(snapshot.get99thPercentile()));
        testExecution.value(this.getMeterName(name) + ".p999", Double.valueOf(snapshot.get999thPercentile()));
    }

    private void reportCounter(TestExecutionBuilder testExecution, String name, Counter counter) {
        testExecution.value(this.getMeterName(name) + ".count", Double.valueOf(counter.getCount()));
    }

    private void reportGauge(TestExecutionBuilder testExecution, String name, Gauge gauge) {
        String value = gauge.getValue().toString();
        Double dval = 0.0;
        String filteredValue = "";
        String paramValue = "";
        boolean end = false;
        for (int i = 0; i < value.length(); ++i) {
            String c = String.valueOf(value.charAt(i));
            if (end || !c.matches("[0-9]") && !c.equals(".")) {
                paramValue = paramValue + c;
                end = true;
                continue;
            }
            filteredValue = filteredValue + c;
        }
        if (!filteredValue.isEmpty()) {
            dval = Double.valueOf(filteredValue);
        }
        if ((paramValue = paramValue.trim()).isEmpty()) {
            testExecution.value(this.getMeterName(name) + ".value", dval);
        } else {
            testExecution.value(this.getMeterName(name) + ".value", dval, "unit", paramValue);
        }
    }

    protected String getMeterName(String name) {
        if (this.scheduled) {
            return name;
        }
        String a = name.substring(name.indexOf(".", "org.kie.perf.scenario".length() + 1) + 1);
        return a.substring(a.indexOf(".") + 1);
    }

    public static class Builder {
        private final MetricRegistry registry;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public PerfRepoReporter build(PerfRepoClient client) {
            return new PerfRepoReporter(this.registry, client, this.rateUnit, this.durationUnit, this.filter, false);
        }

        public PerfRepoReporter build(PerfRepoClient client, boolean scheduled) {
            return new PerfRepoReporter(this.registry, client, this.rateUnit, this.durationUnit, this.filter, scheduled);
        }
    }
}

