/*
 * Decompiled with CFR 0.152.
 */
package org.kie.perf;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.kie.perf.SharedMetricRegistry;
import org.kie.perf.TestConfig;
import org.kie.perf.annotation.KPKConstraint;
import org.kie.perf.metrics.CPUUsageHistogramSet;
import org.kie.perf.metrics.CsvSingleReporter;
import org.kie.perf.metrics.MemoryUsageGaugeSet;
import org.kie.perf.metrics.PerfRepoReporter;
import org.kie.perf.metrics.ThreadStatesGaugeSet;
import org.kie.perf.scenario.IPerfTest;
import org.kie.perf.suite.ITestSuite;
import org.perfrepo.client.PerfRepoClient;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Executor {
    private static final Logger log = LoggerFactory.getLogger(Executor.class);
    private static Executor instance;
    private ScheduledReporter reporter;
    private ITestSuite testSuite;

    public static Executor getInstance() throws Exception {
        if (instance == null) {
            instance = new Executor();
            instance.initReporter();
            instance.initTestSuite();
        }
        return instance;
    }

    private void initReporter() {
        MetricRegistry metrics = SharedMetricRegistry.getInstance();
        TestConfig tc = TestConfig.getInstance();
        TestConfig.ReporterType reporterType = tc.getReporterType();
        if (reporterType == TestConfig.ReporterType.CONSOLE) {
            this.reporter = ConsoleReporter.forRegistry((MetricRegistry)metrics).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
        } else if (reporterType == TestConfig.ReporterType.CSV) {
            File reportDataLocation = new File(tc.getReportDataLocation());
            if (!reportDataLocation.exists()) {
                reportDataLocation.mkdirs();
            }
            this.reporter = CsvReporter.forRegistry((MetricRegistry)metrics).formatFor(Locale.US).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(reportDataLocation);
            this.reporter.start((long)tc.getPeriodicity(), TimeUnit.SECONDS);
        } else if (reporterType == TestConfig.ReporterType.CSVSINGLE) {
            File reportDataLocation = new File(tc.getReportDataLocation());
            if (!reportDataLocation.exists()) {
                reportDataLocation.mkdirs();
            }
            this.reporter = CsvSingleReporter.forRegistry(metrics).formatFor(Locale.US).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(reportDataLocation);
        } else if (reporterType == TestConfig.ReporterType.PERFREPO) {
            PerfRepoClient client = new PerfRepoClient(tc.getPerfRepoHost(), tc.getPerfRepoUrlPath(), tc.getPerfRepoUsername(), tc.getPerfRepoPassword());
            this.reporter = PerfRepoReporter.forRegistry(metrics).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(client);
        }
    }

    public ScheduledReporter getReporter() {
        return this.reporter;
    }

    public void initTestSuite() throws Exception {
        Class<?> csuite = Class.forName("org.kie.perf.suite." + TestConfig.getInstance().getSuite());
        this.testSuite = (ITestSuite)csuite.newInstance();
    }

    public ITestSuite getTestSuite() {
        return this.testSuite;
    }

    public void initMetrics(IPerfTest scenario) {
        MetricRegistry metrics = SharedMetricRegistry.getInstance();
        TestConfig tc = TestConfig.getInstance();
        for (TestConfig.Measure m : tc.getMeasure()) {
            if (m == TestConfig.Measure.MEMORYUSAGE) {
                metrics.registerAll((MetricSet)new MemoryUsageGaugeSet(scenario.getClass()));
                continue;
            }
            if (m == TestConfig.Measure.FILEDESCRIPTORS) {
                metrics.register(MetricRegistry.name(scenario.getClass(), (String[])new String[]{"file.descriptors.usage"}), (Metric)new FileDescriptorRatioGauge());
                metrics.register(MetricRegistry.name(scenario.getClass(), (String[])new String[]{"file.descriptors.used"}), (Metric)new Gauge<Long>(){

                    public Long getValue() {
                        try {
                            OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
                            Method method = os.getClass().getDeclaredMethod("getOpenFileDescriptorCount", new Class[0]);
                            method.setAccessible(true);
                            return (Long)method.invoke((Object)os, new Object[0]);
                        }
                        catch (Exception exception) {
                            return -1L;
                        }
                    }
                });
                continue;
            }
            if (m == TestConfig.Measure.THREADSTATES) {
                metrics.registerAll((MetricSet)new ThreadStatesGaugeSet(scenario.getClass()));
                continue;
            }
            if (m != TestConfig.Measure.CPUUSAGE) continue;
            metrics.registerAll((MetricSet)CPUUsageHistogramSet.getInstance(scenario.getClass()));
        }
    }

    public Set<Class<? extends IPerfTest>> getScenarios(String testPackage) throws Exception {
        TestConfig tc = TestConfig.getInstance();
        Class<?> selectedScenario = null;
        HashSet<Class<? extends IPerfTest>> scenarios = new HashSet<Class<? extends IPerfTest>>();
        if (tc.getScenario() != null) {
            selectedScenario = Class.forName(testPackage + "." + tc.getScenario());
            scenarios.add(selectedScenario);
            return scenarios;
        }
        Reflections reflections = new Reflections(testPackage, new Scanner[0]);
        Set allScenarios = reflections.getSubTypesOf(IPerfTest.class);
        for (Class c : allScenarios) {
            if (Modifier.isAbstract(c.getModifiers())) continue;
            scenarios.add(c);
        }
        return scenarios;
    }

    public void forkScenario(String scenarioName) {
        ProcessBuilder processBuilder = new ProcessBuilder(TestConfig.getInstance().getStartScriptLocation(), scenarioName);
        try {
            Process process = processBuilder.start();
            InputStreamReader isr = new InputStreamReader(process.getInputStream());
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public KPKConstraint checkScenarioConstraints(Class<? extends IPerfTest> scenario) {
        KPKConstraint constraint = scenario.getAnnotation(KPKConstraint.class);
        if (constraint == null) {
            return null;
        }
        for (String c : constraint.value()) {
            String[] entry = null;
            boolean noteq = c.contains("!=");
            entry = noteq ? c.split("!=") : c.split("=");
            if (entry.length == 2) {
                String val = System.getProperty(entry[0]);
                if (val != null && (noteq || val.equals(entry[1])) && (!noteq || !val.equals(entry[1]))) continue;
                return constraint;
            }
            log.error("Scenario constraint entry '" + c + "' is in wrong format; should be 'propertyName=expectedValue'");
            return constraint;
        }
        return null;
    }

    public void performWarmUp(IPerfTest scenario) {
        TestConfig tc = TestConfig.getInstance();
        SharedMetricRegistry.setWarmUp(true);
        scenario.initMetrics();
        long endWarmUpTime = System.currentTimeMillis() + (long)(tc.getWarmUpTime() * 1000);
        log.debug("Starting JVM WarmUp for {} iterations or {} seconds, whatever comes first", (Object)tc.getWarmUpCount(), (Object)tc.getWarmUpTime());
        for (int i = 0; i < tc.getWarmUpCount() && endWarmUpTime > System.currentTimeMillis(); ++i) {
            scenario.execute();
        }
        log.debug("JVM WarmUp has ended");
        SharedMetricRegistry.setWarmUp(false);
    }

    public static void main(String[] args) {
        try {
            Executor exec = Executor.getInstance();
            TestConfig tc = TestConfig.getInstance();
            String msg = "======== SUITE: " + tc.getSuite();
            String scenarioName = tc.getScenario();
            if (scenarioName != null) {
                msg = msg + " / SCENARIO: " + scenarioName;
            }
            msg = msg + " ========";
            log.info(msg);
            exec.getTestSuite().start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

