/*
 * Decompiled with CFR 0.152.
 */
package org.kie.perf.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MemoryUsageGaugeSet
implements MetricSet {
    private Class<?> scenario;
    private final MemoryMXBean mxBean;
    private final List<MemoryPoolMXBean> memoryPools;

    public MemoryUsageGaugeSet(Class<?> scenario) {
        this.scenario = scenario;
        this.mxBean = ManagementFactory.getMemoryMXBean();
        this.memoryPools = new ArrayList<MemoryPoolMXBean>(ManagementFactory.getMemoryPoolMXBeans());
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Object> gauges = new HashMap<String, Object>();
        gauges.put(MetricRegistry.name(this.scenario, (String[])new String[]{"heap.init"}), new Gauge<String>(){

            public String getValue() {
                return MemoryUsageGaugeSet.readableFileSize(MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getInit());
            }
        });
        gauges.put(MetricRegistry.name(this.scenario, (String[])new String[]{"heap.used"}), new Gauge<String>(){

            public String getValue() {
                return MemoryUsageGaugeSet.readableFileSize(MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getUsed());
            }
        });
        gauges.put(MetricRegistry.name(this.scenario, (String[])new String[]{"heap.max"}), new Gauge<String>(){

            public String getValue() {
                return MemoryUsageGaugeSet.readableFileSize(MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getMax());
            }
        });
        gauges.put(MetricRegistry.name(this.scenario, (String[])new String[]{"heap.committed"}), new Gauge<String>(){

            public String getValue() {
                return MemoryUsageGaugeSet.readableFileSize(MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getCommitted());
            }
        });
        gauges.put(MetricRegistry.name(this.scenario, (String[])new String[]{"heap.usage"}), new Gauge<String>(){

            public String getValue() {
                MemoryUsage usage = MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage();
                NumberFormat percentFormat = NumberFormat.getPercentInstance();
                percentFormat.setMaximumFractionDigits(2);
                return percentFormat.format((double)usage.getUsed() / (double)usage.getMax());
            }
        });
        for (final MemoryPoolMXBean pool : this.memoryPools) {
            gauges.put(MetricRegistry.name(this.scenario, (String[])new String[]{pool.getName().toLowerCase().replace(" ", "."), "usage"}), new Gauge<String>(){

                public String getValue() {
                    long max = pool.getUsage().getMax() == -1L ? pool.getUsage().getCommitted() : pool.getUsage().getMax();
                    NumberFormat percentFormat = NumberFormat.getPercentInstance();
                    percentFormat.setMaximumFractionDigits(2);
                    return percentFormat.format((double)pool.getUsage().getUsed() / (double)max);
                }
            });
            gauges.put(MetricRegistry.name(this.scenario, (String[])new String[]{pool.getName().toLowerCase().replace(" ", "."), "used"}), new Gauge<String>(){

                public String getValue() {
                    return MemoryUsageGaugeSet.readableFileSize(pool.getUsage().getUsed());
                }
            });
        }
        return Collections.unmodifiableMap(gauges);
    }

    private static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }
}

