/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.enums;

import java.util.Arrays;
import java.util.OptionalDouble;
import java.util.stream.DoubleStream;
import org.kie.pmml.api.exceptions.KieEnumException;
import org.kie.pmml.api.exceptions.KiePMMLException;

public enum BUILTIN_FUNCTIONS {
    PLUS("+"),
    MINUS("-"),
    MULTI("*"),
    DIVISION("/"),
    MIN("min"),
    MAX("max"),
    SUM("sum"),
    AVG("avg"),
    MEDIAN("median"),
    PRODUCT("product"),
    LOG10("log10"),
    LN("ln"),
    SQRT("sqrt"),
    ABS("abs"),
    EXP("exp"),
    POW("pow"),
    THRESHOLD("threshold"),
    FLOOR("floor"),
    CEIL("ceil"),
    ROUND("round"),
    MODULO("modulo"),
    IS_MISSING("isMissing"),
    IS_NOT_MISSING("isNotMissing"),
    IS_VALID("isValid"),
    IS_NOT_VALID("isNotValid"),
    EQUAL("equal"),
    NOT_EQUAL("notEqual"),
    LESS_THAN("lessThan"),
    LESS_OR_EQUAL("lessOrEqual"),
    GREATER_THAN("greaterThan"),
    GREATER_OR_EQUAL("greaterOrEqual"),
    AND("and"),
    OR("or"),
    NOT("not"),
    IS_IN("isIn"),
    IS_NOT_IN("isNotIn"),
    IF("if"),
    UPPERCASE("uppercase"),
    LOWERCASE("lowercase"),
    STRING_LENGTH("stringLength"),
    SUBSTRING("substring"),
    TRIM_BLANKS("trimBlanks"),
    CONCAT("concat"),
    REPLACE("replace"),
    MATCHES("matches"),
    FORMAT_NUMBER("formatNumber"),
    FORMAT_DATE_TIME("formatDatetime"),
    DATE_DAYS_SINCE_YEAR("dateDaysSinceYear"),
    DATE_SECONDS_SINCE_YEAR("dateSecondsSinceYear"),
    DATE_SECONDS_SINCE_MIDNIGHT("dateSecondsSinceMidnight"),
    NORMAL_CDF("normalCDF"),
    NORMAL_PDF("normalPDF"),
    STD_NORMAL_CDF("stdNormalCDF"),
    STD_NORMAL_PDF("stdNormalPDF"),
    ERF("erf"),
    NORMAL_IDF("normalIDF"),
    STD_NORMAL_IDF("stdNormalIDF"),
    EXPM1("expm1"),
    HYPOT("hypot"),
    LN1P("ln1p"),
    RINT("rint"),
    SIN("sin"),
    ASIN("asin"),
    SINH("sinh"),
    COS("cos"),
    ACOS("acos"),
    COSH("cosh"),
    TAN("tan"),
    ATAN("atan"),
    TANH("tanh");

    private final String name;

    private BUILTIN_FUNCTIONS(String name) {
        this.name = name;
    }

    public static BUILTIN_FUNCTIONS byName(String name) {
        return Arrays.stream(BUILTIN_FUNCTIONS.values()).filter(value -> name.equals(value.name)).findFirst().orElseThrow(() -> new KieEnumException("Failed to find BUILTIN_FUNCTIONS with name: " + name));
    }

    public String getName() {
        return this.name;
    }

    public Object getValue(Object[] inputData) {
        switch (this) {
            case AVG: {
                return this.avg(inputData);
            }
            case LOWERCASE: {
                return this.lowercase(inputData);
            }
            case MAX: {
                return this.max(inputData);
            }
            case MEDIAN: {
                return this.median(inputData);
            }
            case MIN: {
                return this.min(inputData);
            }
            case MINUS: {
                return this.minus(inputData);
            }
            case MULTI: {
                return this.multi(inputData);
            }
            case DIVISION: {
                return this.division(inputData);
            }
            case PLUS: {
                return this.plus(inputData);
            }
            case PRODUCT: {
                return this.product(inputData);
            }
            case SUM: {
                return this.sum(inputData);
            }
            case UPPERCASE: {
                return this.uppercase(inputData);
            }
        }
        throw new KiePMMLException("Unmanaged BUILTIN_FUNCTIONS " + (Object)((Object)this));
    }

    private double avg(Object[] inputData) {
        this.checkNumbers(inputData, inputData.length);
        return Arrays.stream(inputData).mapToDouble(num -> ((Number)num).doubleValue()).average().orElseThrow(() -> new IllegalArgumentException("Failed to find average value"));
    }

    private double division(Object[] inputData) {
        this.checkNumbers(inputData, 2);
        double a = ((Number)inputData[0]).doubleValue();
        double b = ((Number)inputData[1]).doubleValue();
        return a / b;
    }

    private String lowercase(Object[] inputData) {
        this.checkStrings(inputData, 1);
        return ((String)inputData[0]).toLowerCase();
    }

    private double max(Object[] inputData) {
        this.checkNumbers(inputData, inputData.length);
        return Arrays.stream(inputData).mapToDouble(num -> ((Number)num).doubleValue()).max().orElseThrow(() -> new KieEnumException("Failed to find maximum value"));
    }

    private double median(Object[] inputData) {
        this.checkNumbers(inputData, inputData.length);
        DoubleStream sortedValues = Arrays.stream(inputData).mapToDouble(num -> ((Number)num).doubleValue()).sorted();
        OptionalDouble toReturn = inputData.length % 2 == 0 ? sortedValues.skip((long)(inputData.length / 2) - 1L).limit(2L).average() : sortedValues.skip(inputData.length / 2).findFirst();
        return toReturn.orElseThrow(() -> new KieEnumException("Failed to find median value"));
    }

    private double min(Object[] inputData) {
        this.checkNumbers(inputData, inputData.length);
        return Arrays.stream(inputData).mapToDouble(num -> ((Number)num).doubleValue()).min().orElseThrow(() -> new KieEnumException("Failed to find minimum value"));
    }

    private double minus(Object[] inputData) {
        this.checkNumbers(inputData, 2);
        double a = ((Number)inputData[0]).doubleValue();
        double b = ((Number)inputData[1]).doubleValue();
        return a - b;
    }

    private double multi(Object[] inputData) {
        this.checkNumbers(inputData, 2);
        double a = ((Number)inputData[0]).doubleValue();
        double b = ((Number)inputData[1]).doubleValue();
        return a * b;
    }

    private double plus(Object[] inputData) {
        this.checkNumbers(inputData, 2);
        double a = ((Number)inputData[0]).doubleValue();
        double b = ((Number)inputData[1]).doubleValue();
        return a + b;
    }

    private double product(Object[] inputData) {
        this.checkNumbers(inputData, inputData.length);
        return Arrays.stream(inputData).mapToDouble(num -> ((Number)num).doubleValue()).reduce(1.0, (a, b) -> a * b);
    }

    private double sum(Object[] inputData) {
        this.checkNumbers(inputData, inputData.length);
        return Arrays.stream(inputData).mapToDouble(num -> ((Number)num).doubleValue()).sum();
    }

    private String uppercase(Object[] inputData) {
        this.checkStrings(inputData, 1);
        return ((String)inputData[0]).toUpperCase();
    }

    private void checkNumbers(Object[] inputData, int expectedSize) {
        this.checkLength(inputData, expectedSize);
        for (Object object : inputData) {
            if (object instanceof Number) continue;
            throw new IllegalArgumentException("Expected only Numbers for " + (Object)((Object)this));
        }
    }

    private void checkStrings(Object[] inputData, int expectedSize) {
        this.checkLength(inputData, expectedSize);
        for (Object object : inputData) {
            if (object instanceof String) continue;
            throw new IllegalArgumentException("Expected only String for " + (Object)((Object)this));
        }
    }

    private void checkLength(Object[] inputData, int expectedSize) {
        if (inputData.length < 1) {
            throw new IllegalArgumentException(String.format("Expected at least one parameter %s ", new Object[]{this}));
        }
        if (inputData.length != expectedSize) {
            throw new IllegalArgumentException(String.format("Expected %s parameters %s ", new Object[]{expectedSize, this}));
        }
    }
}

