/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.enums;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import org.kie.pmml.api.exceptions.KieDataFieldException;
import org.kie.pmml.api.exceptions.KieEnumException;
import org.kie.pmml.api.utils.ConverterTypeUtil;

public enum DATA_TYPE {
    STRING("string", String.class),
    INTEGER("integer", Integer.TYPE),
    FLOAT("float", Float.TYPE),
    DOUBLE("double", Double.TYPE),
    BOOLEAN("boolean", Boolean.TYPE),
    DATE("date", Date.class),
    TIME("time", Date.class),
    DATE_TIME("dateTime", Date.class),
    DATE_DAYS_SINCE_0("dateDaysSince[0]", Long.class),
    DATE_DAYS_SINCE_1960("dateDaysSince[1960]", Long.class),
    DATE_DAYS_SINCE_1970("dateDaysSince[1970]", Long.class),
    DATE_DAYS_SINCE_1980("dateDaysSince[1980]", Long.class),
    TIME_SECONDS("timeSeconds", Long.class),
    DATE_TIME_SECONDS_SINCE_0("dateTimeSecondsSince[0]", Long.class),
    DATE_TIME_SECONDS_SINCE_1960("dateTimeSecondsSince[1960]", Long.class),
    DATE_TIME_SECONDS_SINCE_1970("dateTimeSecondsSince[1970]", Long.class),
    DATE_TIME_SECONDS_SINCE_1980("dateTimeSecondsSince[1980]", Long.class);

    private final String name;
    private final Class<?> mappedClass;

    private DATA_TYPE(String v, Class<?> c) {
        this.name = v;
        this.mappedClass = c;
    }

    public static DATA_TYPE byName(String name) {
        return Arrays.stream(DATA_TYPE.values()).filter(value -> Objects.equals(name, value.name)).findFirst().orElseThrow(() -> new KieEnumException("Failed to find DATA_TYPE with name: " + name));
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getMappedClass() {
        return this.mappedClass;
    }

    public Object getActualValue(Object rawValue) {
        if (this.mappedClass.isAssignableFrom(rawValue.getClass())) {
            return rawValue;
        }
        if (rawValue instanceof String) {
            String stringValue = (String)rawValue;
            try {
                switch (this) {
                    case STRING: {
                        return stringValue;
                    }
                    case INTEGER: {
                        return Integer.parseInt(stringValue);
                    }
                    case FLOAT: {
                        return Float.valueOf(Float.parseFloat(stringValue));
                    }
                    case DOUBLE: {
                        return Double.parseDouble(stringValue);
                    }
                    case BOOLEAN: {
                        return Boolean.parseBoolean(stringValue);
                    }
                    case DATE: {
                        return LocalDate.parse(stringValue);
                    }
                    case TIME: {
                        return LocalTime.parse(stringValue);
                    }
                    case DATE_TIME: {
                        return LocalDateTime.parse(stringValue);
                    }
                    case DATE_DAYS_SINCE_0: 
                    case DATE_DAYS_SINCE_1960: 
                    case DATE_DAYS_SINCE_1970: 
                    case DATE_DAYS_SINCE_1980: 
                    case TIME_SECONDS: 
                    case DATE_TIME_SECONDS_SINCE_0: 
                    case DATE_TIME_SECONDS_SINCE_1960: 
                    case DATE_TIME_SECONDS_SINCE_1970: 
                    case DATE_TIME_SECONDS_SINCE_1980: {
                        return Long.parseLong(stringValue);
                    }
                }
                throw new KieDataFieldException("Fail to convert " + rawValue + "[" + rawValue.getClass().getName() + "] to expected class " + this.mappedClass.getName());
            }
            catch (Exception e) {
                throw new KieDataFieldException("Fail to convert " + rawValue + "[" + rawValue.getClass().getName() + "] to expected class " + this.mappedClass.getName(), e);
            }
        }
        return ConverterTypeUtil.convert(this.mappedClass, rawValue);
    }
}

